/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractSimiContainerScreen<T extends Container>
extends ContainerScreen<T> {
    protected List<Widget> widgets = new ArrayList<Widget>();

    public AbstractSimiContainerScreen(T container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    protected void setWindowSize(int width, int height) {
        this.field_146999_f = width;
        this.field_147000_g = height;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.renderWindow(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
        GlStateManager.enableAlphaTest();
        GlStateManager.enableBlend();
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        for (Widget widget : this.widgets) {
            widget.render(mouseX, mouseY, partialTicks);
        }
        this.renderWindowForeground(mouseX, mouseY, partialTicks);
        for (Widget widget : this.widgets) {
            widget.renderToolTip(mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean result = false;
        for (Widget widget : this.widgets) {
            if (!widget.mouseClicked(x, y, button)) continue;
            result = true;
        }
        return result || super.mouseClicked(x, y, button);
    }

    public boolean keyPressed(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        for (Widget widget : this.widgets) {
            if (!widget.keyPressed(code, p_keyPressed_2_, p_keyPressed_3_)) continue;
            return true;
        }
        return super.keyPressed(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean charTyped(char character, int code) {
        for (Widget widget : this.widgets) {
            if (!widget.charTyped(character, code)) continue;
            return true;
        }
        if (character == 'e') {
            this.onClose();
        }
        return super.charTyped(character, code);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseScrolled(mouseX, mouseY, delta)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    public boolean mouseReleased(double x, double y, int button) {
        boolean result = false;
        for (Widget widget : this.widgets) {
            if (!widget.mouseReleased(x, y, button)) continue;
            result = true;
        }
        return result | super.mouseReleased(x, y, button);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected abstract void renderWindow(int var1, int var2, float var3);

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    protected void renderWindowForeground(int mouseX, int mouseY, float partialTicks) {
        this.func_191948_b(mouseX, mouseY);
        for (Widget widget : this.widgets) {
            if (!widget.isHovered() || !(widget instanceof AbstractSimiWidget) || ((AbstractSimiWidget)widget).getToolTip().isEmpty()) continue;
            this.renderTooltip(((AbstractSimiWidget)widget).getToolTip(), mouseX, mouseY);
        }
    }

    protected void renderItemOverlayIntoGUI(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int textColor) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                GlStateManager.disableLighting();
                GlStateManager.disableDepthTest();
                GlStateManager.disableTexture();
                GlStateManager.disableAlphaTest();
                GlStateManager.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                this.draw(bufferbuilder, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                this.draw(bufferbuilder, xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                GlStateManager.enableBlend();
                GlStateManager.enableAlphaTest();
                GlStateManager.enableTexture();
                GlStateManager.enableLighting();
                GlStateManager.enableDepthTest();
            }
            if (stack.func_190916_E() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                GlStateManager.disableLighting();
                GlStateManager.disableDepthTest();
                GlStateManager.disableBlend();
                GlStateManager.pushMatrix();
                int guiScaleFactor = (int)this.minecraft.field_195558_d.func_198100_s();
                GlStateManager.translated((double)((float)xPosition + 16.5f), (double)((float)yPosition + 16.5f), (double)0.0);
                double scale = this.getItemCountTextScale();
                GlStateManager.scaled((double)scale, (double)scale, (double)0.0);
                double d = (float)(-fr.func_78256_a(s)) - (guiScaleFactor > 1 ? 0.0f : -0.5f);
                this.font.getClass();
                GlStateManager.translated((double)d, (double)((float)(-9) + (guiScaleFactor > 1 ? 1.0f : 1.75f)), (double)0.0);
                fr.func_175063_a(s, 0.0f, 0.0f, textColor);
                GlStateManager.popMatrix();
                GlStateManager.enableBlend();
                GlStateManager.enableLighting();
                GlStateManager.enableDepthTest();
                GlStateManager.enableBlend();
            }
        }
    }

    public double getItemCountTextScale() {
        int guiScaleFactor = (int)this.minecraft.field_195558_d.func_198100_s();
        double scale = 1.0;
        switch (guiScaleFactor) {
            case 1: {
                scale = 1.005859375;
                break;
            }
            case 2: {
                scale = 0.5;
                break;
            }
            case 3: {
                scale = 0.675;
                break;
            }
            case 4: {
                scale = 0.75;
                break;
            }
            default: {
                scale = ((float)guiScaleFactor - 1.0f) / (float)guiScaleFactor;
            }
        }
        return scale;
    }

    private void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public List<Rectangle2d> getExtraAreas() {
        return Collections.emptyList();
    }
}

