/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class Label
extends AbstractSimiWidget {
    public String text;
    public String suffix;
    protected boolean hasShadow;
    protected int color;
    protected FontRenderer font;

    public Label(int x, int y, String text) {
        super(x, y, Minecraft.func_71410_x().field_71466_p.func_78256_a(text), 10);
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.text = "Label";
        this.color = 0xFFFFFF;
        this.hasShadow = false;
        this.suffix = "";
    }

    public Label colored(int color) {
        this.color = color;
        return this;
    }

    public Label withShadow() {
        this.hasShadow = true;
        return this;
    }

    public Label withSuffix(String s) {
        this.suffix = s;
        return this;
    }

    public void setTextAndTrim(String newText, boolean trimFront, int maxWidthPx) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        if (fontRenderer.func_78256_a(newText) <= maxWidthPx) {
            this.text = newText;
            return;
        }
        String trim = "...";
        int trimWidth = fontRenderer.func_78256_a(trim);
        StringBuilder builder = new StringBuilder(newText);
        int startIndex = trimFront ? 0 : newText.length() - 1;
        int endIndex = !trimFront ? 0 : newText.length() - 1;
        int step = (int)Math.signum(endIndex - startIndex);
        for (int i = startIndex; i != endIndex; i += step) {
            String sub = builder.substring(trimFront ? i : startIndex, trimFront ? endIndex + 1 : i + 1);
            if (fontRenderer.func_78256_a(sub) + trimWidth > maxWidthPx) continue;
            this.text = trimFront ? trim + sub : sub + trim;
            return;
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        if (this.text == null || this.text.isEmpty()) {
            return;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.hasShadow) {
            this.font.func_175063_a(this.text + this.suffix, (float)this.x, (float)this.y, this.color);
        } else {
            this.font.func_211126_b(this.text + this.suffix, (float)this.x, (float)this.y, this.color);
        }
    }
}

