/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.foundation.item.AllToolTypes;
import com.simibubi.create.foundation.item.EffectiveBlocks;
import com.simibubi.create.foundation.packet.SimplePacketBase;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class AbstractToolItem
extends ToolItem {
    protected AllToolTypes[] toolTypes;

    public AbstractToolItem(float attackDamageIn, float attackSpeedIn, IItemTier tier, Item.Properties builder, AllToolTypes ... types) {
        super(attackDamageIn, attackSpeedIn, tier, AbstractToolItem.getEffectiveBlocks(types), AbstractToolItem.setToolTypes(builder, tier, types));
        this.toolTypes = types;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        boolean canEnchant = super.canApplyAtEnchantingTable(stack, enchantment);
        block8: for (AllToolTypes type : this.toolTypes) {
            switch (type) {
                case AXE: {
                    canEnchant |= enchantment.func_92089_a(new ItemStack((IItemProvider)Items.field_151056_x));
                    continue block8;
                }
                case HOE: {
                    canEnchant |= enchantment.func_92089_a(new ItemStack((IItemProvider)Items.field_151012_L));
                    continue block8;
                }
                case PICKAXE: {
                    canEnchant |= enchantment.func_92089_a(new ItemStack((IItemProvider)Items.field_151046_w));
                    continue block8;
                }
                case SHEARS: {
                    canEnchant |= enchantment.func_92089_a(new ItemStack((IItemProvider)Items.field_151097_aZ));
                    continue block8;
                }
                case SHOVEL: {
                    canEnchant |= enchantment.func_92089_a(new ItemStack((IItemProvider)Items.field_151047_v));
                    continue block8;
                }
                case SWORD: {
                    canEnchant |= enchantment.func_92089_a(new ItemStack((IItemProvider)Items.field_151048_u));
                    continue block8;
                }
            }
        }
        return canEnchant;
    }

    private static Set<Block> getEffectiveBlocks(AllToolTypes ... types) {
        HashSet<Block> blocks = new HashSet<Block>();
        block8: for (AllToolTypes type : types) {
            switch (type) {
                case AXE: {
                    blocks.addAll(EffectiveBlocks.AXE);
                    continue block8;
                }
                case HOE: {
                    continue block8;
                }
                case PICKAXE: {
                    blocks.addAll(EffectiveBlocks.PICKAXE);
                    continue block8;
                }
                case SHEARS: {
                    continue block8;
                }
                case SHOVEL: {
                    blocks.addAll(EffectiveBlocks.SHOVEL);
                    continue block8;
                }
                case SWORD: {
                    continue block8;
                }
            }
        }
        return blocks;
    }

    private static Item.Properties setToolTypes(Item.Properties builder, IItemTier tier, AllToolTypes ... types) {
        for (AllToolTypes type : types) {
            if (type == AllToolTypes.PICKAXE) {
                builder.addToolType(ToolType.PICKAXE, tier.func_200925_d());
            }
            if (type == AllToolTypes.SHOVEL) {
                builder.addToolType(ToolType.SHOVEL, tier.func_200925_d());
            }
            if (type != AllToolTypes.AXE) continue;
            builder.addToolType(ToolType.AXE, tier.func_200925_d());
        }
        return builder;
    }

    protected boolean hasType(AllToolTypes typeIn) {
        for (AllToolTypes type : this.toolTypes) {
            if (type != typeIn) continue;
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.hasType(AllToolTypes.HOE) && !context.func_195998_g()) {
            return Items.field_151017_I.func_195939_a(context);
        }
        if (this.hasType(AllToolTypes.SHOVEL)) {
            return Items.field_151038_n.func_195939_a(context);
        }
        return super.func_195939_a(context);
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        int i = this.func_200891_e().func_200925_d();
        if (this.getToolTypes(stack).contains(state.getHarvestTool())) {
            return i >= state.getHarvestLevel();
        }
        Material material = state.func_185904_a();
        boolean canHarvestMaterial = false;
        if (this.hasType(AllToolTypes.PICKAXE)) {
            canHarvestMaterial |= material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
        }
        if (this.hasType(AllToolTypes.SHOVEL)) {
            canHarvestMaterial |= Items.field_151038_n.canHarvestBlock(stack, state);
        }
        if (this.hasType(AllToolTypes.SWORD)) {
            canHarvestMaterial |= Items.field_151041_m.canHarvestBlock(stack, state);
        }
        if (this.hasType(AllToolTypes.SHEARS)) {
            canHarvestMaterial |= Items.field_151097_aZ.func_150897_b(state);
        }
        return canHarvestMaterial;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !this.hasType(AllToolTypes.SWORD) || !player.func_184812_l_();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        if (this.hasType(AllToolTypes.PICKAXE) && (material == Material.field_151573_f || material == Material.field_151574_g || material == Material.field_151576_e)) {
            return this.field_77864_a;
        }
        if (this.hasType(AllToolTypes.AXE) && (material == Material.field_151575_d || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_215713_z)) {
            return this.field_77864_a;
        }
        if (this.hasType(AllToolTypes.SWORD) && (state.func_177230_c() == Blocks.field_196553_aF || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151589_v || state.func_203425_a(BlockTags.field_206952_E) || material == Material.field_151572_C)) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean modifiesDrops() {
        return false;
    }

    public void modifyDrops(Collection<ItemStack> drops, IWorld world, BlockPos pos, ItemStack tool, BlockState state) {
    }

    public void spawnParticles(IWorld world, BlockPos pos, ItemStack tool, BlockState state) {
    }

    public static class HarvestPacket
    extends SimplePacketBase {
        private BlockState state;
        private ItemStack stack;
        private BlockPos pos;
        private boolean self;

        public HarvestPacket(BlockState state, ItemStack stack, BlockPos pos, boolean self) {
            this.state = state;
            this.stack = stack;
            this.pos = pos;
            this.self = self;
        }

        public HarvestPacket(PacketBuffer buffer) {
            this.state = NBTUtil.func_190008_d((CompoundNBT)buffer.func_150793_b());
            this.stack = buffer.func_150791_c();
            this.pos = buffer.func_179259_c();
            this.self = buffer.readBoolean();
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_150786_a(NBTUtil.func_190009_a((BlockState)this.state));
            buffer.func_150788_a(this.stack);
            buffer.func_179255_a(this.pos);
            buffer.writeBoolean(this.self);
        }

        @Override
        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.spawnParticles(this.self)));
            context.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        void spawnParticles(boolean self) {
            if (!(this.stack.func_77973_b() instanceof AbstractToolItem)) {
                return;
            }
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (!self) {
                world.func_217379_c(2001, this.pos, Block.func_196246_j((BlockState)this.state));
            }
            ((AbstractToolItem)this.stack.func_77973_b()).spawnParticles((IWorld)world, this.pos, this.stack, this.state);
        }
    }
}

