/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.AllItems;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.config.CKinetics;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.contraptions.base.IRotate;
import com.simibubi.create.modules.contraptions.components.fan.EncasedFanBlock;
import com.simibubi.create.modules.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.modules.contraptions.components.flywheel.engine.FurnaceEngineBlock;
import com.simibubi.create.modules.contraptions.components.waterwheel.WaterWheelBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;

public class ItemDescription {
    public static final ItemDescription MISSING = new ItemDescription(null);
    public static ITextComponent trim = new StringTextComponent(TextFormatting.WHITE + "" + TextFormatting.STRIKETHROUGH + "                          ");
    private List<ITextComponent> lines;
    private List<ITextComponent> linesOnShift;
    private List<ITextComponent> linesOnCtrl;
    private Palette palette;

    public ItemDescription(Palette palette) {
        this.palette = palette;
        this.lines = new ArrayList<ITextComponent>();
        this.linesOnShift = new ArrayList<ITextComponent>();
        this.linesOnCtrl = new ArrayList<ITextComponent>();
    }

    public ItemDescription withSummary(String summary) {
        ItemDescription.add(this.linesOnShift, TooltipHelper.cutString(summary, this.palette.color, this.palette.hColor));
        ItemDescription.add(this.linesOnShift, "");
        return this;
    }

    public ItemDescription withKineticStats(Block block) {
        String level;
        int index;
        IRotate.StressImpact impactId;
        boolean isEngine = block instanceof EngineBlock;
        CKinetics config = AllConfigs.SERVER.kinetics;
        IRotate.SpeedLevel minimumRequiredSpeedLevel = isEngine ? IRotate.SpeedLevel.NONE : ((IRotate)block).getMinimumRequiredSpeedLevel();
        boolean hasSpeedRequirement = minimumRequiredSpeedLevel != IRotate.SpeedLevel.NONE;
        ResourceLocation id = block.getRegistryName();
        Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> impacts = config.stressValues.impacts;
        Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> capacities = config.stressValues.capacities;
        boolean hasStressImpact = impacts.containsKey(id) && (Double)impacts.get(id).get() > 0.0 && IRotate.StressImpact.isEnabled();
        boolean hasStressCapacity = capacities.containsKey(id) && IRotate.StressImpact.isEnabled();
        boolean hasGlasses = AllItems.GOGGLES.typeOf(Minecraft.func_71410_x().field_71439_g.func_184582_a(EquipmentSlotType.HEAD));
        String rpmUnit = Lang.translate("generic.unit.rpm", new Object[0]);
        if (hasSpeedRequirement) {
            List<String> speedLevels = Lang.translatedOptions("tooltip.speedRequirement", "none", "medium", "high");
            int index2 = minimumRequiredSpeedLevel.ordinal();
            String level2 = minimumRequiredSpeedLevel.getTextColor() + ItemDescription.makeProgressBar(3, index2) + speedLevels.get(index2);
            if (hasGlasses) {
                level2 = level2 + " (" + minimumRequiredSpeedLevel.getSpeedValue() + rpmUnit + "+)";
            }
            ItemDescription.add(this.linesOnShift, TextFormatting.GRAY + Lang.translate("tooltip.speedRequirement", new Object[0]));
            ItemDescription.add(this.linesOnShift, level2);
        }
        String stressUnit = Lang.translate("generic.unit.stress", new Object[0]);
        if (hasStressImpact && (isEngine || !((IRotate)block).hideStressImpact())) {
            List<String> stressLevels = Lang.translatedOptions("tooltip.stressImpact", "low", "medium", "high");
            double impact = (Double)impacts.get(id).get();
            impactId = impact >= (Double)config.highStressImpact.get() ? IRotate.StressImpact.HIGH : (impact >= (Double)config.mediumStressImpact.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
            index = impactId.ordinal();
            level = impactId.getAbsoluteColor() + ItemDescription.makeProgressBar(3, index) + stressLevels.get(index);
            if (hasGlasses) {
                level = level + " (" + impacts.get(id).get() + stressUnit + ")";
            }
            ItemDescription.add(this.linesOnShift, TextFormatting.GRAY + Lang.translate("tooltip.stressImpact", new Object[0]));
            ItemDescription.add(this.linesOnShift, level);
        }
        if (hasStressCapacity) {
            List<String> stressCapacityLevels = Lang.translatedOptions("tooltip.capacityProvided", "low", "medium", "high");
            double capacity = (Double)capacities.get(id).get();
            impactId = capacity >= (Double)config.highCapacity.get() ? IRotate.StressImpact.LOW : (capacity >= (Double)config.mediumCapacity.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.HIGH);
            index = IRotate.StressImpact.values().length - 2 - impactId.ordinal();
            level = impactId.getAbsoluteColor() + ItemDescription.makeProgressBar(3, index) + stressCapacityLevels.get(index);
            if (hasGlasses) {
                level = level + " (" + capacity + stressUnit + ")";
            }
            if (!isEngine && ((IRotate)block).showCapacityWithAnnotation()) {
                level = level + " " + TextFormatting.DARK_GRAY + TextFormatting.ITALIC + Lang.translate("tooltip.capacityProvided.asGenerator", new Object[0]);
            }
            ItemDescription.add(this.linesOnShift, TextFormatting.GRAY + Lang.translate("tooltip.capacityProvided", new Object[0]));
            ItemDescription.add(this.linesOnShift, level);
            String genSpeed = this.generatorSpeed(block, rpmUnit);
            if (!genSpeed.equals("")) {
                ItemDescription.add(this.linesOnShift, TextFormatting.GREEN + " " + genSpeed);
            }
        }
        if (hasSpeedRequirement || hasStressImpact || hasStressCapacity) {
            ItemDescription.add(this.linesOnShift, "");
        }
        return this;
    }

    public static String makeProgressBar(int length, int filledLength) {
        int i;
        String bar = " ";
        int emptySpaces = length - 1 - filledLength;
        for (i = 0; i <= filledLength; ++i) {
            bar = bar + "\u2588";
        }
        for (i = 0; i < emptySpaces; ++i) {
            bar = bar + "\u2592";
        }
        return bar + " ";
    }

    public ItemDescription withBehaviour(String condition, String behaviour) {
        ItemDescription.add(this.linesOnShift, TextFormatting.GRAY + condition);
        ItemDescription.add(this.linesOnShift, TooltipHelper.cutString(behaviour, this.palette.color, this.palette.hColor, 1));
        return this;
    }

    public ItemDescription withControl(String condition, String action) {
        ItemDescription.add(this.linesOnCtrl, TextFormatting.GRAY + condition);
        ItemDescription.add(this.linesOnCtrl, TooltipHelper.cutString(action, this.palette.color, this.palette.hColor, 1));
        return this;
    }

    public ItemDescription createTabs() {
        boolean hasControls;
        boolean hasDescription = !this.linesOnShift.isEmpty();
        boolean bl = hasControls = !this.linesOnCtrl.isEmpty();
        if (hasDescription || hasControls) {
            String[] holdKey = Lang.translate("tooltip.holdKey", "$").split("\\$");
            String[] holdKeyOrKey = Lang.translate("tooltip.holdKeyOrKey", "$", "$").split("\\$");
            String keyShift = Lang.translate("tooltip.keyShift", new Object[0]);
            String keyCtrl = Lang.translate("tooltip.keyCtrl", new Object[0]);
            for (List list : Arrays.asList(this.lines, this.linesOnShift, this.linesOnCtrl)) {
                boolean ctrl;
                boolean shift = list == this.linesOnShift;
                boolean bl2 = ctrl = list == this.linesOnCtrl;
                if (holdKey.length != 2 || holdKeyOrKey.length != 3) {
                    list.add(0, new StringTextComponent("Invalid lang formatting!"));
                    continue;
                }
                StringBuilder tabBuilder = new StringBuilder();
                tabBuilder.append(TextFormatting.DARK_GRAY);
                if (hasDescription && hasControls) {
                    tabBuilder.append(holdKeyOrKey[0]);
                    tabBuilder.append(shift ? this.palette.hColor : this.palette.color);
                    tabBuilder.append(keyShift);
                    tabBuilder.append(TextFormatting.DARK_GRAY);
                    tabBuilder.append(holdKeyOrKey[1]);
                    tabBuilder.append(ctrl ? this.palette.hColor : this.palette.color);
                    tabBuilder.append(keyCtrl);
                    tabBuilder.append(TextFormatting.DARK_GRAY);
                    tabBuilder.append(holdKeyOrKey[2]);
                } else {
                    tabBuilder.append(holdKey[0]);
                    tabBuilder.append((hasDescription ? shift : ctrl) ? this.palette.hColor : this.palette.color);
                    tabBuilder.append(hasDescription ? keyShift : keyCtrl);
                    tabBuilder.append(TextFormatting.DARK_GRAY);
                    tabBuilder.append(holdKey[1]);
                }
                list.add(0, new StringTextComponent(tabBuilder.toString()));
                if (!shift && !ctrl) continue;
                list.add(1, new StringTextComponent(""));
            }
        }
        if (!hasDescription) {
            this.linesOnShift = this.lines;
        }
        if (!hasControls) {
            this.linesOnCtrl = this.lines;
        }
        return this;
    }

    public static String hightlight(String s, Palette palette) {
        return palette.hColor + s + palette.color;
    }

    public static void add(List<ITextComponent> infoList, List<String> textLines) {
        textLines.forEach(s -> ItemDescription.add(infoList, s));
    }

    public static void add(List<ITextComponent> infoList, String line) {
        infoList.add((ITextComponent)new StringTextComponent(line));
    }

    public Palette getPalette() {
        return this.palette;
    }

    public List<ITextComponent> addInformation(List<ITextComponent> tooltip) {
        if (Screen.hasShiftDown()) {
            tooltip.addAll(this.linesOnShift);
            return tooltip;
        }
        if (Screen.hasControlDown()) {
            tooltip.addAll(this.linesOnCtrl);
            return tooltip;
        }
        tooltip.addAll(this.lines);
        return tooltip;
    }

    public List<ITextComponent> getLines() {
        return this.lines;
    }

    public List<ITextComponent> getLinesOnCtrl() {
        return this.linesOnCtrl;
    }

    public List<ITextComponent> getLinesOnShift() {
        return this.linesOnShift;
    }

    private String generatorSpeed(Block block, String unitRPM) {
        String value = "";
        if (block instanceof WaterWheelBlock) {
            int baseSpeed = (Integer)AllConfigs.SERVER.kinetics.waterWheelSpeed.get();
            value = baseSpeed + "-" + baseSpeed * 3;
        } else if (block instanceof EncasedFanBlock) {
            value = ((Integer)AllConfigs.SERVER.kinetics.generatingFanSpeed.get()).toString();
        } else if (block instanceof FurnaceEngineBlock) {
            int baseSpeed = (Integer)AllConfigs.SERVER.kinetics.furnaceEngineSpeed.get();
            value = baseSpeed + "-" + baseSpeed * 2;
        }
        return !value.equals("") ? Lang.translate("tooltip.generationSpeed", value, unitRPM) : "";
    }

    public static enum Palette {
        Blue(TextFormatting.BLUE, TextFormatting.AQUA),
        Green(TextFormatting.DARK_GREEN, TextFormatting.GREEN),
        Yellow(TextFormatting.GOLD, TextFormatting.YELLOW),
        Red(TextFormatting.DARK_RED, TextFormatting.RED),
        Purple(TextFormatting.DARK_PURPLE, TextFormatting.LIGHT_PURPLE);

        public TextFormatting color;
        public TextFormatting hColor;

        private Palette(TextFormatting primary, TextFormatting highlight) {
            this.color = primary;
            this.hColor = highlight;
        }
    }
}

