/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.type;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CountedItemsList {
    Map<Item, Set<ItemStackEntry>> items = new HashMap<Item, Set<ItemStackEntry>>();
    Collection<ItemStackEntry> flattenedList = new PriorityQueue<ItemStackEntry>();
    boolean flattenedListDirty = true;

    public CountedItemsList() {
    }

    public CountedItemsList(IItemHandler inventory) {
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            this.add(inventory.extractItem(slot, inventory.getSlotLimit(slot), true));
        }
    }

    public List<ItemStackEntry> getStacksToUpdate(CountedItemsList newList) {
        ArrayList<ItemStackEntry> changes = new ArrayList<ItemStackEntry>();
        for (Item key : Sets.union(this.items.keySet(), newList.items.keySet())) {
            Set<ItemStackEntry> currentSet = this.items.get(key);
            Set<ItemStackEntry> newSet = newList.items.get(key);
            if (currentSet == null) {
                changes.addAll(newSet);
                continue;
            }
            if (newSet == null) {
                currentSet.forEach(entry -> changes.add(new ItemStackEntry(entry.stack, 0)));
                continue;
            }
            HashSet<ItemStackEntry> remainderNew = new HashSet<ItemStackEntry>(newSet);
            block1: for (ItemStackEntry entry2 : currentSet) {
                for (ItemStackEntry newEntry : newSet) {
                    if (!entry2.matches(newEntry.stack)) continue;
                    remainderNew.remove(newEntry);
                    if (entry2.amount == newEntry.amount) continue block1;
                    changes.add(newEntry);
                    continue block1;
                }
                changes.add(new ItemStackEntry(entry2.stack, 0));
            }
            changes.addAll(remainderNew);
        }
        return changes;
    }

    public void add(ItemStack stack) {
        this.add(stack, stack.func_190916_E());
    }

    public void add(ItemStackEntry entry) {
        this.add(entry.stack, entry.amount);
    }

    public void add(ItemStack stack, int amount) {
        if (stack.func_190926_b()) {
            return;
        }
        Set<ItemStackEntry> stackSet = this.getOrCreateItemSet(stack);
        for (ItemStackEntry entry : stackSet) {
            if (!entry.matches(stack)) continue;
            entry.amount += amount;
            return;
        }
        stackSet.add(new ItemStackEntry(stack, amount));
        this.flattenedListDirty = true;
    }

    public boolean contains(ItemStack stack) {
        return this.getItemCount(stack) != 0;
    }

    public int getItemCount(ItemStack stack) {
        Set<ItemStackEntry> stackSet = this.getItemSet(stack);
        if (stackSet == null) {
            return 0;
        }
        for (ItemStackEntry entry : stackSet) {
            if (!entry.matches(stack)) continue;
            return entry.amount;
        }
        return 0;
    }

    public void setItemCount(ItemStack stack, int amount) {
        this.remove(stack);
        this.add(stack, amount);
    }

    public void remove(ItemStack stack) {
        Set<ItemStackEntry> stackSet = this.getItemSet(stack);
        if (stackSet == null) {
            return;
        }
        Iterator<ItemStackEntry> iterator = stackSet.iterator();
        while (iterator.hasNext()) {
            ItemStackEntry entry = iterator.next();
            if (!entry.matches(stack)) continue;
            iterator.remove();
            this.flattenedListDirty = true;
            return;
        }
    }

    public Collection<ItemStackEntry> getFlattenedList() {
        if (this.flattenedListDirty) {
            this.flattenedList.clear();
            this.items.values().forEach(set -> this.flattenedList.addAll((Collection<ItemStackEntry>)set));
            this.flattenedListDirty = false;
        }
        return this.flattenedList;
    }

    private Set<ItemStackEntry> getItemSet(ItemStack stack) {
        return this.items.get(stack.func_77973_b());
    }

    private Set<ItemStackEntry> getOrCreateItemSet(ItemStack stack) {
        if (!this.items.containsKey(stack.func_77973_b())) {
            this.items.put(stack.func_77973_b(), new HashSet());
        }
        return this.getItemSet(stack);
    }

    public static class ItemStackEntry
    implements Comparable<ItemStackEntry> {
        public ItemStack stack;
        public int amount;

        public ItemStackEntry(ItemStack stack) {
            this(stack, stack.func_190916_E());
        }

        public ItemStackEntry(CompoundNBT nbt) {
            this(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item")), nbt.func_74762_e("Amount"));
        }

        public ItemStackEntry(ItemStack stack, int amount) {
            this.stack = stack.func_77946_l();
            this.amount = amount;
        }

        public boolean matches(ItemStack other) {
            return ItemHandlerHelper.canItemStacksStack((ItemStack)other, (ItemStack)this.stack);
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("Item", (INBT)this.stack.serializeNBT());
            nbt.func_74768_a("Amount", this.amount);
            return nbt;
        }

        @Override
        public int compareTo(ItemStackEntry o) {
            return this.amount - o.amount;
        }
    }
}

