/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class AllShapes {
    public static final VoxelShaper CASING_14PX = AllShapes.shape(0.0, 0.0, 0.0, 16.0, 14.0, 16.0).forDirectional();
    public static final VoxelShaper CASING_12PX = AllShapes.shape(0.0, 0.0, 0.0, 16.0, 12.0, 16.0).forDirectional();
    public static final VoxelShaper CASING_11PX = AllShapes.shape(0.0, 0.0, 0.0, 16.0, 11.0, 16.0).forDirectional();
    public static final VoxelShaper MOTOR_BLOCK = AllShapes.shape(0.0, 3.0, 3.0, 16.0, 13.0, 13.0).forHorizontal(Direction.EAST);
    public static final VoxelShaper FOUR_VOXEL_POLE = AllShapes.shape(6.0, 0.0, 6.0, 10.0, 16.0, 10.0).forAxis();
    public static final VoxelShaper SIX_VOXEL_POLE = AllShapes.shape(5.0, 0.0, 5.0, 11.0, 16.0, 11.0).forAxis();
    public static final VoxelShaper BELT_FUNNEL = AllShapes.shape(3.0, -4.0, 11.0, 13.0, 8.0, 17.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper FUNNEL = AllShapes.shape(1.0, 1.0, 13.0, 15.0, 15.0, 17.0).forDirectional(Direction.SOUTH);
    public static final VoxelShaper EXTRACTOR = AllShapes.shape(4.0, 2.0, 11.0, 12.0, 10.0, 17.0).forDirectional(Direction.SOUTH).withVerticalShapes(AllShapes.cuboid(4.0, 11.0, 4.0, 12.0, 17.0, 12.0));
    public static final VoxelShaper TRANSPOSER = AllShapes.shape(4.0, 4.0, -1.0, 12.0, 12.0, 1.0).add(5.0, 5.0, 0.0, 11.0, 11.0, 16.0).add(4.0, 4.0, 11.0, 12.0, 12.0, 17.0).forDirectional(Direction.SOUTH);
    public static final VoxelShaper FURNACE_ENGINE = AllShapes.shape(1.0, 1.0, 0.0, 15.0, 15.0, 16.0).add(0.0, 0.0, 9.0, 16.0, 16.0, 14.0).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper PORTABLE_STORAGE_INTERFACE = AllShapes.shape(0.0, 0.0, 0.0, 16.0, 12.0, 16.0).add(3.0, 12.0, 3.0, 13.0, 16.0, 13.0).forDirectional();
    public static final VoxelShaper PULLEY = AllShapes.shape(0.0, 0.0, 0.0, 16.0, 16.0, 2.0).add(1.0, 1.0, 2.0, 15.0, 15.0, 14.0).add(0.0, 0.0, 14.0, 16.0, 16.0, 16.0).forHorizontalAxis();
    public static final VoxelShaper SPEED_CONTROLLER = AllShapes.shape(0.0, 0.0, 0.0, 16.0, 2.0, 16.0).add(1.0, 1.0, 1.0, 15.0, 15.0, 15.0).erase(0.0, 8.0, 5.0, 16.0, 16.0, 11.0).add(2.0, 9.0, 2.0, 14.0, 14.0, 14.0).erase(6.0, 11.0, 0.0, 10.0, 16.0, 16.0).forHorizontalAxis();
    public static final VoxelShaper HARVESTER_BASE = AllShapes.shape(0.0, 2.0, 0.0, 16.0, 14.0, 3.0).forDirectional(Direction.SOUTH);
    public static final VoxelShaper NOZZLE = AllShapes.shape(2.0, 0.0, 2.0, 14.0, 14.0, 14.0).add(1.0, 13.0, 1.0, 15.0, 15.0, 15.0).erase(3.0, 13.0, 3.0, 13.0, 15.0, 13.0).forDirectional();
    public static final VoxelShaper CRANK = AllShapes.shape(5.0, 0.0, 5.0, 11.0, 6.0, 11.0).add(1.0, 3.0, 1.0, 15.0, 8.0, 15.0).forDirectional();
    public static final VoxelShaper CART_ASSEMBLER = AllShapes.shape(VoxelShapes.func_197868_b()).add(-2.0, 0.0, 1.0, 18.0, 13.0, 15.0).forHorizontalAxis();
    public static final VoxelShape BASIN_BLOCK_SHAPE = AllShapes.shape(0.0, 2.0, 0.0, 16.0, 13.0, 16.0).erase(2.0, 5.0, 2.0, 14.0, 14.0, 14.0).add(2.0, 0.0, 2.0, 14.0, 2.0, 14.0).build();
    public static final VoxelShape CRUSHING_WHEEL_COLLISION_SHAPE = AllShapes.cuboid(0.0, 0.0, 0.0, 16.0, 22.0, 16.0);
    public static final VoxelShape MECHANICAL_PROCESSOR_SHAPE = AllShapes.shape(VoxelShapes.func_197868_b()).erase(4.0, 0.0, 4.0, 12.0, 16.0, 12.0).build();
    public static final VoxelShape TURNTABLE_SHAPE = AllShapes.shape(1.0, 4.0, 1.0, 15.0, 8.0, 15.0).add(5.0, 0.0, 5.0, 11.0, 4.0, 11.0).build();
    public static final VoxelShape CRATE_BLOCK_SHAPE = AllShapes.cuboid(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    public static final VoxelShape TABLE_POLE_SHAPE = AllShapes.shape(4.0, 0.0, 4.0, 12.0, 2.0, 12.0).add(5.0, 2.0, 5.0, 11.0, 14.0, 11.0).build();
    public static final VoxelShape BELT_COLLISION_MASK = AllShapes.cuboid(0.0, 0.0, 0.0, 16.0, 19.0, 16.0);
    public static final VoxelShape SCHEMATICANNON_SHAPE = AllShapes.shape(1.0, 0.0, 1.0, 15.0, 8.0, 15.0).add(0.5, 8.0, 0.5, 15.5, 11.0, 15.5).build();
    public static final VoxelShape PULLEY_MAGNET = AllShapes.shape(3.0, 0.0, 3.0, 13.0, 2.0, 13.0).add(FOUR_VOXEL_POLE.get(Direction.UP)).build();
    public static final VoxelShape MILLSTONE = AllShapes.shape(0.0, 0.0, 0.0, 16.0, 6.0, 16.0).add(2.0, 6.0, 2.0, 14.0, 13.0, 14.0).add(3.0, 13.0, 3.0, 13.0, 16.0, 13.0).build();
    public static final VoxelShape GAUGE_SHAPE_UP = AllShapes.shape(1.0, 0.0, 0.0, 15.0, 2.0, 16.0).add(2.0, 2.0, 1.0, 14.0, 14.0, 15.0).build();
    private static final VoxelShape PISTON_HEAD = ((BlockState)((BlockState)Blocks.field_150332_K.func_176223_P().func_206870_a((IProperty)DirectionalBlock.field_176387_N, (Comparable)Direction.UP)).func_206870_a((IProperty)PistonHeadBlock.field_176327_M, (Comparable)Boolean.valueOf(true))).func_196954_c(null, null);
    private static final VoxelShape PISTON_EXTENDED = AllShapes.shape(CASING_12PX.get(Direction.UP)).add(FOUR_VOXEL_POLE.get(Direction.Axis.Y)).build();
    private static final VoxelShape SMALL_GEAR_SHAPE = AllShapes.cuboid(2.0, 6.0, 2.0, 14.0, 10.0, 14.0);
    private static final VoxelShape LARGE_GEAR_SHAPE = AllShapes.cuboid(0.0, 6.0, 0.0, 16.0, 10.0, 16.0);
    private static final VoxelShape VERTICAL_TABLET_SHAPE = AllShapes.cuboid(3.0, 1.0, -1.0, 13.0, 15.0, 3.0);
    private static final VoxelShape SQUARE_TABLET_SHAPE = AllShapes.cuboid(2.0, 2.0, -1.0, 14.0, 14.0, 3.0);
    private static final VoxelShape LOGISTICS_TABLE_SLOPE = AllShapes.shape(0.0, 10.0, 15.0, 16.0, 14.0, 10.667).add(0.0, 12.0, 10.667, 16.0, 16.0, 6.333).add(0.0, 14.0, 6.333, 16.0, 18.0, 2.0).build();
    private static final VoxelShape SCHEMATICS_TABLE_SLOPE = AllShapes.shape(0.0, 10.0, 16.0, 16.0, 14.0, 11.0).add(0.0, 12.0, 11.0, 16.0, 16.0, 6.0).add(0.0, 14.0, 6.0, 16.0, 18.0, 1.0).build();
    public static final VoxelShaper MECHANICAL_PISTON_HEAD = AllShapes.shape(PISTON_HEAD).forDirectional();
    public static final VoxelShaper MECHANICAL_PISTON = CASING_12PX;
    public static final VoxelShaper MECHANICAL_PISTON_EXTENDED = AllShapes.shape(PISTON_EXTENDED).forDirectional();
    public static final VoxelShaper SMALL_GEAR = AllShapes.shape(SMALL_GEAR_SHAPE).add(SIX_VOXEL_POLE.get(Direction.Axis.Y)).forAxis();
    public static final VoxelShaper LARGE_GEAR = AllShapes.shape(LARGE_GEAR_SHAPE).add(SIX_VOXEL_POLE.get(Direction.Axis.Y)).forAxis();
    public static final VoxelShaper LOGISTICAL_CONTROLLER = AllShapes.shape(SQUARE_TABLET_SHAPE).forDirectional(Direction.SOUTH);
    public static final VoxelShaper REDSTONE_BRIDGE = AllShapes.shape(VERTICAL_TABLET_SHAPE).forDirectional(Direction.SOUTH).withVerticalShapes(LOGISTICAL_CONTROLLER.get(Direction.UP));
    public static final VoxelShaper LOGISTICS_TABLE = AllShapes.shape(TABLE_POLE_SHAPE).add(LOGISTICS_TABLE_SLOPE).forHorizontal(Direction.SOUTH);
    public static final VoxelShaper SCHEMATICS_TABLE = AllShapes.shape(TABLE_POLE_SHAPE).add(SCHEMATICS_TABLE_SLOPE).forDirectional(Direction.SOUTH);

    private static Builder shape(VoxelShape shape) {
        return new Builder(shape);
    }

    private static Builder shape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return AllShapes.shape(AllShapes.cuboid(x1, y1, z1, x2, y2, z2));
    }

    private static VoxelShape cuboid(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.func_208617_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    private static class Builder {
        VoxelShape shape;

        public Builder(VoxelShape shape) {
            this.shape = shape;
        }

        Builder add(VoxelShape shape) {
            this.shape = VoxelShapes.func_197872_a((VoxelShape)this.shape, (VoxelShape)shape);
            return this;
        }

        Builder add(double x1, double y1, double z1, double x2, double y2, double z2) {
            return this.add(AllShapes.cuboid(x1, y1, z1, x2, y2, z2));
        }

        Builder erase(double x1, double y1, double z1, double x2, double y2, double z2) {
            this.shape = VoxelShapes.func_197878_a((VoxelShape)this.shape, (VoxelShape)AllShapes.cuboid(x1, y1, z1, x2, y2, z2), (IBooleanFunction)IBooleanFunction.field_223234_e_);
            return this;
        }

        VoxelShape build() {
            return this.shape;
        }

        VoxelShaper build(BiFunction<VoxelShape, Direction, VoxelShaper> factory, Direction direction) {
            return factory.apply(this.shape, direction);
        }

        VoxelShaper build(BiFunction<VoxelShape, Direction.Axis, VoxelShaper> factory, Direction.Axis axis) {
            return factory.apply(this.shape, axis);
        }

        VoxelShaper forDirectional(Direction direction) {
            return this.build(VoxelShaper::forDirectional, direction);
        }

        VoxelShaper forAxis() {
            return this.build(VoxelShaper::forAxis, Direction.Axis.Y);
        }

        VoxelShaper forHorizontalAxis() {
            return this.build(VoxelShaper::forHorizontalAxis, Direction.Axis.Z);
        }

        VoxelShaper forHorizontal(Direction direction) {
            return this.build(VoxelShaper::forHorizontal, direction);
        }

        VoxelShaper forDirectional() {
            return this.forDirectional(Direction.UP);
        }
    }
}

