/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.extensions.IForgeItemStack;

public class NBTHelper {
    public static <T extends Enum<?>> T readEnum(String name, Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (enumConstants == null) {
            throw new IllegalArgumentException("Non-Enum class passed to readEnum(): " + enumClass.getName());
        }
        for (Enum t : enumConstants) {
            if (!t.name().equals(name)) continue;
            return (T)t;
        }
        return (T)enumConstants[0];
    }

    public static <T extends Enum<?>> String writeEnum(T enumConstant) {
        return enumConstant.name();
    }

    public static <T> ListNBT writeCompoundList(List<T> list, Function<T, CompoundNBT> serializer) {
        ListNBT listNBT = new ListNBT();
        list.forEach(t -> listNBT.add(serializer.apply(t)));
        return listNBT;
    }

    public static <T> List<T> readCompoundList(ListNBT listNBT, Function<CompoundNBT, T> deserializer) {
        ArrayList list = new ArrayList(listNBT.size());
        listNBT.forEach(inbt -> list.add(deserializer.apply((CompoundNBT)inbt)));
        return list;
    }

    public static ListNBT writeItemList(List<ItemStack> stacks) {
        return NBTHelper.writeCompoundList(stacks, IForgeItemStack::serializeNBT);
    }

    public static List<ItemStack> readItemList(ListNBT stacks) {
        return NBTHelper.readCompoundList(stacks, ItemStack::func_199557_a);
    }

    public static ListNBT writeAABB(AxisAlignedBB bb) {
        ListNBT bbtag = new ListNBT();
        bbtag.add((Object)new FloatNBT((float)bb.field_72340_a));
        bbtag.add((Object)new FloatNBT((float)bb.field_72338_b));
        bbtag.add((Object)new FloatNBT((float)bb.field_72339_c));
        bbtag.add((Object)new FloatNBT((float)bb.field_72336_d));
        bbtag.add((Object)new FloatNBT((float)bb.field_72337_e));
        bbtag.add((Object)new FloatNBT((float)bb.field_72334_f));
        return bbtag;
    }

    public static AxisAlignedBB readAABB(ListNBT bbtag) {
        if (bbtag == null || bbtag.isEmpty()) {
            return null;
        }
        return new AxisAlignedBB((double)bbtag.func_150308_e(0), (double)bbtag.func_150308_e(1), (double)bbtag.func_150308_e(2), (double)bbtag.func_150308_e(3), (double)bbtag.func_150308_e(4), (double)bbtag.func_150308_e(5));
    }
}

