/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import java.nio.ByteBuffer;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;

public class SuperByteBuffer {
    public static final int FORMAT_LENGTH = DefaultVertexFormats.field_176600_a.func_177338_f();
    protected ByteBuffer original;
    protected ByteBuffer mutable;
    private Matrix4f transforms;
    private Matrix4f t;
    private boolean shouldShiftUV;
    private boolean resetUV;
    private SpriteShiftEntry spriteShift;
    private float uTarget;
    private float vTarget;
    private boolean shouldLight;
    private IVertexLighter vertexLighter;
    private float lightOffsetX;
    private float lightOffsetY;
    private float lightOffsetZ;
    private int packedLightCoords;
    private boolean shouldColor;
    private int r;
    private int g;
    private int b;
    private int a;
    private float sheetSize;

    public SuperByteBuffer(ByteBuffer original) {
        original.rewind();
        this.original = original;
        this.mutable = GLAllocation.func_74524_c((int)original.capacity());
        this.mutable.order(original.order());
        this.mutable.limit(original.limit());
        this.mutable.put(this.original);
        this.mutable.rewind();
        this.t = new Matrix4f();
        this.transforms = new Matrix4f();
        this.transforms.setIdentity();
    }

    public ByteBuffer build() {
        this.original.rewind();
        this.mutable.rewind();
        float z = 0.0f;
        float z2 = 0.0f;
        Matrix4f t = this.transforms;
        for (int vertex = 0; vertex < this.vertexCount(this.original); ++vertex) {
            float x = this.getX(this.original, vertex);
            float y = this.getY(this.original, vertex);
            z = this.getZ(this.original, vertex);
            float x2 = t.m00 * x + t.m01 * y + t.m02 * z + t.m03;
            float y2 = t.m10 * x + t.m11 * y + t.m12 * z + t.m13;
            z2 = t.m20 * x + t.m21 * y + t.m22 * z + t.m23;
            this.putPos(this.mutable, vertex, x2, y2, z2);
            if (this.shouldColor) {
                int lumByte = this.getR(this.original, vertex);
                float lum = (float)(lumByte < 0 ? 255 + lumByte : lumByte) / 256.0f;
                int r2 = (int)((float)this.r * lum);
                int g2 = (int)((float)this.g * lum);
                int b2 = (int)((float)this.b * lum);
                this.putColor(this.mutable, vertex, (byte)r2, (byte)g2, (byte)b2, (byte)this.a);
            }
            if (this.shouldShiftUV) {
                float u = this.getU(this.original, vertex);
                float v = this.getV(this.original, vertex);
                float targetU = this.spriteShift.getTarget().func_94214_a((double)(this.spriteShift.getOriginal().func_188537_a(u) / this.sheetSize + this.uTarget * 16.0f));
                float targetV = this.spriteShift.getTarget().func_94207_b((double)(this.spriteShift.getOriginal().func_188536_b(v) / this.sheetSize + this.vTarget * 16.0f));
                this.putUV(this.mutable, vertex, targetU, targetV);
            }
            if (this.resetUV) {
                this.putUV(this.mutable, vertex, this.getU(this.original, vertex), this.getV(this.original, vertex));
            }
            if (!this.shouldLight) continue;
            if (this.vertexLighter != null) {
                this.putLight(this.mutable, vertex, this.vertexLighter.getPackedLight(x2 + this.lightOffsetX, y2 + this.lightOffsetY, z2 + this.lightOffsetZ));
                continue;
            }
            this.putLight(this.mutable, vertex, this.packedLightCoords);
        }
        t.setIdentity();
        this.shouldShiftUV = false;
        this.shouldColor = false;
        this.shouldLight = false;
        return this.mutable;
    }

    public void renderInto(BufferBuilder buffer) {
        if (this.original.limit() == 0) {
            return;
        }
        buffer.putBulkData(this.build());
    }

    public SuperByteBuffer translate(double x, double y, double z) {
        return this.translate((float)x, (float)y, (float)z);
    }

    public SuperByteBuffer translate(float x, float y, float z) {
        this.transforms.m03 += x;
        this.transforms.m13 += y;
        this.transforms.m23 += z;
        return this;
    }

    public SuperByteBuffer rotate(Direction.Axis axis, float angle) {
        if (angle == 0.0f) {
            return this;
        }
        this.t.setIdentity();
        if (axis == Direction.Axis.X) {
            this.t.rotX(angle);
        } else if (axis == Direction.Axis.Y) {
            this.t.rotY(angle);
        } else {
            this.t.rotZ(angle);
        }
        this.transforms.mul(this.t, this.transforms);
        return this;
    }

    public SuperByteBuffer rotateCentered(Direction.Axis axis, float angle) {
        return this.translate(-0.5f, -0.5f, -0.5f).rotate(axis, angle).translate(0.5f, 0.5f, 0.5f);
    }

    public SuperByteBuffer shiftUV(SpriteShiftEntry entry) {
        this.shouldShiftUV = true;
        this.resetUV = false;
        this.spriteShift = entry;
        this.uTarget = 0.0f;
        this.vTarget = 0.0f;
        this.sheetSize = 1.0f;
        return this;
    }

    public SuperByteBuffer shiftUVtoSheet(SpriteShiftEntry entry, float uTarget, float vTarget, int sheetSize) {
        this.shouldShiftUV = true;
        this.resetUV = false;
        this.spriteShift = entry;
        this.uTarget = uTarget;
        this.vTarget = vTarget;
        this.sheetSize = sheetSize;
        return this;
    }

    public SuperByteBuffer dontShiftUV() {
        this.shouldShiftUV = false;
        this.resetUV = true;
        return this;
    }

    public SuperByteBuffer light(int packedLightCoords) {
        this.shouldLight = true;
        this.vertexLighter = null;
        this.packedLightCoords = packedLightCoords;
        return this;
    }

    public SuperByteBuffer light(IVertexLighter lighter) {
        this.shouldLight = true;
        this.vertexLighter = lighter;
        return this;
    }

    public SuperByteBuffer offsetLighting(double x, double y, double z) {
        this.lightOffsetX = (float)x;
        this.lightOffsetY = (float)y;
        this.lightOffsetZ = (float)z;
        return this;
    }

    public SuperByteBuffer color(int color) {
        this.shouldColor = true;
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
        this.a = 255;
        return this;
    }

    protected int vertexCount(ByteBuffer buffer) {
        return buffer.limit() / FORMAT_LENGTH;
    }

    protected int getBufferPosition(int vertexIndex) {
        return vertexIndex * FORMAT_LENGTH;
    }

    protected float getX(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index));
    }

    protected float getY(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 4);
    }

    protected float getZ(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 8);
    }

    protected byte getR(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 12);
    }

    protected byte getG(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 13);
    }

    protected byte getB(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 14);
    }

    protected byte getA(ByteBuffer buffer, int index) {
        return buffer.get(this.getBufferPosition(index) + 15);
    }

    protected float getU(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 16);
    }

    protected float getV(ByteBuffer buffer, int index) {
        return buffer.getFloat(this.getBufferPosition(index) + 20);
    }

    protected void putPos(ByteBuffer buffer, int index, float x, float y, float z) {
        int pos = this.getBufferPosition(index);
        buffer.putFloat(pos, x);
        buffer.putFloat(pos + 4, y);
        buffer.putFloat(pos + 8, z);
    }

    protected void putUV(ByteBuffer buffer, int index, float u, float v) {
        int pos = this.getBufferPosition(index);
        buffer.putFloat(pos + 16, u);
        buffer.putFloat(pos + 20, v);
    }

    protected void putLight(ByteBuffer buffer, int index, int packedLight) {
        buffer.putInt(this.getBufferPosition(index) + 24, packedLight);
    }

    protected void putColor(ByteBuffer buffer, int index, byte r, byte g, byte b, byte a) {
        int bufferPosition = this.getBufferPosition(index);
        buffer.put(bufferPosition + 12, r);
        buffer.put(bufferPosition + 13, g);
        buffer.put(bufferPosition + 14, b);
        buffer.put(bufferPosition + 15, a);
    }

    public static interface IVertexLighter {
        public int getPackedLight(float var1, float var2, float var3);
    }
}

