/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class TessellatorHelper {
    public static final float fontScale = 0.001953125f;

    public static void prepareForDrawing() {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.pushMatrix();
        GlStateManager.pushLightingAttributes();
        GlStateManager.enableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ActiveRenderInfo renderInfo = mc.field_71460_t.func_215316_n();
        Vec3d view = renderInfo.func_216785_c();
        GlStateManager.translated((double)(-view.field_72450_a), (double)(-view.field_72448_b), (double)(-view.field_72449_c));
    }

    public static void prepareFastRender() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.func_71379_u()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void fightZFighting(int id) {
        long randomBits = (long)id * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float xNudge = (((float)(randomBits >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float yNudge = (((float)(randomBits >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float zNudge = (((float)(randomBits >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        GlStateManager.translatef((float)xNudge, (float)yNudge, (float)zNudge);
    }

    public static void begin() {
        TessellatorHelper.begin(DefaultVertexFormats.field_181707_g);
    }

    public static void begin(VertexFormat format) {
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, format);
    }

    public static void draw() {
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void cleanUpAfterDrawing() {
        GlStateManager.popAttributes();
        GlStateManager.popMatrix();
        GlStateManager.disableBlend();
    }

    public static void drawString(String str, float x, float y, float z, boolean scalesUp, boolean hasDepth) {
        Minecraft mc = Minecraft.func_71410_x();
        float pitch = mc.func_175598_ae().field_78732_j;
        float yaw = mc.func_175598_ae().field_78735_i;
        boolean isThirdPersonFrontal = mc.field_71474_y.field_74320_O == 2;
        GlStateManager.pushMatrix();
        GlStateManager.pushLightingAttributes();
        GlStateManager.translatef((float)x, (float)y, (float)z);
        GlStateManager.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)(isThirdPersonFrontal ? -1 : 1) * pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.disableLighting();
        if (!hasDepth) {
            GlStateManager.depthMask((boolean)false);
            GlStateManager.disableDepthTest();
        }
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = mc.field_71466_p.func_78256_a(str) / 2;
        GlStateManager.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)(-i - 3), -3.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        bufferbuilder.func_181662_b((double)(-i - 3), 10.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + 3), 10.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + 3), -3.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        if (scalesUp) {
            double distance = mc.field_71439_g.func_174824_e(mc.func_184121_ak()).func_186679_c((double)x, (double)y, (double)z);
            double scale = distance * 0.001953125;
            GlStateManager.scaled((double)(2.0 + scale), (double)(2.0 + scale), (double)(2.0 + scale));
        }
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
        if (hasDepth) {
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-0.125f);
        }
        mc.field_71466_p.func_211126_b(str, (float)(-mc.field_71466_p.func_78256_a(str) / 2), 0.0f, 0);
        GlStateManager.enableDepthTest();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.popMatrix();
        GlStateManager.popAttributes();
    }

    public static void cube(BufferBuilder bufferBuilder, BlockPos pos, BlockPos size, double scale, boolean scaleVertical, boolean doubleFaces) {
        TessellatorHelper.walls(bufferBuilder, pos, size, scale, scaleVertical, doubleFaces);
        int w = size.func_177958_n();
        int h = size.func_177956_o();
        int l = size.func_177952_p();
        if (doubleFaces) {
            TessellatorHelper.doubleFace(bufferBuilder, pos, new BlockPos(w, 0, l), scale, true, scaleVertical, false);
            TessellatorHelper.doubleFace(bufferBuilder, pos.func_177965_g(w).func_177981_b(h), new BlockPos(-w, 0, l), scale, true, scaleVertical, false);
        } else {
            TessellatorHelper.face(bufferBuilder, pos, new BlockPos(w, 0, l), scale, true, scaleVertical, false, false);
            TessellatorHelper.face(bufferBuilder, pos.func_177965_g(w).func_177981_b(h), new BlockPos(-w, 0, l), scale, true, scaleVertical, false, false);
        }
    }

    public static void walls(BufferBuilder bufferBuilder, BlockPos pos, BlockPos size, double scale, boolean scaleVertical, boolean doubleFaces) {
        int w = size.func_177958_n();
        int h = size.func_177956_o();
        int l = size.func_177952_p();
        if (doubleFaces) {
            TessellatorHelper.doubleFace(bufferBuilder, pos, new BlockPos(w, h, 0), scale, true, scaleVertical, false);
            TessellatorHelper.doubleFace(bufferBuilder, pos.func_177965_g(w).func_177970_e(l), new BlockPos(0, h, -l), scale, true, scaleVertical, false);
            TessellatorHelper.doubleFace(bufferBuilder, pos.func_177965_g(w).func_177970_e(l), new BlockPos(-w, h, 0), scale, true, scaleVertical, false);
            TessellatorHelper.doubleFace(bufferBuilder, pos, new BlockPos(0, h, l), scale, true, scaleVertical, false);
        } else {
            TessellatorHelper.face(bufferBuilder, pos, new BlockPos(w, h, 0), scale, true, scaleVertical, false, false);
            TessellatorHelper.face(bufferBuilder, pos.func_177965_g(w).func_177970_e(l), new BlockPos(0, h, -l), scale, true, scaleVertical, false, false);
            TessellatorHelper.face(bufferBuilder, pos.func_177965_g(w).func_177970_e(l), new BlockPos(-w, h, 0), scale, true, scaleVertical, false, false);
            TessellatorHelper.face(bufferBuilder, pos, new BlockPos(0, h, l), scale, true, scaleVertical, false, false);
        }
    }

    public static void doubleFace(BufferBuilder bufferBuilder, BlockPos pos, BlockPos size, double shift, boolean stretch, boolean shiftVertical, boolean mirrorTexture) {
        TessellatorHelper.face(bufferBuilder, pos, size, shift, stretch, shiftVertical, false, mirrorTexture);
        TessellatorHelper.face(bufferBuilder, pos.func_177982_a(size.func_177958_n(), 0, size.func_177956_o() == 0 ? 0 : size.func_177952_p()), new BlockPos(-size.func_177958_n(), size.func_177956_o(), size.func_177956_o() == 0 ? size.func_177952_p() : -size.func_177952_p()), -shift, stretch, shiftVertical, true, mirrorTexture);
    }

    public static void face(BufferBuilder bufferBuilder, BlockPos pos, BlockPos size, double shift, boolean stretch, boolean shiftVertical, boolean shiftBackwards, boolean mirrorTexture) {
        int w = size.func_177958_n();
        int h = size.func_177956_o();
        int l = size.func_177952_p();
        if (shiftBackwards) {
            shift = -shift;
        }
        if (w == 0) {
            double zs1;
            double xs;
            double d = xs = l < 0 ? shift : -shift;
            if (shiftBackwards) {
                xs = -xs;
            }
            double ys1 = shiftVertical ? shift : 0.0;
            double d2 = zs1 = l < 0 ? -shift : shift;
            if (!stretch && l > 0 ^ mirrorTexture) {
                zs1 = -zs1;
            }
            double ys2 = stretch ? -ys1 : ys1;
            double zs2 = stretch ? -zs1 : zs1;
            double u1 = mirrorTexture ? (double)l : 0.0;
            double u2 = mirrorTexture ? 0.0 : (double)l;
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs, ys2, zs1), pos.func_177970_e(l), u2, h);
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs, ys1, zs1), pos.func_177970_e(l).func_177981_b(h), u2, 0.0);
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs, ys1, zs2), pos.func_177981_b(h), u1, 0.0);
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs, ys2, zs2), pos, u1, h);
        } else if (h == 0) {
            double ys;
            double d = ys = w < 0 ? shift : -shift;
            if (shiftBackwards) {
                ys = -ys;
            }
            double xs1 = w < 0 ? -shift : shift;
            double zs1 = shift;
            double xs2 = stretch ? -xs1 : xs1;
            double zs2 = stretch ? -zs1 : zs1;
            double u1 = mirrorTexture ? (double)w : 0.0;
            double u2 = mirrorTexture ? 0.0 : (double)w;
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs2, ys, zs1), pos.func_177970_e(l), u1, l);
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs2, ys, zs2), pos, u1, 0.0);
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs1, ys, zs2), pos.func_177965_g(w), u2, 0.0);
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs1, ys, zs1), pos.func_177965_g(w).func_177970_e(l), u2, l);
        } else if (l == 0) {
            double xs1;
            double zs;
            double d = zs = w < 0 ? shift : -shift;
            if (shiftBackwards) {
                zs = -zs;
            }
            double ys1 = shiftVertical ? shift : 0.0;
            double d3 = xs1 = w < 0 ? -shift : shift;
            if (!stretch && w > 0 ^ mirrorTexture) {
                xs1 = -xs1;
            }
            double ys2 = stretch ? -ys1 : ys1;
            double xs2 = stretch ? -xs1 : xs1;
            double u1 = mirrorTexture ? (double)w : 0.0;
            double u2 = mirrorTexture ? 0.0 : (double)w;
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs2, ys2, zs), pos, u1, h);
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs2, ys1, zs), pos.func_177981_b(h), u1, 0.0);
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs1, ys1, zs), pos.func_177965_g(w).func_177981_b(h), u2, 0.0);
            TessellatorHelper.posTexShift(bufferBuilder, new Vec3d(xs1, ys2, zs), pos.func_177965_g(w), u2, h);
        }
    }

    private static void posTexShift(BufferBuilder bufferBuilder, Vec3d shift, BlockPos pos, double u, double v) {
        bufferBuilder.func_181662_b(shift.field_72450_a + (double)pos.func_177958_n(), shift.field_72448_b + (double)pos.func_177956_o(), shift.field_72449_c + (double)pos.func_177952_p()).func_187315_a(u, v).func_181675_d();
    }
}

