/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.Random;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class VecHelper {
    public static Vec3d rotate(Vec3d vec, double xRot, double yRot, double zRot) {
        return VecHelper.rotate(VecHelper.rotate(VecHelper.rotate(vec, xRot, Direction.Axis.X), yRot, Direction.Axis.Y), zRot, Direction.Axis.Z);
    }

    public static Vec3d rotateCentered(Vec3d vec, double deg, Direction.Axis axis) {
        Vec3d shift = VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a);
        return VecHelper.rotate(vec.func_178788_d(shift), deg, axis).func_178787_e(shift);
    }

    public static Vec3d rotate(Vec3d vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = MathHelper.func_76126_a((float)angle);
        double cos = MathHelper.func_76134_b((float)angle);
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        if (axis == Direction.Axis.X) {
            return new Vec3d(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vec3d(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vec3d(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static boolean isVecPointingTowards(Vec3d vec, Direction direction) {
        return new Vec3d(direction.func_176730_m()).func_72438_d(vec.func_72432_b()) < 0.75;
    }

    public static Vec3d getCenterOf(Vec3i pos) {
        return new Vec3d(pos).func_72441_c(0.5, 0.5, 0.5);
    }

    public static Vec3d offsetRandomly(Vec3d vec, Random r, float radius) {
        return new Vec3d(vec.field_72450_a + (double)((r.nextFloat() - 0.5f) * 2.0f * radius), vec.field_72448_b + (double)((r.nextFloat() - 0.5f) * 2.0f * radius), vec.field_72449_c + (double)((r.nextFloat() - 0.5f) * 2.0f * radius));
    }

    public static Vec3d planeByNormal(Vec3d vec) {
        vec = vec.func_72432_b();
        return new Vec3d(1.0, 1.0, 1.0).func_178786_a(Math.abs(vec.field_72450_a), Math.abs(vec.field_72448_b), Math.abs(vec.field_72449_c));
    }

    public static ListNBT writeNBT(Vec3d vec) {
        ListNBT listnbt = new ListNBT();
        listnbt.add((Object)new DoubleNBT(vec.field_72450_a));
        listnbt.add((Object)new DoubleNBT(vec.field_72448_b));
        listnbt.add((Object)new DoubleNBT(vec.field_72449_c));
        return listnbt;
    }

    public static Vec3d readNBT(ListNBT list) {
        return new Vec3d(list.func_150309_d(0), list.func_150309_d(1), list.func_150309_d(2));
    }

    public static Vec3d voxelSpace(double x, double y, double z) {
        return new Vec3d(x, y, z).func_186678_a(0.0625);
    }

    public static int getCoordinate(Vec3i pos, Direction.Axis axis) {
        return axis.func_196052_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static float getCoordinate(Vec3d vec, Direction.Axis axis) {
        return (float)axis.func_196051_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static boolean onSameAxis(BlockPos pos1, BlockPos pos2, Direction.Axis axis) {
        if (pos1.equals((Object)pos2)) {
            return true;
        }
        for (Direction.Axis otherAxis : Direction.Axis.values()) {
            if (axis == otherAxis || VecHelper.getCoordinate((Vec3i)pos1, otherAxis) == VecHelper.getCoordinate((Vec3i)pos2, otherAxis)) continue;
            return false;
        }
        return true;
    }
}

