/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public interface ITaggable<T extends ITaggable<T>> {
    default public T withTags(ResourceLocation ... tagsIn) {
        return this.withTags(TagType.BLOCK, tagsIn).withTags(TagType.ITEM, tagsIn);
    }

    default public T withTags(TagType type, ResourceLocation ... tagsIn) {
        Collections.addAll(this.getTagSet(type), tagsIn);
        return (T)this;
    }

    default public T withTagsInNamespace(String namespace, String ... tagsIn) {
        return this.withTags((ResourceLocation[])Arrays.stream(tagsIn).map(s -> new ResourceLocation(namespace, s)).toArray(ResourceLocation[]::new));
    }

    default public T withTagsInNamespace(TagType type, String namespace, String ... tagsIn) {
        return this.withTags(type, (ResourceLocation[])Arrays.stream(tagsIn).map(s -> new ResourceLocation(namespace, s)).toArray(ResourceLocation[]::new));
    }

    default public T withCreateTags(String ... tagsIn) {
        return this.withTagsInNamespace("create", tagsIn);
    }

    default public T withForgeTags(String ... tagsIn) {
        return this.withTagsInNamespace("forge", tagsIn);
    }

    default public T withVanillaTags(String ... tagsIn) {
        return this.withTagsInNamespace("minecraft", tagsIn);
    }

    default public T withVanillaTags(TagType type, String ... tagsIn) {
        return this.withTagsInNamespace(type, "minecraft", tagsIn);
    }

    public Set<ResourceLocation> getTagSet(TagType var1);

    public static enum TagType {
        BLOCK,
        ITEM;

    }
}

