/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.outliner;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.GlHelper;
import com.simibubi.create.foundation.utility.outliner.Outline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class AABBOutline
extends Outline {
    protected AxisAlignedBB bb;
    protected AllSpecialTextures faceTexture;
    protected AllSpecialTextures highlightedTexture;
    protected Direction highlightedFace;
    public boolean disableCull = false;

    public AABBOutline(AxisAlignedBB bb) {
        this.bb = bb;
    }

    @Override
    public void render(BufferBuilder buffer) {
        this.begin();
        Vec3d color = ColorHelper.getRGB(0xFFFFFF);
        float alpha = 1.0f;
        this.renderBB(this.bb, buffer, color, alpha, !this.disableCull);
        this.draw();
    }

    public void setTextures(AllSpecialTextures faceTexture, AllSpecialTextures highlightTexture) {
        this.faceTexture = faceTexture;
        this.highlightedTexture = highlightTexture;
    }

    public void highlightFace(Direction face) {
        this.highlightedFace = face;
    }

    public void renderBB(AxisAlignedBB bb, BufferBuilder buffer, Vec3d color, float alpha, boolean doCulling) {
        Vec3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        boolean inside = bb.func_72318_a(projectedView);
        bb = bb.func_186662_g(inside ? -0.0078125 : 0.0078125);
        Vec3d xyz = new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        Vec3d Xyz = new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
        Vec3d xYz = new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        Vec3d XYz = new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
        Vec3d xyZ = new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
        Vec3d XyZ = new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
        Vec3d xYZ = new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
        Vec3d XYZ = new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        if (doCulling) {
            GlStateManager.enableCull();
            if (inside) {
                GlStateManager.disableCull();
            }
        }
        this.renderFace(Direction.NORTH, xYz, XYz, Xyz, xyz, buffer);
        this.renderFace(Direction.SOUTH, XYZ, xYZ, xyZ, XyZ, buffer);
        this.renderFace(Direction.EAST, XYz, XYZ, XyZ, Xyz, buffer);
        this.renderFace(Direction.WEST, xYZ, xYz, xyz, xyZ, buffer);
        this.renderFace(Direction.UP, xYZ, XYZ, XYz, xYz, buffer);
        this.renderFace(Direction.DOWN, xyz, Xyz, XyZ, xyZ, buffer);
        if (doCulling) {
            GlStateManager.enableCull();
        }
        Vec3d start = xyz;
        AllSpecialTextures.BLANK.bind();
        this.renderAACuboidLine(start, Xyz, color, alpha, buffer);
        this.renderAACuboidLine(start, xYz, color, alpha, buffer);
        this.renderAACuboidLine(start, xyZ, color, alpha, buffer);
        start = XyZ;
        this.renderAACuboidLine(start, xyZ, color, alpha, buffer);
        this.renderAACuboidLine(start, XYZ, color, alpha, buffer);
        this.renderAACuboidLine(start, Xyz, color, alpha, buffer);
        start = XYz;
        this.renderAACuboidLine(start, xYz, color, alpha, buffer);
        this.renderAACuboidLine(start, Xyz, color, alpha, buffer);
        this.renderAACuboidLine(start, XYZ, color, alpha, buffer);
        start = xYZ;
        this.renderAACuboidLine(start, XYZ, color, alpha, buffer);
        this.renderAACuboidLine(start, xyZ, color, alpha, buffer);
        this.renderAACuboidLine(start, xYz, color, alpha, buffer);
    }

    protected void renderFace(Direction direction, Vec3d p1, Vec3d p2, Vec3d p3, Vec3d p4, BufferBuilder buffer) {
        if (direction == this.highlightedFace && this.highlightedTexture != null) {
            this.highlightedTexture.bind();
        } else if (this.faceTexture != null) {
            this.faceTexture.bind();
        } else {
            return;
        }
        Vec3d uDiff = p2.func_178788_d(p1);
        Vec3d vDiff = p4.func_178788_d(p1);
        Direction.Axis axis = direction.func_176740_k();
        float maxU = (float)Math.abs(axis == Direction.Axis.X ? uDiff.field_72449_c : uDiff.field_72450_a);
        float maxV = (float)Math.abs(axis == Direction.Axis.Y ? vDiff.field_72449_c : vDiff.field_72448_b);
        GlHelper.enableTextureRepeat();
        GlStateManager.depthMask((boolean)false);
        this.putQuadUV(p1, p2, p3, p4, 0.0f, 0.0f, maxU, maxV, new Vec3d(1.0, 1.0, 1.0), 1.0f, buffer);
        this.flush();
        GlStateManager.depthMask((boolean)true);
        GlHelper.disableTextureRepeat();
    }
}

