/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.outliner;

import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.outliner.Outline;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class BlockClusterOutline
extends Outline {
    private Cluster cluster = new Cluster();
    private float alpha;

    public BlockClusterOutline(Iterable<BlockPos> selection) {
        selection.forEach(this.cluster::include);
        this.alpha = 0.5f;
    }

    @Override
    public void render(BufferBuilder buffer) {
        Direction direction;
        this.begin();
        Vec3d color = ColorHelper.getRGB(0xDDDDDD);
        AllSpecialTextures.SELECTION.bind();
        for (MergeEntry face : this.cluster.visibleFaces.keySet()) {
            Direction.AxisDirection axisDirection = this.cluster.visibleFaces.get(face);
            direction = Direction.func_181076_a((Direction.AxisDirection)axisDirection, (Direction.Axis)face.axis);
            BlockPos pos = face.pos;
            if (axisDirection == Direction.AxisDirection.POSITIVE) {
                pos = pos.func_177972_a(direction.func_176734_d());
            }
            this.renderFace(pos, direction, color, this.alpha * 0.25f, 0.015625, buffer);
        }
        this.flush();
        AllSpecialTextures.BLANK.bind();
        for (MergeEntry edge : this.cluster.visibleEdges) {
            this.lineWidth = 0.0625f * this.alpha;
            Vec3d start = new Vec3d((Vec3i)edge.pos);
            direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)edge.axis);
            this.renderAACuboidLine(start, new Vec3d((Vec3i)edge.pos.func_177972_a(direction)), color, 1.0f, buffer);
        }
        this.draw();
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    private static class MergeEntry {
        Direction.Axis axis;
        BlockPos pos;

        public MergeEntry(Direction.Axis axis, BlockPos pos) {
            this.axis = axis;
            this.pos = pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MergeEntry)) {
                return false;
            }
            MergeEntry other = (MergeEntry)o;
            return this.axis == other.axis && this.pos.equals((Object)other.pos);
        }

        public int hashCode() {
            return this.pos.hashCode() * 31 + this.axis.ordinal();
        }
    }

    private static class Cluster {
        Map<MergeEntry, Direction.AxisDirection> visibleFaces;
        Set<MergeEntry> visibleEdges = new HashSet<MergeEntry>();

        public Cluster() {
            this.visibleFaces = new HashMap<MergeEntry, Direction.AxisDirection>();
        }

        public void include(BlockPos pos) {
            for (Direction.Axis axis : Direction.Axis.values()) {
                Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
                int[] nArray = new int[]{0, 1};
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int offset = nArray[i];
                    MergeEntry entry = new MergeEntry(axis, pos.func_177967_a(direction, offset));
                    if (this.visibleFaces.remove(entry) != null) continue;
                    this.visibleFaces.put(entry, offset == 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
                }
            }
            block2: for (Direction.Axis axis : Direction.Axis.values()) {
                for (Direction.Axis axis2 : Direction.Axis.values()) {
                    if (axis == axis2) continue;
                    for (Direction.Axis axis3 : Direction.Axis.values()) {
                        if (axis == axis3 || axis2 == axis3) continue;
                        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis2);
                        Direction direction2 = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis3);
                        for (int offset : new int[]{0, 1}) {
                            BlockPos entryPos = pos.func_177967_a(direction, offset);
                            for (int offset2 : new int[]{0, 1}) {
                                MergeEntry entry = new MergeEntry(axis, entryPos = entryPos.func_177967_a(direction2, offset2));
                                if (this.visibleEdges.remove(entry)) continue;
                                this.visibleEdges.add(entry);
                            }
                        }
                    }
                    continue block2;
                }
            }
        }
    }
}

