/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.outliner;

import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public abstract class Outline {
    protected float lineWidth = 0.03125f;

    public abstract void render(BufferBuilder var1);

    protected void begin() {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    protected void draw() {
        Tessellator.func_178181_a().func_78381_a();
    }

    protected void flush() {
        this.draw();
        this.begin();
    }

    public void renderAACuboidLine(Vec3d start, Vec3d end, Vec3d rgb, float alpha, BufferBuilder buffer) {
        Vec3d diff = end.func_178788_d(start);
        if (diff.field_72450_a + diff.field_72448_b + diff.field_72449_c < 0.0) {
            Vec3d temp = start;
            start = end;
            end = temp;
            diff = diff.func_186678_a(-1.0);
        }
        Vec3d extension = diff.func_72432_b().func_186678_a((double)(this.lineWidth / 2.0f));
        Vec3d plane = VecHelper.planeByNormal(diff);
        Direction.Axis axis = Direction.func_210769_a((double)diff.field_72450_a, (double)diff.field_72448_b, (double)diff.field_72449_c).func_176740_k();
        start = start.func_178788_d(extension);
        end = end.func_178787_e(extension);
        plane = plane.func_186678_a((double)(this.lineWidth / 2.0f));
        Vec3d a1 = plane.func_178787_e(start);
        Vec3d b1 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3d a2 = plane.func_178787_e(start);
        Vec3d b2 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3d a3 = plane.func_178787_e(start);
        Vec3d b3 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3d a4 = plane.func_178787_e(start);
        Vec3d b4 = plane.func_178787_e(end);
        this.putQuad(b4, b3, b2, b1, rgb, alpha, buffer);
        this.putQuad(a1, a2, a3, a4, rgb, alpha, buffer);
        this.putQuad(a1, b1, b2, a2, rgb, alpha, buffer);
        this.putQuad(a2, b2, b3, a3, rgb, alpha, buffer);
        this.putQuad(a3, b3, b4, a4, rgb, alpha, buffer);
        this.putQuad(a4, b4, b1, a1, rgb, alpha, buffer);
    }

    protected void renderFace(BlockPos pos, Direction face, Vec3d rgb, float alpha, double scaleOffset, BufferBuilder buffer) {
        Vec3d center = VecHelper.getCenterOf((Vec3i)pos);
        Vec3d offset = new Vec3d(face.func_176730_m());
        Vec3d plane = VecHelper.planeByNormal(offset);
        Direction.Axis axis = face.func_176740_k();
        offset = offset.func_186678_a(0.5 + scaleOffset);
        plane = plane.func_186678_a(0.5).func_178787_e(offset);
        int deg = face.func_176743_c().func_179524_a() * 90;
        Vec3d a1 = plane.func_178787_e(center);
        plane = VecHelper.rotate(plane, deg, axis);
        Vec3d a2 = plane.func_178787_e(center);
        plane = VecHelper.rotate(plane, deg, axis);
        Vec3d a3 = plane.func_178787_e(center);
        plane = VecHelper.rotate(plane, deg, axis);
        Vec3d a4 = plane.func_178787_e(center);
        this.putQuad(a1, a2, a3, a4, rgb, alpha, buffer);
    }

    public void putQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, Vec3d rgb, float alpha, BufferBuilder buffer) {
        this.putQuadUV(v1, v2, v3, v4, 0.0f, 0.0f, 1.0f, 1.0f, rgb, alpha, buffer);
    }

    public void putQuadUV(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, float minU, float minV, float maxU, float maxV, Vec3d rgb, float alpha, BufferBuilder buffer) {
        this.putVertex(v1, rgb, minU, minV, alpha, buffer);
        this.putVertex(v2, rgb, maxU, minV, alpha, buffer);
        this.putVertex(v3, rgb, maxU, maxV, alpha, buffer);
        this.putVertex(v4, rgb, minU, maxV, alpha, buffer);
    }

    protected void putVertex(Vec3d pos, Vec3d rgb, float u, float v, float alpha, BufferBuilder buffer) {
        int i = 0xF000F0;
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        buffer.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_187315_a((double)u, (double)v).func_181666_a((float)rgb.field_72450_a, (float)rgb.field_72448_b, (float)rgb.field_72449_c, alpha).func_187314_a(j, k).func_181675_d();
    }
}

