/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.recipe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeFinder {
    private static Cache<Object, List<IRecipe<?>>> cachedSearches = CacheBuilder.newBuilder().build();

    public static List<IRecipe<?>> get(@Nullable Object cacheKey, World world, Predicate<IRecipe<?>> conditions) {
        if (cacheKey == null) {
            return RecipeFinder.startSearch(world, conditions);
        }
        try {
            return (List)cachedSearches.get(cacheKey, () -> RecipeFinder.startSearch(world, conditions));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private static List<IRecipe<?>> startSearch(World world, Predicate<? super IRecipe<?>> conditions) {
        List<IRecipe<?>> list = world.func_199532_z().func_199510_b().stream().filter(conditions).collect(Collectors.toList());
        return list;
    }
}

