/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.render;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.Create;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.WrappedWorld;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.crash.ReportedException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class StructureRenderer {
    protected static LightingWorld lightingWorld;

    public static void renderTileEntities(World world, Vec3d position, Vec3d rotation, Iterable<TileEntity> customRenderTEs) {
        TileEntityRendererDispatcher dispatcher = TileEntityRendererDispatcher.field_147556_a;
        float pt = Minecraft.func_71410_x().func_184121_ak();
        World prevDispatcherWorld = dispatcher.field_147550_f;
        if (lightingWorld == null) {
            lightingWorld = new LightingWorld(world);
        }
        lightingWorld.setWorld(world);
        lightingWorld.setTransform(position, rotation);
        dispatcher.func_147543_a((World)lightingWorld);
        Iterator<TileEntity> iterator = customRenderTEs.iterator();
        while (iterator.hasNext()) {
            TileEntity tileEntity = iterator.next();
            if (dispatcher.func_147547_b(tileEntity) == null) {
                iterator.remove();
                continue;
            }
            try {
                BlockPos pos = tileEntity.func_174877_v();
                if (!tileEntity.hasFastRenderer()) {
                    RenderHelper.func_74519_b();
                    int i = lightingWorld.func_217338_b(pos, 0);
                    int j = i % 65536;
                    int k = i / 65536;
                    GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
                    GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                World prevTileWorld = tileEntity.func_145831_w();
                tileEntity.func_145834_a((World)lightingWorld);
                GlStateManager.disableCull();
                dispatcher.func_203602_a(tileEntity, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), pt, -1, true);
                GlStateManager.enableCull();
                tileEntity.func_145834_a(prevTileWorld);
            }
            catch (ReportedException e) {
                if (((Boolean)AllConfigs.CLIENT.explainRenderErrors.get()).booleanValue()) {
                    Create.logger.error("TileEntity " + tileEntity.func_200662_C().getRegistryName().toString() + " didn't want to render while moved.\n", (Throwable)e);
                } else {
                    Create.logger.error("TileEntity " + tileEntity.func_200662_C().getRegistryName().toString() + " didn't want to render while moved.\n");
                }
                iterator.remove();
            }
        }
        dispatcher.func_147543_a(prevDispatcherWorld);
    }

    private static class LightingWorld
    extends WrappedWorld {
        private Vec3d offset;
        private Vec3d rotation;

        public LightingWorld(World world) {
            super(world);
        }

        void setWorld(World world) {
            this.world = world;
        }

        void setTransform(Vec3d offset, Vec3d rotation) {
            this.offset = offset;
            this.rotation = rotation;
        }

        public int func_217338_b(BlockPos pos, int minLight) {
            return super.func_217338_b(this.transformPos(pos), minLight);
        }

        private BlockPos transformPos(BlockPos pos) {
            Vec3d vec = VecHelper.getCenterOf((Vec3i)pos);
            vec = VecHelper.rotate(vec, this.rotation.field_72450_a, this.rotation.field_72448_b, this.rotation.field_72449_c);
            vec = vec.func_178787_e(this.offset).func_178788_d(VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a));
            return new BlockPos(vec);
        }
    }
}

