/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.world;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.world.ChanceOreFeature;
import com.simibubi.create.foundation.world.CountedOreFeature;
import com.simibubi.create.foundation.world.IFeature;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public enum AllWorldFeatures {
    COPPER_ORE(new CountedOreFeature(AllBlocks.COPPER_ORE.get(), 18, 2).between(40, 86)),
    COPPER_ORE_OCEAN(new CountedOreFeature(AllBlocks.COPPER_ORE.get(), 15, 4).between(20, 55).inBiomes(Biome.Category.OCEAN)),
    ZINC_ORE(new CountedOreFeature(AllBlocks.ZINC_ORE.get(), 14, 4).between(15, 70)),
    ZINC_ORE_DESERT(new CountedOreFeature(AllBlocks.ZINC_ORE.get(), 17, 5).between(10, 85).inBiomes(Biome.Category.DESERT)),
    LIMESTONE(new ChanceOreFeature(AllBlocks.LIMESTONE.get(), 128, 0.03125f).between(30, 70)),
    WEATHERED_LIMESTONE(new ChanceOreFeature(AllBlocks.WEATHERED_LIMESTONE.get(), 128, 0.03125f).between(10, 30)),
    DOLOMITE(new ChanceOreFeature(AllBlocks.DOLOMITE.get(), 128, 0.015625f).between(20, 70)),
    GABBRO(new ChanceOreFeature(AllBlocks.GABBRO.get(), 128, 0.015625f).between(20, 70)),
    SCORIA(new ChanceOreFeature(AllBlocks.NATURAL_SCORIA.get(), 128, 0.03125f).between(0, 10));

    public static final int forcedUpdateVersion = 1;
    public IFeature feature;
    private Map<Biome, ConfiguredFeature<?>> featureInstances;

    private AllWorldFeatures(IFeature feature) {
        this.feature = feature;
        this.featureInstances = new HashMap();
        this.feature.setId(Lang.asId(this.name()));
    }

    public static void reload() {
        for (AllWorldFeatures entry : AllWorldFeatures.values()) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                Optional<ConfiguredFeature<?>> createFeature;
                if (biome == Biomes.field_185440_P || biome == Biomes.field_76778_j) continue;
                if (entry.featureInstances.containsKey(biome)) {
                    biome.func_203607_a(entry.feature.getGenerationStage()).remove(entry.featureInstances.remove(biome));
                }
                if (!(createFeature = entry.feature.createFeature(biome)).isPresent()) continue;
                entry.featureInstances.put(biome, createFeature.get());
                biome.func_203611_a(entry.feature.getGenerationStage(), createFeature.get());
            }
        }
    }

    public static void fillConfig(ForgeConfigSpec.Builder builder) {
        Arrays.stream(AllWorldFeatures.values()).forEach(entry -> {
            builder.push(Lang.asId(entry.name()));
            entry.feature.addToConfig(builder);
            builder.pop();
        });
    }
}

