/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.config.CServer;
import com.simibubi.create.foundation.item.ItemDescription;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public interface IModule {
    public static boolean isActive(String module) {
        if (module.equals("materials")) {
            return true;
        }
        CServer conf = AllConfigs.SERVER;
        switch (module) {
            case "contraptions": {
                return true;
            }
            case "palettes": {
                return (Boolean)conf.enablePalettes.get();
            }
            case "curiosities": {
                return (Boolean)conf.enableCuriosities.get();
            }
            case "logistics": {
                return (Boolean)conf.enableLogistics.get();
            }
            case "schematics": {
                return (Boolean)conf.enableSchematics.get();
            }
        }
        return false;
    }

    default public ItemDescription.Palette getToolTipColor() {
        String module = this.getModuleName();
        if (module.equals("materials")) {
            return ItemDescription.Palette.Purple;
        }
        switch (module) {
            case "contraptions": {
                return ItemDescription.Palette.Red;
            }
            case "palettes": {
                return ItemDescription.Palette.Green;
            }
            case "curiosities": {
                return ItemDescription.Palette.Purple;
            }
            case "logistics": {
                return ItemDescription.Palette.Yellow;
            }
            case "schematics": {
                return ItemDescription.Palette.Blue;
            }
        }
        return ItemDescription.Palette.Purple;
    }

    public static IModule of(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem) {
            return IModule.ofBlock(((BlockItem)item).func_179223_d());
        }
        return IModule.ofItem(item);
    }

    public static IModule ofItem(Item item) {
        for (AllItems allItems : AllItems.values()) {
            if (allItems.get() != item) continue;
            return allItems.module;
        }
        return null;
    }

    public static IModule ofBlock(Block block) {
        for (AllBlocks allBlocks : AllBlocks.values()) {
            if (allBlocks.get() != block) continue;
            return allBlocks.module;
        }
        return null;
    }

    default public boolean isEnabled() {
        return IModule.isActive(this.getModuleName());
    }

    public String getModuleName();
}

