/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions;

import com.simibubi.create.foundation.utility.VoxelShaper;
import com.simibubi.create.modules.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.modules.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.modules.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.modules.contraptions.base.HorizontalAxisKineticBlock;
import com.simibubi.create.modules.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.base.RotatedPillarKineticBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public interface IWrenchable {
    default public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockState rotated = IWrenchable.getRotatedBlockState(state, context.func_196000_l());
        if (!rotated.func_196955_c((IWorldReader)world, context.func_195995_a())) {
            return ActionResultType.PASS;
        }
        KineticTileEntity.switchToBlockState(world, context.func_195995_a(), this.updateAfterWrenched(rotated, context));
        TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a());
        if (te != null) {
            te.func_145836_u();
        }
        if (te instanceof GeneratingKineticTileEntity) {
            ((GeneratingKineticTileEntity)te).updateGeneratedRotation();
        }
        return ActionResultType.SUCCESS;
    }

    default public BlockState updateAfterWrenched(BlockState newState, ItemUseContext context) {
        return newState;
    }

    public static BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        BlockState newState = originalState;
        if (targetedFace.func_176740_k() == Direction.Axis.Y) {
            if (originalState.func_196959_b(HorizontalAxisKineticBlock.HORIZONTAL_AXIS)) {
                return (BlockState)originalState.func_206870_a(HorizontalAxisKineticBlock.HORIZONTAL_AXIS, (Comparable)VoxelShaper.axisAsFace((Direction.Axis)originalState.func_177229_b(HorizontalAxisKineticBlock.HORIZONTAL_AXIS)).func_176732_a(targetedFace.func_176740_k()).func_176740_k());
            }
            if (originalState.func_196959_b(HorizontalKineticBlock.HORIZONTAL_FACING)) {
                return (BlockState)originalState.func_206870_a(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)((Direction)originalState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176732_a(targetedFace.func_176740_k()));
            }
        }
        if (originalState.func_196959_b(RotatedPillarKineticBlock.AXIS)) {
            return (BlockState)originalState.func_206870_a(RotatedPillarKineticBlock.AXIS, (Comparable)VoxelShaper.axisAsFace((Direction.Axis)originalState.func_177229_b(RotatedPillarKineticBlock.AXIS)).func_176732_a(targetedFace.func_176740_k()).func_176740_k());
        }
        if (!originalState.func_196959_b((IProperty)DirectionalKineticBlock.FACING)) {
            return originalState;
        }
        Direction stateFacing = (Direction)originalState.func_177229_b((IProperty)DirectionalKineticBlock.FACING);
        if (stateFacing.func_176740_k().equals((Object)targetedFace.func_176740_k())) {
            if (originalState.func_196959_b((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)) {
                return (BlockState)originalState.func_177231_a((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            }
            return originalState;
        }
        do {
            newState = (BlockState)newState.func_206870_a((IProperty)DirectionalKineticBlock.FACING, (Comparable)((Direction)newState.func_177229_b((IProperty)DirectionalKineticBlock.FACING)).func_176732_a(targetedFace.func_176740_k()));
            if (targetedFace.func_176740_k() != Direction.Axis.Y || !newState.func_196959_b((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)) continue;
            newState = (BlockState)newState.func_177231_a((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
        } while (((Direction)newState.func_177229_b((IProperty)DirectionalKineticBlock.FACING)).func_176740_k().equals((Object)targetedFace.func_176740_k()));
        return newState;
    }
}

