/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.base;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.block.SafeTileEntityRendererFast;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.foundation.utility.SuperByteBufferCache;
import com.simibubi.create.modules.contraptions.KineticDebugger;
import com.simibubi.create.modules.contraptions.base.IRotate;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class KineticTileEntityRenderer
extends SafeTileEntityRendererFast<KineticTileEntity> {
    public static final SuperByteBufferCache.Compartment<BlockState> KINETIC_TILE = new SuperByteBufferCache.Compartment();
    public static boolean rainbowMode = false;

    @Override
    public void renderFast(KineticTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder buffer) {
        KineticTileEntityRenderer.renderRotatingBuffer(te, this.func_178459_a(), this.getRotatedModel(te), x, y, z, buffer);
    }

    public static void renderRotatingKineticBlock(KineticTileEntity te, World world, BlockState renderedState, double x, double y, double z, BufferBuilder buffer) {
        SuperByteBuffer superByteBuffer = CreateClient.bufferCache.renderBlockIn(KINETIC_TILE, renderedState);
        KineticTileEntityRenderer.renderRotatingBuffer(te, world, superByteBuffer, x, y, z, buffer);
    }

    public static void renderRotatingBuffer(KineticTileEntity te, World world, SuperByteBuffer superBuffer, double x, double y, double z, BufferBuilder buffer) {
        buffer.putBulkData(KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, world).translate(x, y, z).build());
    }

    public static float getAngleForTe(KineticTileEntity te, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTick();
        float offset = KineticTileEntityRenderer.getRotationOffsetForPosition(te, pos, axis);
        float angle = (time * te.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        return angle;
    }

    public static SuperByteBuffer standardKineticRotationTransform(SuperByteBuffer buffer, KineticTileEntity te, World world) {
        BlockPos pos = te.func_174877_v();
        Direction.Axis axis = ((IRotate)te.func_195044_w().func_177230_c()).getRotationAxis(te.func_195044_w());
        return KineticTileEntityRenderer.kineticRotationTransform(buffer, te, axis, KineticTileEntityRenderer.getAngleForTe(te, pos, axis), world);
    }

    public static SuperByteBuffer kineticRotationTransform(SuperByteBuffer buffer, KineticTileEntity te, Direction.Axis axis, float angle, World world) {
        int packedLightmapCoords = te.func_195044_w().func_215684_a((IEnviromentBlockReader)world, te.func_174877_v());
        buffer.light(packedLightmapCoords);
        buffer.rotateCentered(axis, angle);
        int white = 0xFFFFFF;
        if (KineticDebugger.isActive()) {
            rainbowMode = true;
            buffer.color(te.hasNetwork() ? ColorHelper.colorFromLong(te.network) : white);
        } else {
            float overStressedEffect = te.effects.overStressedEffect;
            if (overStressedEffect != 0.0f) {
                if (overStressedEffect > 0.0f) {
                    buffer.color(ColorHelper.mixColors(white, 0xFF0000, overStressedEffect));
                } else {
                    buffer.color(ColorHelper.mixColors(white, 65467, -overStressedEffect));
                }
            } else {
                buffer.color(white);
            }
        }
        return buffer;
    }

    protected static float getRotationOffsetForPosition(KineticTileEntity te, BlockPos pos, Direction.Axis axis) {
        float offset = AllBlocks.LARGE_COGWHEEL.typeOf(te.func_195044_w()) ? 11.25f : 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.func_177958_n()) + (axis == Direction.Axis.Y ? 0 : pos.func_177956_o()) + (axis == Direction.Axis.Z ? 0 : pos.func_177952_p())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        return te.func_195044_w();
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return CreateClient.bufferCache.renderBlockIn(KINETIC_TILE, this.getRenderedBlockState(te));
    }
}

