/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.actors;

import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.components.actors.BlockBreakingMovementBehaviour;
import com.simibubi.create.modules.contraptions.components.actors.PloughBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.MovementContext;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PloughMovementBehaviour
extends BlockBreakingMovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return !VecHelper.isVecPointingTowards(context.relativeMotion, ((Direction)context.state.func_177229_b((IProperty)HorizontalBlock.field_185512_D)).func_176734_d());
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        World world = context.world;
        if (world.field_72995_K) {
            return;
        }
        BlockPos below = pos.func_177977_b();
        if (!world.func_195588_v(below)) {
            return;
        }
        Vec3d vec = VecHelper.getCenterOf((Vec3i)pos);
        PloughBlock.PloughFakePlayer player = this.getPlayer(context);
        if (player == null) {
            return;
        }
        BlockRayTraceResult ray = world.func_217299_a(new RayTraceContext(vec, vec.func_72441_c(0.0, -1.0, 0.0), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (ray == null || ray.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        ItemUseContext ctx = new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, ray);
        new ItemStack((IItemProvider)Items.field_151012_L).func_196084_a(ctx);
    }

    @Override
    public Vec3d getActiveAreaOffset(MovementContext context) {
        return new Vec3d(((Direction)context.state.func_177229_b((IProperty)HorizontalBlock.field_185512_D)).func_176730_m()).func_186678_a(0.45);
    }

    @Override
    protected boolean throwsEntities() {
        return true;
    }

    @Override
    public boolean canBreak(World world, BlockPos breakingPos, BlockState state) {
        return state.func_196952_d((IBlockReader)world, breakingPos).func_197766_b() && !(state.func_177230_c() instanceof FlowingFluidBlock);
    }

    @Override
    public void stopMoving(MovementContext context) {
        super.stopMoving(context);
        if (context.temporaryData instanceof PloughBlock.PloughFakePlayer) {
            ((PloughBlock.PloughFakePlayer)((Object)context.temporaryData)).func_70106_y();
        }
    }

    private PloughBlock.PloughFakePlayer getPlayer(MovementContext context) {
        if (!(context.temporaryData instanceof PloughBlock.PloughFakePlayer) && context.world instanceof ServerWorld) {
            PloughBlock.PloughFakePlayer player = new PloughBlock.PloughFakePlayer((ServerWorld)context.world);
            player.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151012_L));
            context.temporaryData = player;
        }
        return (PloughBlock.PloughFakePlayer)((Object)context.temporaryData);
    }
}

