/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.actors;

import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.behaviour.inventory.SingleTargetAutoExtractingBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.components.actors.PortableStorageInterfaceBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.MovementBehaviour;
import com.simibubi.create.modules.contraptions.components.contraptions.MovementContext;
import com.simibubi.create.modules.logistics.block.transposer.TransposerBlock;
import com.simibubi.create.modules.logistics.block.transposer.TransposerTileEntity;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class StorageInterfaceMovement
extends MovementBehaviour {
    private static final String _exporting_ = "Exporting";
    private static final String _delay_ = "Delay";
    private static final String _workingPos_ = "WorkingPos";

    @Override
    public Vec3d getActiveAreaOffset(MovementContext context) {
        return new Vec3d(((Direction)context.state.func_177229_b((IProperty)PortableStorageInterfaceBlock.field_176387_N)).func_176730_m()).func_186678_a((double)0.85f);
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Direction currentFacing = this.getCurrentFacing(context);
        TransposerTileEntity transposer = this.getValidTransposer(context.world, pos, currentFacing.func_176740_k());
        if (transposer == null) {
            return;
        }
        context.data.func_218657_a(_workingPos_, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        context.data.func_74757_a(_exporting_, TransposerBlock.getBlockFacing(transposer.func_195044_w()) != currentFacing);
        context.stall = true;
    }

    @Override
    public void tick(MovementContext context) {
        if (!context.data.func_74764_b(_workingPos_)) {
            return;
        }
        if (context.world.field_72995_K) {
            return;
        }
        BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)context.data.func_74775_l(_workingPos_));
        TransposerTileEntity transposer = this.getValidTransposer(context.world, pos, this.getCurrentFacing(context).func_176740_k());
        if (transposer == null) {
            this.reset(context);
            return;
        }
        int nextExtract = context.data.func_74762_e(_delay_);
        if (nextExtract > 0) {
            context.data.func_74768_a(_delay_, --nextExtract);
            return;
        }
        boolean extract = context.data.func_74767_n(_exporting_);
        boolean success = false;
        CombinedInvWrapper inv = context.contraption.inventory;
        SingleTargetAutoExtractingBehaviour extracting = TileEntityBehaviour.get(transposer, SingleTargetAutoExtractingBehaviour.TYPE);
        FilteringBehaviour filtering = TileEntityBehaviour.get(transposer, FilteringBehaviour.TYPE);
        if (extract) {
            Predicate<ItemStack> test = extracting.getFilterTest();
            int exactAmount = extracting.getAmountToExtract();
            ItemStack itemExtracted = ItemStack.field_190927_a;
            itemExtracted = exactAmount != -1 ? ItemHelper.extract((IItemHandler)inv, test, exactAmount, false) : ItemHelper.extract((IItemHandler)inv, test, transposer::amountToExtract, false);
            if (!itemExtracted.func_190926_b()) {
                transposer.onExtract(itemExtracted);
                success = exactAmount == -1;
            }
        } else if (extracting != null) {
            extracting.setSynchronized(false);
            extracting.withAdditionalFilter(arg_0 -> StorageInterfaceMovement.lambda$tick$0(filtering, (IItemHandlerModifiable)inv, arg_0));
            extracting.withAmountThreshold(arg_0 -> StorageInterfaceMovement.lambda$tick$1((IItemHandlerModifiable)inv, arg_0));
            extracting.setCallback(arg_0 -> StorageInterfaceMovement.lambda$tick$2((IItemHandlerModifiable)inv, arg_0));
            success = extracting.extract() && filtering.anyAmount();
            extracting.setSynchronized(true);
            transposer.applyFilteringCallbacks();
            extracting.setCallback(transposer::onExtract);
        }
        if (!success) {
            this.reset(context);
            return;
        }
        context.data.func_74768_a(_delay_, ((Integer)AllConfigs.SERVER.logistics.extractorDelay.get()).intValue());
    }

    @Override
    public void stopMoving(MovementContext context) {
        this.reset(context);
    }

    public void reset(MovementContext context) {
        context.data.func_82580_o(_workingPos_);
        context.data.func_82580_o(_delay_);
        context.data.func_82580_o(_exporting_);
        context.stall = false;
    }

    private TransposerTileEntity getValidTransposer(World world, BlockPos pos, Direction.Axis validAxis) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TransposerTileEntity)) {
            return null;
        }
        if (TransposerBlock.getBlockFacing(world.func_180495_p(pos)).func_176740_k() != validAxis) {
            return null;
        }
        if (world.func_175640_z(pos)) {
            return null;
        }
        return (TransposerTileEntity)te;
    }

    private Direction getCurrentFacing(MovementContext context) {
        Vec3d directionVec = new Vec3d(((Direction)context.state.func_177229_b((IProperty)PortableStorageInterfaceBlock.field_176387_N)).func_176730_m());
        directionVec = VecHelper.rotate(directionVec, context.rotation.field_72450_a, context.rotation.field_72448_b, context.rotation.field_72449_c);
        return Direction.func_210769_a((double)directionVec.field_72450_a, (double)directionVec.field_72448_b, (double)directionVec.field_72449_c);
    }

    private static /* synthetic */ void lambda$tick$2(IItemHandlerModifiable inv, ItemStack stack) {
        ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
    }

    private static /* synthetic */ Integer lambda$tick$1(IItemHandlerModifiable inv, ItemStack stack) {
        ItemStack tester = stack.func_77946_l();
        tester.func_190920_e(tester.func_77976_d());
        return stack.func_190916_E() - ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)true).func_190916_E();
    }

    private static /* synthetic */ boolean lambda$tick$0(FilteringBehaviour filtering, IItemHandlerModifiable inv, ItemStack stack) {
        if (filtering.anyAmount()) {
            return true;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)true).func_190926_b();
    }
}

