/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.clock;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.modules.contraptions.components.clock.CuckooClockBlock;
import com.simibubi.create.modules.contraptions.components.clock.CuckooClockTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IEnviromentBlockReader;

public class CuckooClockRenderer
extends KineticTileEntityRenderer {
    @Override
    public void renderFast(KineticTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder buffer) {
        super.renderFast(te, x, y, z, partialTicks, destroyStage, buffer);
        if (!(te instanceof CuckooClockTileEntity)) {
            return;
        }
        CuckooClockTileEntity clock = (CuckooClockTileEntity)te;
        BlockState blockState = te.func_195044_w();
        int light = blockState.func_215684_a((IEnviromentBlockReader)this.func_178459_a(), te.func_174877_v());
        Direction direction = (Direction)blockState.func_177229_b(CuckooClockBlock.HORIZONTAL_FACING);
        SuperByteBuffer hourHand = AllBlockPartials.CUCKOO_HOUR_HAND.renderOn(blockState);
        SuperByteBuffer minuteHand = AllBlockPartials.CUCKOO_MINUTE_HAND.renderOn(blockState);
        float hourAngle = clock.hourHand.get(partialTicks);
        float minuteAngle = clock.minuteHand.get(partialTicks);
        this.rotateHand(hourHand, hourAngle, direction).translate(x, y, z).light(light).renderInto(buffer);
        this.rotateHand(minuteHand, minuteAngle, direction).translate(x, y, z).light(light).renderInto(buffer);
        SuperByteBuffer leftDoor = AllBlockPartials.CUCKOO_LEFT_DOOR.renderOn(blockState);
        SuperByteBuffer rightDoor = AllBlockPartials.CUCKOO_RIGHT_DOOR.renderOn(blockState);
        float angle = 0.0f;
        float offset = 0.0f;
        if (clock.animationType != null) {
            float value = clock.animationProgress.get(partialTicks);
            int step = clock.animationType == CuckooClockTileEntity.Animation.SURPRISE ? 3 : 15;
            for (int phase = 30; phase <= 60; phase += step) {
                float local = value - (float)phase;
                if (local < (float)(-step / 3)) continue;
                if (local < 0.0f) {
                    angle = MathHelper.func_219799_g((float)((value - (float)(phase - 5)) / 5.0f), (float)0.0f, (float)135.0f);
                    continue;
                }
                if (local < (float)(step / 3)) {
                    angle = 135.0f;
                    continue;
                }
                if (!(local < (float)(2 * step / 3))) continue;
                angle = MathHelper.func_219799_g((float)((value - (float)(phase + 5)) / 5.0f), (float)135.0f, (float)0.0f);
            }
        }
        this.rotateDoor(leftDoor, angle, true, direction).translate(x, y, z).light(light).renderInto(buffer);
        this.rotateDoor(rightDoor, angle, false, direction).translate(x, y, z).light(light).renderInto(buffer);
        if (clock.animationType != null) {
            offset = -(angle / 135.0f) * 1.0f / 2.0f + 0.625f;
            SuperByteBuffer figure = (clock.animationType == CuckooClockTileEntity.Animation.PIG ? AllBlockPartials.CUCKOO_PIG : AllBlockPartials.CUCKOO_CREEPER).renderOn(blockState);
            figure.translate(offset, 0.0f, 0.0f);
            figure.rotateCentered(Direction.Axis.Y, AngleHelper.rad(AngleHelper.horizontalAngle(direction.func_176735_f())));
            figure.translate(x, y, z).light(light).renderInto(buffer);
        }
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return this.transform(AllBlockPartials.SHAFT_HALF, te);
    }

    private SuperByteBuffer transform(AllBlockPartials partial, KineticTileEntity te) {
        return partial.renderOnDirectional(te.func_195044_w(), ((Direction)te.func_195044_w().func_177229_b(CuckooClockBlock.HORIZONTAL_FACING)).func_176734_d());
    }

    private SuperByteBuffer rotateHand(SuperByteBuffer buffer, float angle, Direction facing) {
        float pivotX = 0.125f;
        float pivotY = 0.375f;
        float pivotZ = 0.5f;
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        buffer.rotate(Direction.Axis.X, angle);
        buffer.translate(pivotX, pivotY, pivotZ);
        buffer.rotateCentered(Direction.Axis.Y, AngleHelper.rad(AngleHelper.horizontalAngle(facing.func_176735_f())));
        return buffer;
    }

    private SuperByteBuffer rotateDoor(SuperByteBuffer buffer, float angle, boolean left, Direction facing) {
        float pivotX = 0.125f;
        float pivotY = 0.0f;
        float pivotZ = (float)(left ? 6 : 10) / 16.0f;
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        buffer.rotate(Direction.Axis.Y, AngleHelper.rad(angle) * (float)(left ? -1 : 1));
        buffer.translate(pivotX, pivotY, pivotZ);
        buffer.rotateCentered(Direction.Axis.Y, AngleHelper.rad(AngleHelper.horizontalAngle(facing.func_176735_f())));
        return buffer;
    }
}

