/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.clock;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.gui.widgets.InterpolatedValue;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.components.clock.CuckooClockBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;

public class CuckooClockTileEntity
extends KineticTileEntity {
    public static DamageSource CUCKOO_SURPRISE = new DamageSource("create.cuckoo_clock_explosion").func_94540_d();
    public InterpolatedChasingValue hourHand = new InterpolatedChasingValue().withSpeed(0.2f);
    public InterpolatedChasingValue minuteHand = new InterpolatedChasingValue().withSpeed(0.2f);
    public InterpolatedValue animationProgress = new InterpolatedValue();
    public Animation animationType;
    private boolean sendAnimationUpdate;

    public CuckooClockTileEntity() {
        super(AllTileEntities.CUCKOO_CLOCK.type);
    }

    @Override
    public CompoundNBT writeToClient(CompoundNBT compound) {
        if (this.sendAnimationUpdate) {
            compound.func_74778_a("Animation", this.animationType == null ? "none" : NBTHelper.writeEnum(this.animationType));
        }
        this.sendAnimationUpdate = false;
        return super.writeToClient(compound);
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        if (tag.func_74764_b("Animation")) {
            String string = tag.func_74779_i("Animation");
            this.animationType = "none".equals(string) ? null : NBTHelper.readEnum(string, Animation.class);
            this.animationProgress.lastValue = 0.0f;
            this.animationProgress.value = 0.0f;
        }
        super.readClientUpdate(tag);
    }

    @Override
    public void func_73660_a() {
        block18: {
            block21: {
                block19: {
                    block20: {
                        super.func_73660_a();
                        if (this.getSpeed() == 0.0f) {
                            return;
                        }
                        int dayTime = (int)(this.field_145850_b.func_72820_D() % 24000L);
                        int hours = (dayTime / 1000 + 6) % 24;
                        int minutes = dayTime % 1000 * 60 / 1000;
                        if (!this.field_145850_b.field_72995_K) {
                            if (this.animationType == null) {
                                if (hours == 12 && minutes < 5) {
                                    this.startAnimation(Animation.PIG);
                                }
                                if (hours == 18 && minutes < 36 && minutes > 31) {
                                    this.startAnimation(Animation.CREEPER);
                                }
                            } else {
                                float value = this.animationProgress.value;
                                this.animationProgress.set(value + 1.0f);
                                if (value > 100.0f) {
                                    this.animationType = null;
                                }
                                if (this.animationType == Animation.SURPRISE && this.animationProgress.value == 50.0f) {
                                    Vec3d center = VecHelper.getCenterOf((Vec3i)this.field_174879_c);
                                    this.field_145850_b.func_175655_b(this.field_174879_c, false);
                                    this.field_145850_b.func_217401_a(null, CUCKOO_SURPRISE, center.field_72450_a, center.field_72448_b, center.field_72449_c, 3.0f, false, Explosion.Mode.BREAK);
                                }
                            }
                        }
                        if (!this.field_145850_b.field_72995_K) break block18;
                        this.moveHands(hours, minutes);
                        if (this.animationType != null) break block19;
                        if (AnimationTickHolder.ticks % 32 != 0) break block20;
                        this.playSound(SoundEvents.field_187685_dH, 0.0625f, 2.0f);
                        break block21;
                    }
                    if (AnimationTickHolder.ticks % 16 != 0) break block21;
                    this.playSound(SoundEvents.field_187685_dH, 0.0625f, 1.5f);
                    break block21;
                }
                boolean isSurprise = this.animationType == Animation.SURPRISE;
                float value = this.animationProgress.value;
                this.animationProgress.set(value + 1.0f);
                if (value > 100.0f) {
                    this.animationType = null;
                }
                if (value == 1.0f) {
                    this.playSound(SoundEvents.field_193808_ex, 2.0f, 0.5f);
                }
                if (value == 21.0f) {
                    this.playSound(SoundEvents.field_193808_ex, 2.0f, 0.793701f);
                }
                if (value > 30.0f && isSurprise) {
                    Vec3d pos = VecHelper.offsetRandomly(VecHelper.getCenterOf((Vec3i)this.field_174879_c), this.field_145850_b.field_73012_v, 0.5f);
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197594_E, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0);
                }
                if (value == 40.0f && isSurprise) {
                    this.playSound(SoundEvents.field_187904_gd, 1.0f, 1.0f);
                }
                int step = isSurprise ? 3 : 15;
                for (int phase = 30; phase <= 60; phase += step) {
                    if (value == (float)(phase - step / 3)) {
                        this.playSound(SoundEvents.field_187657_V, 0.0625f, 2.0f);
                    }
                    if (value == (float)phase) {
                        if (this.animationType == Animation.PIG) {
                            this.playSound(SoundEvents.field_187697_dL, 0.25f, 1.0f);
                        } else {
                            this.playSound(SoundEvents.field_187570_aq, 0.25f, 3.0f);
                        }
                    }
                    if (value != (float)(phase + step / 3)) continue;
                    this.playSound(SoundEvents.field_187651_T, 0.0625f, 2.0f);
                }
            }
            return;
        }
    }

    public void startAnimation(Animation animation) {
        this.animationType = animation;
        if (animation != null && CuckooClockBlock.containsSurprise(this.func_195044_w())) {
            this.animationType = Animation.SURPRISE;
        }
        this.animationProgress.lastValue = 0.0f;
        this.animationProgress.value = 0.0f;
        this.sendAnimationUpdate = true;
        this.sendData();
    }

    public void moveHands(int hours, int minutes) {
        float hourTarget = 30 * (hours % 12);
        float minuteTarget = 6 * minutes;
        this.hourHand.target(this.hourHand.value + AngleHelper.rad(AngleHelper.getShortestAngleDiff(AngleHelper.deg(this.hourHand.value), hourTarget)));
        this.minuteHand.target(this.minuteHand.value + AngleHelper.rad(AngleHelper.getShortestAngleDiff(AngleHelper.deg(this.minuteHand.value), minuteTarget)));
        this.hourHand.tick();
        this.minuteHand.tick();
    }

    private void playSound(SoundEvent sound, float volume, float pitch) {
        Vec3d vec = VecHelper.getCenterOf((Vec3i)this.field_174879_c);
        this.field_145850_b.func_184134_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, sound, SoundCategory.BLOCKS, volume, pitch, false);
    }

    static enum Animation {
        PIG,
        CREEPER,
        SURPRISE;

    }
}

