/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import com.simibubi.create.foundation.utility.outliner.BlockClusterOutline;
import com.simibubi.create.foundation.utility.outliner.Outline;
import com.simibubi.create.foundation.utility.outliner.OutlineParticle;
import com.simibubi.create.modules.contraptions.components.contraptions.chassis.ChassisTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ChassisRangeDisplay {
    private static final int DISPLAY_TIME = 200;
    private static GroupEntry lastHoveredGroup = null;
    static Map<BlockPos, Entry> entries = new HashMap<BlockPos, Entry>();
    static List<GroupEntry> groupEntries = new ArrayList<GroupEntry>();

    public static void clientTick() {
        GroupEntry existingGroupForPos;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        boolean hasWrench = AllItems.WRENCH.typeOf(player.func_184614_ca());
        Iterator<Object> iterator = entries.keySet().iterator();
        while (iterator.hasNext()) {
            Entry entry = entries.get(iterator.next());
            if (!ChassisRangeDisplay.tickEntry(entry, hasWrench)) continue;
            entry.particle.remove();
            iterator.remove();
        }
        iterator = groupEntries.iterator();
        while (iterator.hasNext()) {
            GroupEntry group = (GroupEntry)iterator.next();
            if (!ChassisRangeDisplay.tickEntry(group, hasWrench)) continue;
            iterator.remove();
            group.particle.remove();
            if (group != lastHoveredGroup) continue;
            lastHoveredGroup = null;
        }
        if (!hasWrench) {
            return;
        }
        RayTraceResult over = Minecraft.func_71410_x().field_71476_x;
        if (!(over instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult ray = (BlockRayTraceResult)over;
        BlockPos pos = ray.func_216350_a();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || tileEntity.func_145837_r()) {
            return;
        }
        if (!(tileEntity instanceof ChassisTileEntity)) {
            return;
        }
        boolean ctrl = AllKeys.ctrlDown();
        ChassisTileEntity chassisTileEntity = (ChassisTileEntity)tileEntity;
        if (ctrl && (existingGroupForPos = ChassisRangeDisplay.getExistingGroupForPos(pos)) != null) {
            for (ChassisTileEntity included : existingGroupForPos.includedTEs) {
                Entry removed = entries.remove(included.func_174877_v());
                if (removed == null) continue;
                removed.particle.remove();
            }
            existingGroupForPos.timer = 200;
            return;
        }
        if (!entries.containsKey(pos) || ctrl) {
            ChassisRangeDisplay.display(chassisTileEntity);
        } else {
            ChassisRangeDisplay.deselect();
            if (!ctrl) {
                ChassisRangeDisplay.entries.get((Object)pos).timer = 200;
            }
        }
    }

    private static void deselect() {
        for (Entry entry : entries.values()) {
            if (entry.timer <= 10) continue;
            entry.timer = 10;
        }
        for (Entry entry : groupEntries) {
            if (entry.timer <= 10) continue;
            entry.timer = 10;
        }
    }

    private static boolean tickEntry(Entry entry, boolean hasWrench) {
        ChassisTileEntity chassisTileEntity = entry.te;
        World teWorld = chassisTileEntity.func_145831_w();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (chassisTileEntity.func_145837_r() || teWorld == null || teWorld != world || !world.func_195588_v(chassisTileEntity.func_174877_v())) {
            return true;
        }
        if (!hasWrench && entry.timer > 20) {
            entry.timer = 20;
            return false;
        }
        --entry.timer;
        return entry.timer == 0;
    }

    public static void display(ChassisTileEntity chassis) {
        ChassisRangeDisplay.deselect();
        if (AllKeys.ctrlDown()) {
            groupEntries.forEach(e -> e.particle.remove());
            groupEntries.clear();
            GroupEntry hoveredGroup = new GroupEntry(chassis);
            for (ChassisTileEntity included : hoveredGroup.includedTEs) {
                Entry remove = entries.remove(included.func_174877_v());
                if (remove == null) continue;
                remove.particle.remove();
            }
            groupEntries.add(hoveredGroup);
        } else {
            Entry old = entries.put(chassis.func_174877_v(), new Entry(chassis));
            if (old != null) {
                old.particle.remove();
            }
        }
    }

    public static void renderOutlines(float partialTicks) {
        GlStateManager.lineWidth((float)2.0f);
        TessellatorHelper.prepareForDrawing();
        GlStateManager.disableTexture();
        GlStateManager.enableAlphaTest();
        for (Entry entry : entries.values()) {
            ChassisRangeDisplay.renderPositions(entry, partialTicks);
        }
        for (Entry entry : groupEntries) {
            ChassisRangeDisplay.renderPositions(entry, partialTicks);
        }
        GlStateManager.enableTexture();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        TessellatorHelper.cleanUpAfterDrawing();
        GlStateManager.lineWidth((float)1.0f);
    }

    public static void renderPositions(Entry entry, float partialTicks) {
        float timer = (float)entry.timer - partialTicks;
        float alpha = timer > 20.0f ? 1.0f : timer / 20.0f;
        entry.outline.setAlpha(alpha);
    }

    private static GroupEntry getExistingGroupForPos(BlockPos pos) {
        for (GroupEntry groupEntry : groupEntries) {
            for (ChassisTileEntity chassis : groupEntry.includedTEs) {
                if (!pos.equals((Object)chassis.func_174877_v())) continue;
                return groupEntry;
            }
        }
        return null;
    }

    private static class GroupEntry
    extends Entry {
        List<ChassisTileEntity> includedTEs;

        public GroupEntry(ChassisTileEntity te) {
            super(te);
        }

        @Override
        protected Set<BlockPos> createSelection(ChassisTileEntity chassis) {
            HashSet<BlockPos> list = new HashSet<BlockPos>();
            this.includedTEs = this.te.collectChassisGroup();
            if (this.includedTEs == null) {
                return list;
            }
            for (ChassisTileEntity chassisTileEntity : this.includedTEs) {
                list.addAll(super.createSelection(chassisTileEntity));
            }
            return list;
        }
    }

    private static class Entry {
        BlockClusterOutline outline;
        OutlineParticle<Outline> particle;
        ChassisTileEntity te;
        int timer;

        public Entry(ChassisTileEntity te) {
            this.te = te;
            this.outline = new BlockClusterOutline(this.createSelection(te));
            this.particle = OutlineParticle.create(this.outline);
            this.timer = 200;
        }

        protected Set<BlockPos> createSelection(ChassisTileEntity chassis) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            List<BlockPos> includedBlockPositions = chassis.getIncludedBlockPositions(null, true);
            if (includedBlockPositions == null) {
                return Collections.emptySet();
            }
            positions.addAll(includedBlockPositions);
            return positions;
        }
    }
}

