/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.WrappedWorld;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.components.contraptions.AllContraptionTypes;
import com.simibubi.create.modules.contraptions.components.contraptions.BlockMovementTraits;
import com.simibubi.create.modules.contraptions.components.contraptions.IPortableBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.MountedStorage;
import com.simibubi.create.modules.contraptions.components.contraptions.MovementBehaviour;
import com.simibubi.create.modules.contraptions.components.contraptions.MovementContext;
import com.simibubi.create.modules.contraptions.components.contraptions.StructureTransform;
import com.simibubi.create.modules.contraptions.components.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.chassis.ChassisTileEntity;
import com.simibubi.create.modules.contraptions.components.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.modules.contraptions.components.contraptions.glue.SuperGlueHandler;
import com.simibubi.create.modules.contraptions.components.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.piston.MechanicalPistonHeadBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.piston.PistonPoleBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.pulley.PulleyBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.pulley.PulleyTileEntity;
import com.simibubi.create.modules.contraptions.components.saw.SawBlock;
import com.simibubi.create.modules.contraptions.redstone.ContactBlock;
import com.simibubi.create.modules.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.modules.logistics.block.inventories.FlexcrateBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SlimeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Contraption {
    public Map<BlockPos, Template.BlockInfo> blocks = new HashMap<BlockPos, Template.BlockInfo>();
    public Map<BlockPos, MountedStorage> storage = new HashMap<BlockPos, MountedStorage>();
    public List<MutablePair<Template.BlockInfo, MovementContext>> actors = new ArrayList<MutablePair<Template.BlockInfo, MovementContext>>();
    public CombinedInvWrapper inventory;
    public List<TileEntity> customRenderTEs;
    public Set<Pair<BlockPos, Direction>> superglue = new HashSet<Pair<BlockPos, Direction>>();
    public AxisAlignedBB bounds;
    public boolean stalled;
    protected Set<BlockPos> cachedColliders;
    protected Direction cachedColliderDirection;
    protected BlockPos anchor;
    List<BlockPos> renderOrder = new ArrayList<BlockPos>();
    protected List<SuperGlueEntity> glueToRemove;

    public Contraption() {
        this.customRenderTEs = new ArrayList<TileEntity>();
        this.glueToRemove = new ArrayList<SuperGlueEntity>();
    }

    public Set<BlockPos> getColliders(World world, Direction movementDirection) {
        if (this.blocks == null) {
            return null;
        }
        if (this.cachedColliders == null || this.cachedColliderDirection != movementDirection) {
            this.cachedColliders = new HashSet<BlockPos>();
            this.cachedColliderDirection = movementDirection;
            for (Template.BlockInfo info : this.blocks.values()) {
                BlockPos offsetPos = info.field_186242_a.func_177972_a(movementDirection);
                if (info.field_186243_b.func_196952_d((IBlockReader)world, offsetPos).func_197766_b() || this.blocks.containsKey(offsetPos) && !this.blocks.get((Object)offsetPos).field_186243_b.func_196952_d((IBlockReader)world, offsetPos).func_197766_b()) continue;
                this.cachedColliders.add(info.field_186242_a);
            }
        }
        return this.cachedColliders;
    }

    public boolean searchMovedStructure(World world, BlockPos pos, @Nullable Direction forcedDirection) {
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        this.anchor = pos;
        if (this.bounds == null) {
            this.bounds = new AxisAlignedBB(BlockPos.field_177992_a);
        }
        if (!BlockMovementTraits.isBrittle(world.func_180495_p(pos))) {
            frontier.add(pos);
        }
        if (!this.addToInitialFrontier(world, pos, forcedDirection, frontier)) {
            return false;
        }
        for (int limit = 100000; limit > 0; --limit) {
            if (frontier.isEmpty()) {
                return true;
            }
            if (this.moveBlock(world, (BlockPos)frontier.remove(0), forcedDirection, frontier, visited)) continue;
            return false;
        }
        return false;
    }

    public void gatherStoredItems() {
        List list = this.storage.values().stream().map(MountedStorage::getItemHandler).collect(Collectors.toList());
        this.inventory = new CombinedInvWrapper((IItemHandlerModifiable[])Arrays.copyOf(list.toArray(), list.size(), IItemHandlerModifiable[].class));
    }

    protected boolean addToInitialFrontier(World world, BlockPos pos, Direction forcedDirection, List<BlockPos> frontier) {
        return true;
    }

    protected boolean moveBlock(World world, BlockPos pos, Direction forcedDirection, List<BlockPos> frontier, Set<BlockPos> visited) {
        BlockPos otherPartPos;
        visited.add(pos);
        frontier.remove(pos);
        if (!world.func_195588_v(pos)) {
            return false;
        }
        if (this.isAnchoringBlockAt(pos)) {
            return true;
        }
        if (!BlockMovementTraits.movementNecessary(world, pos)) {
            return true;
        }
        if (!BlockMovementTraits.movementAllowed(world, pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (Contraption.isChassis(state) && !this.moveChassis(world, pos, forcedDirection, frontier, visited)) {
            return false;
        }
        if (AllBlocks.FLEXCRATE.typeOf(state)) {
            FlexcrateBlock.splitCrate(world, pos);
        }
        if (AllBlocks.BELT.typeOf(state)) {
            BlockPos nextPos = BeltBlock.nextSegmentPosition(state, pos, true);
            BlockPos prevPos = BeltBlock.nextSegmentPosition(state, pos, false);
            if (nextPos != null && !visited.contains(nextPos)) {
                frontier.add(nextPos);
            }
            if (prevPos != null && !visited.contains(prevPos)) {
                frontier.add(prevPos);
            }
        }
        if (state.func_177230_c() instanceof PulleyBlock) {
            int limit = (Integer)AllConfigs.SERVER.kinetics.maxRopeLength.get();
            BlockPos ropePos = pos;
            while (limit-- >= 0 && world.func_195588_v(ropePos = ropePos.func_177977_b())) {
                BlockState ropeState = world.func_180495_p(ropePos);
                Block block = ropeState.func_177230_c();
                if (!(block instanceof PulleyBlock.RopeBlock) && !(block instanceof PulleyBlock.MagnetBlock)) {
                    if (visited.contains(ropePos)) break;
                    frontier.add(ropePos);
                    break;
                }
                this.add(ropePos, this.capture(world, ropePos));
            }
        }
        if (state.func_177230_c() instanceof MechanicalPistonBlock) {
            BlockState blockState;
            BlockPos searchPos;
            int limit = (Integer)AllConfigs.SERVER.kinetics.maxPistonPoles.get();
            Direction direction = (Direction)state.func_177229_b((IProperty)MechanicalPistonBlock.FACING);
            if (state.func_177229_b(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
                searchPos = pos;
                while (limit-- >= 0) {
                    blockState = world.func_180495_p(searchPos = searchPos.func_177972_a(direction));
                    if (AllBlocks.PISTON_POLE.typeOf(blockState)) {
                        if (((Direction)blockState.func_177229_b((IProperty)PistonPoleBlock.field_176387_N)).func_176740_k() != direction.func_176740_k()) break;
                        if (visited.contains(searchPos)) continue;
                        frontier.add(searchPos);
                        continue;
                    }
                    if (!(blockState.func_177230_c() instanceof MechanicalPistonHeadBlock) || visited.contains(searchPos)) break;
                    frontier.add(searchPos);
                    break;
                }
                if (limit <= -1) {
                    return false;
                }
            }
            searchPos = pos;
            while (limit-- >= 0 && AllBlocks.PISTON_POLE.typeOf(blockState = world.func_180495_p(searchPos = searchPos.func_177972_a(direction.func_176734_d()))) && ((Direction)blockState.func_177229_b((IProperty)PistonPoleBlock.field_176387_N)).func_176740_k() == direction.func_176740_k()) {
                if (visited.contains(searchPos)) continue;
                frontier.add(searchPos);
            }
            if (limit <= -1) {
                return false;
            }
        }
        if (state.func_177230_c() instanceof DoorBlock && !visited.contains(otherPartPos = pos.func_177981_b(state.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.LOWER ? 1 : -1))) {
            frontier.add(otherPartPos);
        }
        Map<Direction, SuperGlueEntity> superglue = SuperGlueHandler.gatherGlue((IWorld)world, pos);
        boolean isSlimeBlock = state.func_177230_c() instanceof SlimeBlock;
        for (Direction offset : Direction.values()) {
            BlockPos offsetPos = pos.func_177972_a(offset);
            BlockState blockState = world.func_180495_p(offsetPos);
            if (this.isAnchoringBlockAt(offsetPos)) continue;
            if (!BlockMovementTraits.movementAllowed(world, offsetPos)) {
                if (offset != forcedDirection || !isSlimeBlock) continue;
                return false;
            }
            boolean wasVisited = visited.contains(offsetPos);
            boolean faceHasGlue = superglue.containsKey(offset);
            boolean blockAttachedTowardsFace = BlockMovementTraits.isBlockAttachedTowards(blockState, offset.func_176734_d());
            boolean brittle = BlockMovementTraits.isBrittle(blockState);
            if (!wasVisited && (isSlimeBlock && !brittle || blockAttachedTowardsFace || faceHasGlue)) {
                frontier.add(offsetPos);
            }
            if (!faceHasGlue) continue;
            this.addGlue(superglue.get(offset));
        }
        this.add(pos, this.capture(world, pos));
        return this.blocks.size() <= (Integer)AllConfigs.SERVER.kinetics.maxBlocksMoved.get();
    }

    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor);
    }

    protected static boolean isChassis(BlockState state) {
        return state.func_177230_c() instanceof AbstractChassisBlock;
    }

    private boolean moveChassis(World world, BlockPos pos, Direction movementDirection, List<BlockPos> frontier, Set<BlockPos> visited) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof ChassisTileEntity)) {
            return false;
        }
        ChassisTileEntity chassis = (ChassisTileEntity)te;
        chassis.addAttachedChasses(frontier, visited);
        List<BlockPos> includedBlockPositions = chassis.getIncludedBlockPositions(movementDirection, false);
        if (includedBlockPositions == null) {
            return false;
        }
        for (BlockPos blockPos : includedBlockPositions) {
            if (visited.contains(blockPos)) continue;
            frontier.add(blockPos);
        }
        return true;
    }

    protected Pair<Template.BlockInfo, TileEntity> capture(World world, BlockPos pos) {
        BlockState blockstate = world.func_180495_p(pos);
        if (AllBlocks.SAW.typeOf(blockstate)) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)SawBlock.RUNNING, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.func_177230_c() instanceof ChestBlock) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE);
        }
        if (AllBlocks.FLEXCRATE.typeOf(blockstate)) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)FlexcrateBlock.DOUBLE, (Comparable)Boolean.valueOf(false));
        }
        if (AllBlocks.CONTACT.typeOf(blockstate)) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)ContactBlock.POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.func_177230_c() instanceof AbstractButtonBlock) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)AbstractButtonBlock.field_176584_b, (Comparable)Boolean.valueOf(false));
            world.func_205220_G_().func_205360_a(pos, (Object)blockstate.func_177230_c(), -1);
        }
        if (blockstate.func_177230_c() instanceof PressurePlateBlock) {
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(false));
            world.func_205220_G_().func_205360_a(pos, (Object)blockstate.func_177230_c(), -1);
        }
        CompoundNBT compoundnbt = Contraption.getTileEntityNBT(world, pos);
        TileEntity tileentity = world.func_175625_s(pos);
        return Pair.of((Object)new Template.BlockInfo(pos, blockstate, compoundnbt), (Object)tileentity);
    }

    public static CompoundNBT getTileEntityNBT(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        CompoundNBT compoundnbt = null;
        if (tileentity != null) {
            compoundnbt = tileentity.func_189515_b(new CompoundNBT());
            compoundnbt.func_82580_o("x");
            compoundnbt.func_82580_o("y");
            compoundnbt.func_82580_o("z");
        }
        return compoundnbt;
    }

    public void addGlue(SuperGlueEntity entity) {
        BlockPos pos = entity.getHangingPosition();
        Direction direction = entity.getFacingDirection();
        BlockPos localPos = pos.func_177973_b((Vec3i)this.anchor);
        this.superglue.add((Pair<BlockPos, Direction>)Pair.of((Object)localPos, (Object)direction));
        this.glueToRemove.add(entity);
    }

    public void add(BlockPos pos, Pair<Template.BlockInfo, TileEntity> pair) {
        Template.BlockInfo blockInfo;
        Template.BlockInfo captured = (Template.BlockInfo)pair.getKey();
        BlockPos localPos = pos.func_177973_b((Vec3i)this.anchor);
        if (this.blocks.put(localPos, blockInfo = new Template.BlockInfo(localPos, captured.field_186243_b, captured.field_186244_c)) != null) {
            return;
        }
        this.bounds = this.bounds.func_111270_a(new AxisAlignedBB(localPos));
        TileEntity te = (TileEntity)pair.getValue();
        if (te != null && MountedStorage.canUseAsStorage(te)) {
            this.storage.put(localPos, new MountedStorage(te));
        }
        if (captured.field_186243_b.func_177230_c() instanceof IPortableBlock) {
            this.getActors().add((MutablePair<Template.BlockInfo, MovementContext>)MutablePair.of((Object)blockInfo, null));
        }
    }

    public static Contraption fromNBT(World world, CompoundNBT nbt) {
        String type = nbt.func_74779_i("Type");
        Contraption contraption = AllContraptionTypes.fromType(type);
        contraption.readNBT(world, nbt);
        return contraption;
    }

    public void readNBT(World world, CompoundNBT nbt) {
        this.blocks.clear();
        this.renderOrder.clear();
        this.customRenderTEs.clear();
        nbt.func_150295_c("Blocks", 10).forEach(c -> {
            CompoundNBT comp = (CompoundNBT)c;
            final Template.BlockInfo info = new Template.BlockInfo(NBTUtil.func_186861_c((CompoundNBT)comp.func_74775_l("Pos")), NBTUtil.func_190008_d((CompoundNBT)comp.func_74775_l("Block")), comp.func_74764_b("Data") ? comp.func_74775_l("Data") : null);
            this.blocks.put(info.field_186242_a, info);
            if (world.field_72995_K) {
                Block block = info.field_186243_b.func_177230_c();
                BlockRenderLayer renderLayer = block.func_180664_k();
                if (renderLayer == BlockRenderLayer.TRANSLUCENT) {
                    this.renderOrder.add(info.field_186242_a);
                } else {
                    this.renderOrder.add(0, info.field_186242_a);
                }
                CompoundNBT tag = info.field_186244_c;
                if (tag == null || block instanceof IPortableBlock) {
                    return;
                }
                tag.func_74768_a("x", info.field_186242_a.func_177958_n());
                tag.func_74768_a("y", info.field_186242_a.func_177956_o());
                tag.func_74768_a("z", info.field_186242_a.func_177952_p());
                final TileEntity te = TileEntity.func_203403_c((CompoundNBT)tag);
                te.func_145834_a((World)new WrappedWorld(world){

                    @Override
                    public BlockState func_180495_p(BlockPos pos) {
                        if (!pos.equals((Object)te.func_174877_v())) {
                            return Blocks.field_150350_a.func_176223_P();
                        }
                        return info.field_186243_b;
                    }
                });
                if (te instanceof KineticTileEntity) {
                    ((KineticTileEntity)te).setSpeed(0.0f);
                }
                te.func_195044_w();
                this.customRenderTEs.add(te);
            }
        });
        this.actors.clear();
        nbt.func_150295_c("Actors", 10).forEach(c -> {
            CompoundNBT comp = (CompoundNBT)c;
            Template.BlockInfo info = this.blocks.get(NBTUtil.func_186861_c((CompoundNBT)comp.func_74775_l("Pos")));
            MovementContext context = MovementContext.readNBT(world, info, comp);
            context.contraption = this;
            this.getActors().add((MutablePair<Template.BlockInfo, MovementContext>)MutablePair.of((Object)info, (Object)context));
        });
        this.superglue.clear();
        nbt.func_150295_c("Superglue", 10).forEach(c -> {
            CompoundNBT comp = (CompoundNBT)c;
            this.superglue.add((Pair<BlockPos, Direction>)Pair.of((Object)NBTUtil.func_186861_c((CompoundNBT)comp.func_74775_l("Pos")), (Object)Direction.func_82600_a((int)comp.func_74771_c("Direction"))));
        });
        this.storage.clear();
        nbt.func_150295_c("Storage", 10).forEach(c -> {
            CompoundNBT comp = (CompoundNBT)c;
            this.storage.put(NBTUtil.func_186861_c((CompoundNBT)comp.func_74775_l("Pos")), new MountedStorage(comp.func_74775_l("Data")));
        });
        List list = this.storage.values().stream().map(MountedStorage::getItemHandler).collect(Collectors.toList());
        this.inventory = new CombinedInvWrapper((IItemHandlerModifiable[])Arrays.copyOf(list.toArray(), list.size(), IItemHandlerModifiable[].class));
        if (nbt.func_74764_b("BoundsFront")) {
            this.bounds = NBTHelper.readAABB(nbt.func_150295_c("BoundsFront", 5));
        }
        this.stalled = nbt.func_74767_n("Stalled");
        this.anchor = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Anchor"));
    }

    public CompoundNBT writeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("Type", this.getType().id);
        ListNBT blocksNBT = new ListNBT();
        for (Template.BlockInfo blockInfo : this.blocks.values()) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_218657_a("Block", (INBT)NBTUtil.func_190009_a((BlockState)blockInfo.field_186243_b));
            compoundNBT.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)blockInfo.field_186242_a));
            if (blockInfo.field_186244_c != null) {
                compoundNBT.func_218657_a("Data", (INBT)blockInfo.field_186244_c);
            }
            blocksNBT.add((Object)compoundNBT);
        }
        ListNBT actorsNBT = new ListNBT();
        for (MutablePair<Template.BlockInfo, MovementContext> mutablePair : this.getActors()) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)((Template.BlockInfo)mutablePair.left).field_186242_a));
            Contraption.getMovement(((Template.BlockInfo)mutablePair.left).field_186243_b).writeExtraData((MovementContext)mutablePair.right);
            ((MovementContext)mutablePair.right).writeToNBT(compoundNBT);
            actorsNBT.add((Object)compoundNBT);
        }
        ListNBT listNBT = new ListNBT();
        for (Pair<BlockPos, Direction> pair : this.superglue) {
            CompoundNBT c = new CompoundNBT();
            c.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)pair.getKey())));
            c.func_74774_a("Direction", (byte)((Direction)pair.getValue()).func_176745_a());
            listNBT.add((Object)c);
        }
        ListNBT listNBT2 = new ListNBT();
        for (BlockPos pos : this.storage.keySet()) {
            CompoundNBT c = new CompoundNBT();
            MountedStorage mountedStorage = this.storage.get(pos);
            if (!mountedStorage.isWorking()) continue;
            c.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            c.func_218657_a("Data", (INBT)mountedStorage.serialize());
            listNBT2.add((Object)c);
        }
        nbt.func_218657_a("Blocks", (INBT)blocksNBT);
        nbt.func_218657_a("Actors", (INBT)actorsNBT);
        nbt.func_218657_a("Superglue", (INBT)listNBT);
        nbt.func_218657_a("Storage", (INBT)listNBT2);
        nbt.func_218657_a("Anchor", (INBT)NBTUtil.func_186859_a((BlockPos)this.anchor));
        nbt.func_74757_a("Stalled", this.stalled);
        if (this.bounds != null) {
            ListNBT listNBT3 = NBTHelper.writeAABB(this.bounds);
            nbt.func_218657_a("BoundsFront", (INBT)listNBT3);
        }
        return nbt;
    }

    public static boolean isFrozen() {
        return (Boolean)AllConfigs.SERVER.control.freezeContraptions.get();
    }

    public void removeBlocksFromWorld(IWorld world, BlockPos offset) {
        this.removeBlocksFromWorld(world, offset, (pos, state) -> false);
    }

    public void removeBlocksFromWorld(IWorld world, BlockPos offset, BiPredicate<BlockPos, BlockState> customRemoval) {
        this.storage.values().forEach(MountedStorage::empty);
        this.glueToRemove.forEach(Entity::func_70106_y);
        for (boolean brittles : Iterate.trueAndFalse) {
            for (Template.BlockInfo block : this.blocks.values()) {
                BlockPos add;
                if (brittles != BlockMovementTraits.isBrittle(block.field_186243_b) || customRemoval.test(add = block.field_186242_a.func_177971_a((Vec3i)this.anchor).func_177971_a((Vec3i)offset), block.field_186243_b)) continue;
                world.func_201672_e().func_175713_t(add);
                int flags = 67;
                if (world.func_180495_p(add).func_177230_c() instanceof DoorBlock) {
                    flags = flags | 0x20 | 0x10;
                }
                world.func_180501_a(add, Blocks.field_150350_a.func_176223_P(), flags);
            }
        }
    }

    public void addBlocksToWorld(World world, BlockPos offset, Vec3d rotation) {
        this.addBlocksToWorld(world, offset, rotation, (pos, state) -> false);
    }

    public void addBlocksToWorld(World world, BlockPos offset, Vec3d rotation, BiPredicate<BlockPos, BlockState> customPlacement) {
        this.stop(world);
        StructureTransform transform = new StructureTransform(offset, rotation);
        for (boolean nonBrittles : Iterate.trueAndFalse) {
            for (Template.BlockInfo block : this.blocks.values()) {
                MountedStorage mountedStorage;
                BlockState blockState;
                BlockState state;
                BlockPos targetPos;
                if (nonBrittles == BlockMovementTraits.isBrittle(block.field_186243_b) || customPlacement.test(targetPos = transform.apply(block.field_186242_a), state = transform.apply(block.field_186243_b))) continue;
                if (nonBrittles) {
                    for (Direction face : Direction.values()) {
                        state = state.func_196956_a(face, world.func_180495_p(targetPos.func_177972_a(face)), (IWorld)world, targetPos, targetPos.func_177972_a(face));
                    }
                }
                if (AllBlocks.SAW.typeOf(state)) {
                    state = (BlockState)state.func_206870_a((IProperty)SawBlock.RUNNING, (Comparable)Boolean.valueOf(false));
                }
                if ((blockState = world.func_180495_p(targetPos)).func_185887_b((IBlockReader)world, targetPos) == -1.0f || state.func_196952_d((IBlockReader)world, targetPos).func_197766_b() && !blockState.func_196952_d((IBlockReader)world, targetPos).func_197766_b()) continue;
                world.func_175655_b(targetPos, true);
                world.func_180501_a(targetPos, state, 67);
                boolean verticalRotation = transform.rotationAxis == null || transform.rotationAxis.func_176722_c();
                boolean bl = verticalRotation = verticalRotation && transform.rotation != Rotation.NONE;
                if (verticalRotation && (state.func_177230_c() instanceof PulleyBlock.RopeBlock || state.func_177230_c() instanceof PulleyBlock.MagnetBlock)) {
                    world.func_175655_b(targetPos, true);
                }
                TileEntity tileEntity = world.func_175625_s(targetPos);
                CompoundNBT tag = block.field_186244_c;
                if (tileEntity == null || tag == null) continue;
                tag.func_74768_a("x", targetPos.func_177958_n());
                tag.func_74768_a("y", targetPos.func_177956_o());
                tag.func_74768_a("z", targetPos.func_177952_p());
                if (verticalRotation && tileEntity instanceof PulleyTileEntity) {
                    tag.func_82580_o("Offset");
                    tag.func_82580_o("InitialOffset");
                }
                tileEntity.func_145839_a(tag);
                if (!this.storage.containsKey(block.field_186242_a) || !(mountedStorage = this.storage.get(block.field_186242_a)).isWorking()) continue;
                mountedStorage.fill(tileEntity);
            }
        }
        Object object = this.superglue.iterator();
        while (object.hasNext()) {
            Direction targetFacing;
            Pair pair = (Pair)object.next();
            BlockPos targetPos = transform.apply((BlockPos)pair.getKey());
            SuperGlueEntity entity = new SuperGlueEntity(world, targetPos, targetFacing = transform.transformFacing((Direction)pair.getValue()));
            if (!entity.onValidSurface() || world.field_72995_K) continue;
            world.func_217376_c((Entity)entity);
        }
    }

    public void initActors(World world) {
        for (MutablePair<Template.BlockInfo, MovementContext> pair : this.actors) {
            MovementContext context = new MovementContext(world, (Template.BlockInfo)pair.left);
            context.contraption = this;
            Contraption.getMovement(((Template.BlockInfo)pair.left).field_186243_b).startMoving(context);
            pair.setRight((Object)context);
        }
    }

    public AxisAlignedBB getBoundingBox() {
        return this.bounds;
    }

    public List<MutablePair<Template.BlockInfo, MovementContext>> getActors() {
        return this.actors;
    }

    public BlockPos getAnchor() {
        return this.anchor;
    }

    public void stop(World world) {
        this.foreachActor(world, (behaviour, ctx) -> {
            behaviour.stopMoving((MovementContext)ctx);
            ctx.position = null;
            ctx.motion = Vec3d.field_186680_a;
            ctx.relativeMotion = Vec3d.field_186680_a;
            ctx.rotation = Vec3d.field_186680_a;
        });
    }

    public void foreachActor(World world, BiConsumer<MovementBehaviour, MovementContext> callBack) {
        for (MutablePair<Template.BlockInfo, MovementContext> pair : this.actors) {
            callBack.accept(Contraption.getMovement(((Template.BlockInfo)pair.getLeft()).field_186243_b), (MovementContext)pair.getRight());
        }
    }

    protected static MovementBehaviour getMovement(BlockState state) {
        Block block = state.func_177230_c();
        if (!(block instanceof IPortableBlock)) {
            return null;
        }
        return ((IPortableBlock)block).getMovementBehaviour();
    }

    public void expandBoundsAroundAxis(Direction.Axis axis) {
        AxisAlignedBB bb = this.bounds;
        double maxXDiff = Math.max(bb.field_72336_d - 1.0, -bb.field_72340_a);
        double maxYDiff = Math.max(bb.field_72337_e - 1.0, -bb.field_72338_b);
        double maxZDiff = Math.max(bb.field_72334_f - 1.0, -bb.field_72339_c);
        double maxDiff = 0.0;
        if (axis == Direction.Axis.X) {
            maxDiff = Math.max(maxZDiff, maxYDiff);
        }
        if (axis == Direction.Axis.Y) {
            maxDiff = Math.max(maxZDiff, maxXDiff);
        }
        if (axis == Direction.Axis.Z) {
            maxDiff = Math.max(maxXDiff, maxYDiff);
        }
        Vec3d vec = new Vec3d(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).func_176730_m());
        Vec3d planeByNormal = VecHelper.planeByNormal(vec);
        Vec3d min = vec.func_216372_d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_178787_e(planeByNormal.func_186678_a(-maxDiff));
        Vec3d max = vec.func_216372_d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_178787_e(planeByNormal.func_186678_a(maxDiff + 1.0));
        this.bounds = new AxisAlignedBB(min, max);
    }

    protected abstract AllContraptionTypes getType();
}

