/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.modules.contraptions.components.actors.BlockBreakingMovementBehaviour;
import com.simibubi.create.modules.contraptions.components.contraptions.Contraption;
import com.simibubi.create.modules.contraptions.components.contraptions.ContraptionEntity;
import com.simibubi.create.modules.contraptions.components.contraptions.IPortableBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ContraptionCollider {
    static Map<Object, AxisAlignedBB> renderedBBs = new HashMap<Object, AxisAlignedBB>();
    public static boolean wasClientPlayerGrounded;

    public static void collideEntities(ContraptionEntity contraptionEntity) {
        if (Contraption.isFrozen()) {
            return;
        }
        if (!contraptionEntity.collisionEnabled()) {
            return;
        }
        World world = contraptionEntity.func_130014_f_();
        Vec3d contraptionMotion = contraptionEntity.func_213322_ci();
        Contraption contraption = contraptionEntity.getContraption();
        AxisAlignedBB bounds = contraptionEntity.func_174813_aQ();
        Vec3d contraptionPosition = contraptionEntity.func_213303_ch();
        contraptionEntity.collidingEntities.clear();
        if (contraption == null) {
            return;
        }
        if (bounds == null) {
            return;
        }
        for (Entity entity : world.func_217394_a((EntityType)null, bounds.func_186662_g(1.0), e -> ContraptionCollider.canBeCollidedWith(e))) {
            ReuseableStream<VoxelShape> potentialHits = ContraptionCollider.getPotentiallyCollidedShapes(world, contraption, contraptionPosition, entity);
            if (potentialHits.func_212761_a().count() == 0L) continue;
            Vec3d positionOffset = contraptionPosition.func_186678_a(-1.0);
            AxisAlignedBB entityBB = entity.func_174813_aQ().func_191194_a(positionOffset).func_186662_g(1.0E-7);
            Vec3d entityMotion = entity.func_213322_ci();
            Vec3d relativeMotion = entityMotion.func_178788_d(contraptionMotion);
            Vec3d allowedMovement = Entity.func_213313_a((Vec3d)relativeMotion, (AxisAlignedBB)entityBB, (IWorldReader)world, (ISelectionContext)ISelectionContext.func_216374_a((Entity)entity), potentialHits);
            potentialHits.func_212761_a().forEach(voxelShape -> ContraptionCollider.pushEntityOutOfShape(entity, voxelShape, positionOffset, contraptionMotion));
            contraptionEntity.collidingEntities.add(entity);
            if (allowedMovement.equals((Object)relativeMotion)) continue;
            if (allowedMovement.field_72448_b != relativeMotion.field_72448_b) {
                entity.func_180430_e(entity.field_70143_R, 1.0f);
                entity.field_70143_R = 0.0f;
                entity.field_70122_E = true;
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ContraptionCollider.checkForClientPlayerCollision(entity));
            }
            if (entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).field_71135_a.field_147365_f = 0;
            }
            if (entity instanceof PlayerEntity && !world.field_72995_K) {
                return;
            }
            entity.func_213317_d(allowedMovement.func_178787_e(contraptionMotion));
            entity.field_70133_I = true;
        }
    }

    public static boolean canBeCollidedWith(Entity e) {
        if (e instanceof PlayerEntity && e.func_175149_v()) {
            return false;
        }
        if (e.field_70145_X) {
            return false;
        }
        if (e instanceof IProjectile) {
            return false;
        }
        return e.func_184192_z() == PushReaction.NORMAL;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void checkForClientPlayerCollision(Entity entity) {
        if (entity != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        wasClientPlayerGrounded = true;
    }

    public static void pushEntityOutOfShape(Entity entity, VoxelShape voxelShape, Vec3d positionOffset, Vec3d shapeMotion) {
        AxisAlignedBB entityBB = entity.func_174813_aQ().func_191194_a(positionOffset);
        Vec3d entityMotion = entity.func_213322_ci();
        if (!voxelShape.func_197756_d().stream().anyMatch(arg_0 -> ((AxisAlignedBB)entityBB).func_72326_a(arg_0))) {
            return;
        }
        AxisAlignedBB shapeBB = voxelShape.func_197752_a();
        Direction bestSide = Direction.DOWN;
        double bestOffset = 100.0;
        double finalOffset = 0.0;
        for (Direction face : Direction.values()) {
            double offset;
            Direction.Axis axis = face.func_176740_k();
            double d = axis == Direction.Axis.X ? entityBB.func_216364_b() + shapeBB.func_216364_b() : (axis == Direction.Axis.Y ? entityBB.func_216360_c() + shapeBB.func_216360_c() : entityBB.func_216362_d() + shapeBB.func_216362_d());
            Vec3d nudge = new Vec3d(face.func_176730_m()).func_186678_a(d += 0.5);
            AxisAlignedBB nudgedBB = entityBB.func_72317_d(nudge.func_82615_a(), nudge.func_82617_b(), nudge.func_82616_c());
            double nudgeDistance = face.func_176743_c() == Direction.AxisDirection.POSITIVE ? -d : d;
            double abs = Math.abs(nudgeDistance - (offset = voxelShape.func_212430_a(face.func_176740_k(), nudgedBB, nudgeDistance)));
            if (!(abs < Math.abs(bestOffset)) || abs == 0.0) continue;
            bestOffset = abs;
            finalOffset = abs;
            bestSide = face;
        }
        if (bestOffset != 0.0) {
            entity.func_213315_a(MoverType.SELF, new Vec3d(bestSide.func_176730_m()).func_186678_a(finalOffset));
            boolean positive = bestSide.func_176743_c() == Direction.AxisDirection.POSITIVE;
            switch (bestSide.func_176740_k()) {
                case X: {
                    double clamped = positive ? Math.max(shapeMotion.field_72450_a, entityMotion.field_72450_a) : Math.min(shapeMotion.field_72450_a, entityMotion.field_72450_a);
                    entity.func_213293_j(clamped, entityMotion.field_72448_b, entityMotion.field_72449_c);
                    break;
                }
                case Y: {
                    double clamped;
                    double d = clamped = positive ? Math.max(shapeMotion.field_72448_b, entityMotion.field_72448_b) : Math.min(shapeMotion.field_72448_b, entityMotion.field_72448_b);
                    if (bestSide == Direction.UP) {
                        clamped = shapeMotion.field_72448_b;
                    }
                    entity.func_213293_j(entityMotion.field_72450_a, clamped, entityMotion.field_72449_c);
                    entity.func_180430_e(entity.field_70143_R, 1.0f);
                    entity.field_70143_R = 0.0f;
                    entity.field_70122_E = true;
                    break;
                }
                case Z: {
                    double clamped = positive ? Math.max(shapeMotion.field_72449_c, entityMotion.field_72449_c) : Math.min(shapeMotion.field_72449_c, entityMotion.field_72449_c);
                    entity.func_213293_j(entityMotion.field_72450_a, entityMotion.field_72448_b, clamped);
                }
            }
        }
    }

    public static ReuseableStream<VoxelShape> getPotentiallyCollidedShapes(World world, Contraption contraption, Vec3d contraptionPosition, Entity entity) {
        AxisAlignedBB blockScanBB = entity.func_174813_aQ().func_191194_a(contraptionPosition.func_186678_a(-1.0)).func_186662_g(0.5);
        BlockPos min = new BlockPos(blockScanBB.field_72340_a, blockScanBB.field_72338_b, blockScanBB.field_72339_c);
        BlockPos max = new BlockPos(blockScanBB.field_72336_d, blockScanBB.field_72337_e, blockScanBB.field_72334_f);
        ReuseableStream potentialHits = new ReuseableStream(BlockPos.func_218281_b((BlockPos)min, (BlockPos)max).filter(contraption.blocks::containsKey).map(p -> {
            BlockState blockState = contraption.blocks.get((Object)p).field_186243_b;
            BlockPos pos = contraption.blocks.get((Object)p).field_186242_a;
            VoxelShape collisionShape = blockState.func_196952_d((IBlockReader)world, p);
            return collisionShape.func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }));
        return potentialHits;
    }

    public static boolean collideBlocks(ContraptionEntity contraptionEntity) {
        if (Contraption.isFrozen()) {
            return true;
        }
        if (!contraptionEntity.collisionEnabled()) {
            return false;
        }
        World world = contraptionEntity.func_130014_f_();
        Vec3d motion = contraptionEntity.func_213322_ci();
        Contraption contraption = contraptionEntity.getContraption();
        AxisAlignedBB bounds = contraptionEntity.func_174813_aQ();
        Vec3d position = contraptionEntity.func_213303_ch();
        BlockPos gridPos = new BlockPos(position);
        if (contraption == null) {
            return false;
        }
        if (bounds == null) {
            return false;
        }
        if (motion.equals((Object)Vec3d.field_186680_a)) {
            return false;
        }
        Direction movementDirection = Direction.func_210769_a((double)motion.field_72450_a, (double)motion.field_72448_b, (double)motion.field_72449_c);
        if (movementDirection.func_176743_c() == Direction.AxisDirection.POSITIVE) {
            gridPos = gridPos.func_177972_a(movementDirection);
        }
        if (ContraptionCollider.isCollidingWithWorld(world, contraption, gridPos, movementDirection)) {
            return true;
        }
        for (ContraptionEntity otherContraptionEntity : world.func_175647_a(ContraptionEntity.class, bounds.func_186662_g(1.0), e -> !e.equals((Object)contraptionEntity))) {
            if (!otherContraptionEntity.collisionEnabled()) continue;
            Vec3d otherMotion = otherContraptionEntity.func_213322_ci();
            Contraption otherContraption = otherContraptionEntity.getContraption();
            AxisAlignedBB otherBounds = otherContraptionEntity.func_174813_aQ();
            Vec3d otherPosition = otherContraptionEntity.func_213303_ch();
            if (otherContraption == null) {
                return false;
            }
            if (otherBounds == null) {
                return false;
            }
            if (!bounds.func_191194_a(motion).func_72326_a(otherBounds.func_191194_a(otherMotion))) continue;
            for (BlockPos colliderPos : contraption.getColliders(world, movementDirection)) {
                if (!otherContraption.blocks.containsKey(colliderPos = colliderPos.func_177971_a((Vec3i)gridPos).func_177973_b((Vec3i)new BlockPos(otherPosition)))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCollidingWithWorld(World world, Contraption contraption, BlockPos anchor, Direction movementDirection) {
        for (BlockPos pos : contraption.getColliders(world, movementDirection)) {
            BlockBreakingMovementBehaviour behaviour;
            IPortableBlock block;
            BlockPos colliderPos = pos.func_177971_a((Vec3i)anchor);
            if (!world.func_195588_v(colliderPos)) {
                return true;
            }
            BlockState collidedState = world.func_180495_p(colliderPos);
            Template.BlockInfo blockInfo = contraption.blocks.get(pos);
            if (!(blockInfo.field_186243_b.func_177230_c() instanceof IPortableBlock && (block = (IPortableBlock)blockInfo.field_186243_b.func_177230_c()).getMovementBehaviour() instanceof BlockBreakingMovementBehaviour ? !(behaviour = (BlockBreakingMovementBehaviour)block.getMovementBehaviour()).canBreak(world, colliderPos, collidedState) && !collidedState.func_196952_d((IBlockReader)world, pos).func_197766_b() : (!AllBlocks.PULLEY_MAGNET.typeOf(collidedState) || !pos.equals((Object)BlockPos.field_177992_a) || movementDirection != Direction.UP) && !(collidedState.func_177230_c() instanceof CocoaBlock) && !collidedState.func_185904_a().func_76222_j() && !collidedState.func_196952_d((IBlockReader)world, colliderPos).func_197766_b())) continue;
            return true;
        }
        return false;
    }
}

