/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions;

import com.google.common.collect.ImmutableSet;
import com.simibubi.create.AllEntities;
import com.simibubi.create.AllPackets;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.components.contraptions.AllContraptionTypes;
import com.simibubi.create.modules.contraptions.components.contraptions.Contraption;
import com.simibubi.create.modules.contraptions.components.contraptions.ContraptionCollider;
import com.simibubi.create.modules.contraptions.components.contraptions.ContraptionStallPacket;
import com.simibubi.create.modules.contraptions.components.contraptions.IControlContraption;
import com.simibubi.create.modules.contraptions.components.contraptions.MovementBehaviour;
import com.simibubi.create.modules.contraptions.components.contraptions.MovementContext;
import com.simibubi.create.modules.contraptions.components.contraptions.bearing.BearingContraption;
import com.simibubi.create.modules.contraptions.components.contraptions.mounted.CartAssemblerTileEntity;
import com.simibubi.create.modules.contraptions.components.contraptions.mounted.MountedContraption;
import com.simibubi.create.modules.contraptions.components.contraptions.piston.LinearActuatorTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.MutablePair;

public class ContraptionEntity
extends Entity
implements IEntityAdditionalSpawnData {
    protected Contraption contraption;
    protected float initialAngle;
    protected float forcedAngle;
    protected BlockPos controllerPos;
    protected Vec3d motionBeforeStall;
    protected boolean stationary;
    final List<Entity> collidingEntities = new ArrayList<Entity>();
    private static final Ingredient FUEL_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151044_h, Items.field_196155_l});
    private static final DataParameter<Boolean> STALLED = EntityDataManager.func_187226_a(ContraptionEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float prevYaw;
    public float prevPitch;
    public float prevRoll;
    public float yaw;
    public float pitch;
    public float roll;
    public float targetYaw;
    public float targetPitch;

    public ContraptionEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.motionBeforeStall = Vec3d.field_186680_a;
        this.stationary = entityTypeIn == AllEntities.STATIONARY_CONTRAPTION.type;
        this.forcedAngle = -1.0f;
    }

    public static ContraptionEntity createMounted(World world, Contraption contraption, float initialAngle) {
        ContraptionEntity entity = new ContraptionEntity(AllEntities.CONTRAPTION.type, world);
        entity.contraption = contraption;
        entity.initialAngle = initialAngle;
        entity.forceYaw(initialAngle);
        if (contraption != null) {
            contraption.gatherStoredItems();
        }
        return entity;
    }

    public static ContraptionEntity createMounted(World world, Contraption contraption, float initialAngle, Direction facing) {
        ContraptionEntity entity = ContraptionEntity.createMounted(world, contraption, initialAngle);
        entity.forcedAngle = facing.func_185119_l();
        entity.forceYaw(entity.forcedAngle);
        return entity;
    }

    public static ContraptionEntity createStationary(World world, Contraption contraption) {
        ContraptionEntity entity = new ContraptionEntity(AllEntities.STATIONARY_CONTRAPTION.type, world);
        entity.contraption = contraption;
        if (contraption != null) {
            contraption.gatherStoredItems();
        }
        return entity;
    }

    public <T extends TileEntity> ContraptionEntity controlledBy(T controller) {
        this.controllerPos = controller.func_174877_v();
        return this;
    }

    private IControlContraption getController() {
        if (this.controllerPos == null) {
            return null;
        }
        if (!this.field_70170_p.func_195588_v(this.controllerPos)) {
            return null;
        }
        TileEntity te = this.field_70170_p.func_175625_s(this.controllerPos);
        if (!(te instanceof IControlContraption)) {
            return null;
        }
        return (IControlContraption)te;
    }

    public boolean collisionEnabled() {
        return this.getController() instanceof LinearActuatorTileEntity;
    }

    public void func_70071_h_() {
        if (this.contraption == null) {
            this.func_70106_y();
            return;
        }
        this.checkController();
        Entity mountedEntity = this.func_184187_bx();
        if (mountedEntity != null) {
            this.tickAsPassenger(mountedEntity);
            return;
        }
        if (this.func_213322_ci().func_72433_c() < 2.4402147391811013E-4) {
            this.func_213317_d(Vec3d.field_186680_a);
        }
        this.move(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
        if (ContraptionCollider.collideBlocks(this)) {
            this.getController().collided();
        }
        this.tickActors(new Vec3d(this.field_70165_t - this.field_70169_q, this.field_70163_u - this.field_70167_r, this.field_70161_v - this.field_70166_s));
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        this.prevRoll = this.roll;
        super.func_70071_h_();
    }

    public void collisionTick() {
        ContraptionCollider.collideEntities(this);
    }

    public void tickAsPassenger(Entity e) {
        boolean rotationLock = false;
        boolean pauseWhileRotating = false;
        if (this.contraption instanceof MountedContraption) {
            rotationLock = ((MountedContraption)this.contraption).rotationMode == CartAssemblerTileEntity.CartMovementMode.ROTATION_LOCKED;
            pauseWhileRotating = ((MountedContraption)this.contraption).rotationMode == CartAssemblerTileEntity.CartMovementMode.ROTATE_PAUSED;
        }
        Entity riding = e;
        while (riding.func_184187_bx() != null) {
            riding = riding.func_184187_bx();
        }
        Vec3d movementVector = riding.func_213322_ci();
        if (riding instanceof BoatEntity) {
            movementVector = new Vec3d(this.field_70165_t - this.field_70169_q, this.field_70163_u - this.field_70167_r, this.field_70161_v - this.field_70166_s);
        }
        Vec3d motion = movementVector.func_72432_b();
        boolean rotating = false;
        if (!rotationLock) {
            if (motion.func_72433_c() > 0.0) {
                this.targetYaw = ContraptionEntity.yawFromVector(motion);
                if (this.targetYaw < 0.0f) {
                    this.targetYaw += 360.0f;
                }
                if (this.yaw < 0.0f) {
                    this.yaw += 360.0f;
                }
            }
            this.prevYaw = this.yaw;
            this.yaw = AngleHelper.angleLerp(0.4f, this.yaw, this.targetYaw);
            if (Math.abs(AngleHelper.getShortestAngleDiff(this.yaw, this.targetYaw)) < 1.0f) {
                this.yaw = this.targetYaw;
            } else {
                rotating = true;
            }
        }
        boolean wasStalled = this.isStalled();
        if (!rotating || !pauseWhileRotating) {
            this.tickActors(movementVector);
        }
        if (this.isStalled()) {
            if (!wasStalled) {
                this.motionBeforeStall = riding.func_213322_ci();
            }
            riding.func_213293_j(0.0, 0.0, 0.0);
        }
        if (wasStalled && !this.isStalled()) {
            riding.func_213317_d(this.motionBeforeStall);
            this.motionBeforeStall = Vec3d.field_186680_a;
        }
        if (!this.isStalled() && riding instanceof FurnaceMinecartEntity) {
            ItemStack coal;
            int k;
            int j;
            int fuel;
            FurnaceMinecartEntity furnaceCart = (FurnaceMinecartEntity)riding;
            CompoundNBT nbt = furnaceCart.serializeNBT();
            int fuelBefore = fuel = nbt.func_74762_e("Fuel");
            double pushX = nbt.func_74769_h("PushX");
            double pushZ = nbt.func_74769_h("PushZ");
            int i = MathHelper.func_76128_c((double)furnaceCart.field_70165_t);
            if (furnaceCart.field_70170_p.func_180495_p(new BlockPos(i, (j = MathHelper.func_76128_c((double)furnaceCart.field_70163_u)) - 1, k = MathHelper.func_76128_c((double)furnaceCart.field_70161_v))).func_203425_a(BlockTags.field_203437_y)) {
                --j;
            }
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (furnaceCart.canUseRail() && blockstate.func_203425_a(BlockTags.field_203437_y) && fuel > 1) {
                riding.func_213317_d(riding.func_213322_ci().func_72432_b().func_186678_a(1.0));
            }
            if (fuel < 5 && this.contraption != null && !(coal = ItemHelper.extract((IItemHandler)this.contraption.inventory, (Predicate<ItemStack>)FUEL_ITEMS, 1, false)).func_190926_b()) {
                fuel += 3600;
            }
            if (fuel != fuelBefore || pushX != 0.0 || pushZ != 0.0) {
                nbt.func_74768_a("Fuel", fuel);
                nbt.func_74780_a("PushX", 0.0);
                nbt.func_74780_a("PushZ", 0.0);
                furnaceCart.deserializeNBT(nbt);
            }
        }
        super.func_70071_h_();
    }

    public void tickActors(Vec3d movementVector) {
        float anglePitch = this.func_195050_f(1.0f);
        float angleYaw = this.func_195046_g(1.0f);
        float angleRoll = this.getRoll(1.0f);
        Vec3d rotationVec = new Vec3d((double)angleRoll, (double)angleYaw, (double)anglePitch);
        Vec3d rotationOffset = VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a);
        boolean stalledPreviously = this.contraption.stalled;
        if (!this.field_70170_p.field_72995_K) {
            this.contraption.stalled = false;
        }
        for (MutablePair<Template.BlockInfo, MovementContext> pair : this.contraption.actors) {
            MovementContext context = (MovementContext)pair.right;
            Template.BlockInfo blockInfo = (Template.BlockInfo)pair.left;
            MovementBehaviour actor = Contraption.getMovement(blockInfo.field_186243_b);
            Vec3d actorPosition = new Vec3d((Vec3i)blockInfo.field_186242_a);
            actorPosition = actorPosition.func_178787_e(actor.getActiveAreaOffset(context));
            actorPosition = VecHelper.rotate(actorPosition, angleRoll, angleYaw, anglePitch);
            actorPosition = actorPosition.func_178787_e(rotationOffset).func_178787_e(this.getAnchorVec());
            boolean newPosVisited = false;
            BlockPos gridPosition = new BlockPos(actorPosition);
            if (!context.stall) {
                Vec3d previousPosition = context.position;
                if (previousPosition != null) {
                    Vec3d relativeMotion = context.motion = actorPosition.func_178788_d(previousPosition);
                    context.relativeMotion = relativeMotion = VecHelper.rotate(relativeMotion, -angleRoll, -angleYaw, -anglePitch);
                    boolean bl = newPosVisited = !new BlockPos(previousPosition).equals((Object)gridPosition) || context.relativeMotion.func_72433_c() > 0.0 && context.firstMovement;
                }
                if (this.getContraption() instanceof BearingContraption) {
                    BearingContraption bc = (BearingContraption)this.getContraption();
                    Direction facing = bc.getFacing();
                    Vec3d activeAreaOffset = actor.getActiveAreaOffset(context);
                    if (activeAreaOffset.func_216369_h(VecHelper.planeByNormal(new Vec3d(facing.func_176730_m()))).equals((Object)Vec3d.field_186680_a) && VecHelper.onSameAxis(blockInfo.field_186242_a, BlockPos.field_177992_a, facing.func_176740_k())) {
                        context.relativeMotion = context.motion = new Vec3d(facing.func_176730_m()).func_186678_a(facing.func_176740_k().func_196051_a((double)(this.roll - this.prevRoll), (double)(this.yaw - this.prevYaw), (double)(this.pitch - this.prevPitch)));
                        int timer = context.data.func_74762_e("StationaryTimer");
                        if (timer > 0) {
                            context.data.func_74768_a("StationaryTimer", timer - 1);
                        } else {
                            context.data.func_74768_a("StationaryTimer", 20);
                            newPosVisited = true;
                        }
                    }
                }
            }
            context.rotation = rotationVec;
            context.position = actorPosition;
            if (!actor.isActive(context)) continue;
            if (newPosVisited && !context.stall) {
                actor.visitNewPosition(context, gridPosition);
                context.firstMovement = false;
            }
            actor.tick(context);
            this.contraption.stalled |= context.stall;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!stalledPreviously && this.contraption.stalled) {
                this.func_213317_d(Vec3d.field_186680_a);
                if (this.getController() != null) {
                    this.getController().onStall();
                }
                AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ContraptionStallPacket(this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.yaw, this.pitch, this.roll));
            }
            this.field_70180_af.func_187227_b(STALLED, (Object)this.contraption.stalled);
        } else {
            this.contraption.stalled = this.isStalled();
        }
    }

    public void move(double x, double y, double z) {
        this.func_70107_b(this.field_70165_t + x, this.field_70163_u + y, this.field_70161_v + z);
    }

    private Vec3d getAnchorVec() {
        if (this.contraption != null && this.contraption.getType() == AllContraptionTypes.MOUNTED) {
            return new Vec3d(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5);
        }
        return this.func_213303_ch();
    }

    public void rotateTo(double roll, double yaw, double pitch) {
        this.rotate(AngleHelper.getShortestAngleDiff(this.roll, roll), AngleHelper.getShortestAngleDiff(this.yaw, yaw), AngleHelper.getShortestAngleDiff(this.pitch, pitch));
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
    }

    public void rotate(double roll, double yaw, double pitch) {
        this.yaw = (float)((double)this.yaw + yaw);
        this.pitch = (float)((double)this.pitch + pitch);
        this.roll = (float)((double)this.roll + roll);
    }

    public void func_70107_b(double x, double y, double z) {
        AxisAlignedBB cbox;
        super.func_70107_b(x, y, z);
        if (this.contraption != null && (cbox = this.contraption.getBoundingBox()) != null) {
            Vec3d actualVec = this.getAnchorVec();
            this.func_174826_a(cbox.func_191194_a(actualVec));
        }
    }

    public void func_184210_p() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.disassemble();
        }
        super.func_184210_p();
    }

    public static float yawFromVector(Vec3d vec) {
        return (float)((4.71238898038469 + Math.atan2(vec.field_72449_c, vec.field_72450_a)) / Math.PI * 180.0);
    }

    public static float pitchFromVector(Vec3d vec) {
        return (float)(Math.acos(vec.field_72448_b) / Math.PI * 180.0);
    }

    public float func_195046_g(float partialTicks) {
        return (float)(this.func_184187_bx() == null ? 1 : -1) * (partialTicks == 1.0f ? this.yaw : AngleHelper.angleLerp(partialTicks, this.prevYaw, this.yaw)) + this.initialAngle;
    }

    public float func_195050_f(float partialTicks) {
        return partialTicks == 1.0f ? this.pitch : AngleHelper.angleLerp(partialTicks, this.prevPitch, this.pitch);
    }

    public float getRoll(float partialTicks) {
        return partialTicks == 1.0f ? this.roll : AngleHelper.angleLerp(partialTicks, this.prevRoll, this.roll);
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.func_220321_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(STALLED, (Object)false);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.contraption = Contraption.fromNBT(this.field_70170_p, compound.func_74775_l("Contraption"));
        this.initialAngle = compound.func_74760_g("InitialAngle");
        this.forceYaw(compound.func_74764_b("ForcedYaw") ? compound.func_74760_g("ForcedYaw") : this.initialAngle);
        this.field_70180_af.func_187227_b(STALLED, (Object)compound.func_74767_n("Stalled"));
        ListNBT vecNBT = compound.func_150295_c("CachedMotion", 6);
        if (!vecNBT.isEmpty()) {
            this.motionBeforeStall = new Vec3d(vecNBT.func_150309_d(0), vecNBT.func_150309_d(1), vecNBT.func_150309_d(2));
            if (!this.motionBeforeStall.equals((Object)Vec3d.field_186680_a)) {
                this.prevYaw = this.yaw += ContraptionEntity.yawFromVector(this.motionBeforeStall);
                this.targetYaw = this.yaw;
            }
            this.func_213317_d(Vec3d.field_186680_a);
        }
        if (compound.func_74764_b("Controller")) {
            this.controllerPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("Controller"));
        }
    }

    public void forceYaw(float forcedYaw) {
        this.yaw = this.prevYaw = forcedYaw;
        this.targetYaw = this.prevYaw;
    }

    public void checkController() {
        if (this.controllerPos == null) {
            return;
        }
        if (!this.field_70170_p.func_195588_v(this.controllerPos)) {
            return;
        }
        IControlContraption controller = this.getController();
        if (controller == null) {
            this.func_70106_y();
            return;
        }
        if (controller.isAttachedTo(this)) {
            return;
        }
        controller.attach(this);
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.contraption != null) {
            compound.func_218657_a("Contraption", (INBT)this.contraption.writeNBT());
        }
        if (!this.stationary && this.motionBeforeStall != null) {
            compound.func_218657_a("CachedMotion", (INBT)this.func_70087_a(new double[]{this.motionBeforeStall.field_72450_a, this.motionBeforeStall.field_72448_b, this.motionBeforeStall.field_72449_c}));
        }
        if (this.controllerPos != null) {
            compound.func_218657_a("Controller", (INBT)NBTUtil.func_186859_a((BlockPos)this.controllerPos));
        }
        if (this.forcedAngle != -1.0f) {
            compound.func_74776_a("ForcedYaw", this.forcedAngle);
        }
        compound.func_74776_a("InitialAngle", this.initialAngle);
        compound.func_74757_a("Stalled", this.isStalled());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        this.func_213281_b(compound);
        buffer.func_150786_a(compound);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.func_70037_a(additionalData.func_150793_b());
    }

    public void disassemble() {
        if (this.getContraption() != null) {
            BlockPos offset = new BlockPos(this.getAnchorVec().func_72441_c(0.5, 0.5, 0.5));
            Vec3d rotation = new Vec3d((double)this.getRoll(1.0f), (double)this.func_195046_g(1.0f), (double)this.func_195050_f(1.0f));
            this.getContraption().addBlocksToWorld(this.field_70170_p, offset, rotation);
            this.preventMovedEntitiesFromGettingStuck();
        }
        this.func_70106_y();
    }

    protected void func_71061_d_() {
    }

    public void preventMovedEntitiesFromGettingStuck() {
        Vec3d stuckTest = new Vec3d(0.0, -2.0, 0.0);
        for (Entity e : this.collidingEntities) {
            boolean flag3;
            e.field_70143_R = 0.0f;
            e.field_70122_E = true;
            Vec3d vec = stuckTest;
            AxisAlignedBB axisalignedbb = e.func_174813_aQ().func_72317_d(0.0, 2.0, 0.0);
            ISelectionContext iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
            VoxelShape voxelshape = e.field_70170_p.func_175723_af().func_222521_a();
            Stream<Object> stream = VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb.func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_) ? Stream.empty() : Stream.of(voxelshape);
            Stream stream1 = this.field_70170_p.func_223439_a(e, axisalignedbb.func_216361_a(vec), (Set)ImmutableSet.of());
            ReuseableStream reuseablestream = new ReuseableStream(Stream.concat(stream1, stream));
            Vec3d vec3d = vec.func_189985_c() == 0.0 ? vec : ContraptionEntity.func_223307_a((Entity)this, (Vec3d)vec, (AxisAlignedBB)axisalignedbb, (World)e.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream);
            boolean flag = vec.field_72450_a != vec3d.field_72450_a;
            boolean flag1 = vec.field_72448_b != vec3d.field_72448_b;
            boolean flag2 = vec.field_72449_c != vec3d.field_72449_c;
            boolean bl = flag3 = e.field_70122_E || flag1 && vec.field_72448_b < 0.0;
            if (this.field_70138_W > 0.0f && flag3 && (flag || flag2)) {
                Vec3d vec3d3;
                Vec3d vec3d1 = ContraptionEntity.func_223307_a((Entity)e, (Vec3d)new Vec3d(vec.field_72450_a, (double)e.field_70138_W, vec.field_72449_c), (AxisAlignedBB)axisalignedbb, (World)e.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream);
                Vec3d vec3d2 = ContraptionEntity.func_223307_a((Entity)e, (Vec3d)new Vec3d(0.0, (double)e.field_70138_W, 0.0), (AxisAlignedBB)axisalignedbb.func_72321_a(vec.field_72450_a, 0.0, vec.field_72449_c), (World)e.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream);
                if (vec3d2.field_72448_b < (double)e.field_70138_W && ContraptionEntity.func_213296_b((Vec3d)(vec3d3 = ContraptionEntity.func_223307_a((Entity)e, (Vec3d)new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c), (AxisAlignedBB)axisalignedbb.func_191194_a(vec3d2), (World)e.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream).func_178787_e(vec3d2))) > ContraptionEntity.func_213296_b((Vec3d)vec3d1)) {
                    vec3d1 = vec3d3;
                }
                if (ContraptionEntity.func_213296_b((Vec3d)vec3d1) > ContraptionEntity.func_213296_b((Vec3d)vec3d)) {
                    vec3d = vec3d1.func_178787_e(ContraptionEntity.func_223307_a((Entity)e, (Vec3d)new Vec3d(0.0, -vec3d1.field_72448_b + vec.field_72448_b, 0.0), (AxisAlignedBB)axisalignedbb.func_191194_a(vec3d1), (World)e.field_70170_p, (ISelectionContext)iselectioncontext, (ReuseableStream)reuseablestream));
                }
            }
            if ((vec = vec3d.func_178788_d(stuckTest)).equals((Object)Vec3d.field_186680_a)) continue;
            e.func_70107_b(e.field_70165_t + vec.field_72450_a, e.field_70163_u + vec.field_72448_b, e.field_70161_v + vec.field_72449_c);
        }
    }

    public Contraption getContraption() {
        return this.contraption;
    }

    public boolean isStalled() {
        return (Boolean)this.field_70180_af.func_187225_a(STALLED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (this.stationary) {
            return;
        }
        super.func_180426_a(x, y, z, yaw, pitch, posRotationIncrements, teleport);
    }

    @OnlyIn(value=Dist.CLIENT)
    static void handleStallPacket(ContraptionStallPacket packet) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(packet.entityID);
        if (!(entity instanceof ContraptionEntity)) {
            return;
        }
        ContraptionEntity ce = (ContraptionEntity)entity;
        if (ce.func_184187_bx() == null) {
            ce.field_70165_t = packet.x;
            ce.field_70163_u = packet.y;
            ce.field_70161_v = packet.z;
        }
        ce.yaw = packet.yaw;
        ce.pitch = packet.pitch;
        ce.roll = packet.roll;
    }

    public void func_213317_d(Vec3d motionIn) {
    }

    public void func_70634_a(double x, double y, double z) {
        if (!this.stationary) {
            super.func_70634_a(x, y, z);
        }
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public void setContraptionMotion(Vec3d vec) {
        super.func_213317_d(vec);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public float getInitialAngle() {
        return this.initialAngle;
    }
}

