/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions;

import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.utility.PlacementSimulationWorld;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.foundation.utility.SuperByteBufferCache;
import com.simibubi.create.foundation.utility.render.StructureRenderer;
import com.simibubi.create.modules.contraptions.components.contraptions.Contraption;
import com.simibubi.create.modules.contraptions.components.contraptions.MovementContext;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class ContraptionRenderer {
    public static final SuperByteBufferCache.Compartment<Contraption> CONTRAPTION = new SuperByteBufferCache.Compartment();
    protected static PlacementSimulationWorld renderWorld;

    public static void render(World world, Contraption c, Consumer<SuperByteBuffer> transform, BufferBuilder buffer) {
        SuperByteBuffer contraptionBuffer = CreateClient.bufferCache.get(CONTRAPTION, c, () -> ContraptionRenderer.renderContraption(c));
        transform.accept(contraptionBuffer);
        contraptionBuffer.light((lx, ly, lz) -> ContraptionRenderer.getLight(world, lx, ly, lz)).renderInto(buffer);
        ContraptionRenderer.renderActors(world, c, transform, buffer);
    }

    public static void renderTEsWithGL(World world, Contraption c, Vec3d position, Vec3d rotation) {
        StructureRenderer.renderTileEntities(world, position, rotation, c.customRenderTEs);
    }

    private static SuperByteBuffer renderContraption(Contraption c) {
        if (renderWorld == null || renderWorld.func_201672_e() != Minecraft.func_71410_x().field_71441_e) {
            renderWorld = new PlacementSimulationWorld((World)Minecraft.func_71410_x().field_71441_e);
        }
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
        Random random = new Random();
        BufferBuilder builder = new BufferBuilder(0);
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        builder.func_178969_c(0.0, 0.0, 0.0);
        for (Template.BlockInfo info : c.blocks.values()) {
            renderWorld.func_175656_a(info.field_186242_a, info.field_186243_b);
        }
        for (BlockPos pos : c.renderOrder) {
            Template.BlockInfo info = c.blocks.get(pos);
            BlockState state = info.field_186243_b;
            if (state.func_185901_i() == BlockRenderType.ENTITYBLOCK_ANIMATED) continue;
            IBakedModel originalModel = dispatcher.func_184389_a(state);
            blockRenderer.renderModel((IEnviromentBlockReader)renderWorld, originalModel, state, info.field_186242_a, builder, true, random, 42L, (IModelData)EmptyModelData.INSTANCE);
        }
        builder.func_178977_d();
        renderWorld.clear();
        return new SuperByteBuffer(builder.func_178966_f());
    }

    private static void renderActors(World world, Contraption c, Consumer<SuperByteBuffer> transform, BufferBuilder buffer) {
        for (Pair pair : c.getActors()) {
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = world;
            }
            Template.BlockInfo blockInfo = (Template.BlockInfo)pair.getLeft();
            for (SuperByteBuffer render : Contraption.getMovement(blockInfo.field_186243_b).renderListInContraption(context)) {
                if (render == null) continue;
                int posX = blockInfo.field_186242_a.func_177958_n();
                int posY = blockInfo.field_186242_a.func_177956_o();
                int posZ = blockInfo.field_186242_a.func_177952_p();
                render.translate(posX, posY, posZ);
                transform.accept(render);
                render.light((lx, ly, lz) -> ContraptionRenderer.getLight(world, lx, ly, lz)).renderInto(buffer);
            }
        }
    }

    public static int getLight(World world, float lx, float ly, float lz) {
        float offset;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float sky = 0.0f;
        float block = 0.0f;
        for (float zOffset = offset = 0.125f; zOffset >= -offset; zOffset -= 2.0f * offset) {
            for (float yOffset = offset; yOffset >= -offset; yOffset -= 2.0f * offset) {
                for (float xOffset = offset; xOffset >= -offset; xOffset -= 2.0f * offset) {
                    pos.func_189532_c((double)(lx + xOffset), (double)(ly + yOffset), (double)(lz + zOffset));
                    sky += (float)world.func_175642_b(LightType.SKY, (BlockPos)pos) / 8.0f;
                    block += (float)world.func_175642_b(LightType.BLOCK, (BlockPos)pos) / 8.0f;
                }
            }
        }
        return (int)sky << 20 | (int)block << 4;
    }
}

