/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions;

import com.simibubi.create.foundation.packet.SimplePacketBase;
import com.simibubi.create.modules.contraptions.components.contraptions.ContraptionEntity;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class ContraptionStallPacket
extends SimplePacketBase {
    int entityID;
    float x;
    float y;
    float z;
    float yaw;
    float pitch;
    float roll;

    public ContraptionStallPacket(int entityID, double posX, double posY, double posZ, float yaw, float pitch, float roll) {
        this.entityID = entityID;
        this.x = (float)posX;
        this.y = (float)posY;
        this.z = (float)posZ;
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public ContraptionStallPacket(PacketBuffer buffer) {
        this.entityID = buffer.readInt();
        this.x = buffer.readFloat();
        this.y = buffer.readFloat();
        this.z = buffer.readFloat();
        this.yaw = buffer.readFloat();
        this.pitch = buffer.readFloat();
        this.roll = buffer.readFloat();
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.entityID);
        this.writeAll(buffer, this.x, this.y, this.z, this.yaw, this.pitch, this.roll);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ContraptionEntity.handleStallPacket(this)));
        context.get().setPacketHandled(true);
    }

    private void writeAll(PacketBuffer buffer, float ... floats) {
        for (float f : floats) {
            buffer.writeFloat(f);
        }
    }
}

