/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions;

import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.components.contraptions.Contraption;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;

public class MovementContext {
    public Vec3d position;
    public Vec3d motion;
    public Vec3d relativeMotion;
    public Vec3d rotation;
    public World world;
    public BlockState state;
    public CompoundNBT tileData;
    public boolean stall;
    public boolean firstMovement;
    public CompoundNBT data;
    public Contraption contraption;
    public Object temporaryData;

    public MovementContext(World world, Template.BlockInfo info) {
        this.world = world;
        this.state = info.field_186243_b;
        this.tileData = info.field_186244_c;
        this.firstMovement = true;
        this.motion = Vec3d.field_186680_a;
        this.relativeMotion = Vec3d.field_186680_a;
        this.rotation = Vec3d.field_186680_a;
        this.position = null;
        this.data = new CompoundNBT();
        this.stall = false;
    }

    public float getAnimationSpeed() {
        int modifier = 1000;
        double length = -this.motion.func_72433_c();
        if (this.world.field_72995_K && this.contraption.stalled) {
            return 700.0f;
        }
        if (Math.abs(length) < 0.001953125) {
            return 0.0f;
        }
        return (int)(length * (double)modifier + 100.0 * Math.signum(length)) / 100 * 100;
    }

    public static MovementContext readNBT(World world, Template.BlockInfo info, CompoundNBT nbt) {
        MovementContext context = new MovementContext(world, info);
        context.motion = VecHelper.readNBT(nbt.func_150295_c("Motion", 6));
        context.relativeMotion = VecHelper.readNBT(nbt.func_150295_c("RelativeMotion", 6));
        context.rotation = VecHelper.readNBT(nbt.func_150295_c("Rotation", 6));
        if (nbt.func_74764_b("Position")) {
            context.position = VecHelper.readNBT(nbt.func_150295_c("Position", 6));
        }
        context.stall = nbt.func_74767_n("Stall");
        context.firstMovement = nbt.func_74767_n("FirstMovement");
        context.data = nbt.func_74775_l("Data");
        return context;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_218657_a("Motion", (INBT)VecHelper.writeNBT(this.motion));
        nbt.func_218657_a("RelativeMotion", (INBT)VecHelper.writeNBT(this.relativeMotion));
        nbt.func_218657_a("Rotation", (INBT)VecHelper.writeNBT(this.rotation));
        if (this.position != null) {
            nbt.func_218657_a("Position", (INBT)VecHelper.writeNBT(this.position));
        }
        nbt.func_74757_a("Stall", this.stall);
        nbt.func_74757_a("FirstMovement", this.firstMovement);
        nbt.func_218657_a("Data", (INBT)this.data);
        return nbt;
    }
}

