/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions.bearing;

import com.simibubi.create.AllBlockTags;
import com.simibubi.create.modules.contraptions.components.contraptions.AllContraptionTypes;
import com.simibubi.create.modules.contraptions.components.contraptions.Contraption;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.commons.lang3.tuple.Pair;

public class BearingContraption
extends Contraption {
    protected int sailBlocks;
    protected Direction facing;

    @Override
    protected AllContraptionTypes getType() {
        return AllContraptionTypes.BEARING;
    }

    public static BearingContraption assembleBearingAt(World world, BlockPos pos, Direction direction) {
        if (BearingContraption.isFrozen()) {
            return null;
        }
        BearingContraption construct = new BearingContraption();
        construct.facing = direction;
        BlockPos offset = pos.func_177972_a(direction);
        if (!construct.searchMovedStructure(world, offset, null)) {
            return null;
        }
        construct.initActors(world);
        construct.expandBoundsAroundAxis(direction.func_176740_k());
        return construct;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor.func_177972_a(this.facing.func_176734_d()));
    }

    @Override
    public void add(BlockPos pos, Pair<Template.BlockInfo, TileEntity> capture) {
        BlockPos localPos = pos.func_177973_b((Vec3i)this.anchor);
        if (!this.blocks.containsKey(localPos) && AllBlockTags.WINDMILL_SAILS.matches(((Template.BlockInfo)capture.getKey()).field_186243_b)) {
            ++this.sailBlocks;
        }
        super.add(pos, capture);
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT tag = super.writeNBT();
        tag.func_74768_a("Sails", this.sailBlocks);
        tag.func_74768_a("facing", this.facing.func_176745_a());
        return tag;
    }

    @Override
    public void readNBT(World world, CompoundNBT tag) {
        this.sailBlocks = tag.func_74762_e("Sails");
        this.facing = Direction.func_82600_a((int)tag.func_74762_e("Facing"));
        super.readNBT(world, tag);
    }

    public int getSailBlocks() {
        return this.sailBlocks;
    }

    public Direction getFacing() {
        return this.facing;
    }
}

