/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions.bearing;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.components.contraptions.Contraption;
import com.simibubi.create.modules.contraptions.components.contraptions.ContraptionEntity;
import com.simibubi.create.modules.contraptions.components.contraptions.bearing.ClockworkBearingBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.bearing.ClockworkContraption;
import com.simibubi.create.modules.contraptions.components.contraptions.bearing.IBearingTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.Pair;

public class ClockworkBearingTileEntity
extends KineticTileEntity
implements IBearingTileEntity {
    protected ContraptionEntity hourHand;
    protected ContraptionEntity minuteHand;
    protected float hourAngle;
    protected float minuteAngle;
    protected float clientHourAngleDiff;
    protected float clientMinuteAngleDiff;
    protected boolean running;
    protected boolean assembleNextTick;

    public ClockworkBearingTileEntity() {
        super(AllTileEntities.CLOCKWORK_BEARING.type);
        this.setLazyTickRate(3);
    }

    @Override
    public void func_73660_a() {
        float newAngle;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.clientMinuteAngleDiff /= 2.0f;
            this.clientHourAngleDiff /= 2.0f;
        }
        if (this.running && Contraption.isFrozen()) {
            this.disassemble();
        }
        if (!this.field_145850_b.field_72995_K && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (this.running) {
                boolean canDisassemble = true;
                if (this.speed == 0.0f && (canDisassemble || this.hourHand == null || this.hourHand.getContraption().blocks.isEmpty())) {
                    if (this.hourHand != null) {
                        this.hourHand.getContraption().stop(this.field_145850_b);
                    }
                    if (this.minuteHand != null) {
                        this.minuteHand.getContraption().stop(this.field_145850_b);
                    }
                    this.disassemble();
                }
                return;
            }
            this.assemble();
            return;
        }
        if (!this.running) {
            return;
        }
        if (this.hourHand == null || !this.hourHand.isStalled()) {
            newAngle = this.hourAngle + this.getHourArmSpeed();
            this.hourAngle = newAngle % 360.0f;
        }
        if (this.minuteHand == null || !this.minuteHand.isStalled()) {
            newAngle = this.minuteAngle + this.getMinuteArmSpeed();
            this.minuteAngle = newAngle % 360.0f;
        }
        this.applyRotations();
    }

    protected void applyRotations() {
        Vec3d vec;
        Direction.Axis axis = ((Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k();
        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        Vec3d directionVec = new Vec3d(direction.func_176730_m());
        if (this.hourHand != null) {
            vec = new Vec3d(1.0, 1.0, 1.0).func_186678_a((double)this.hourAngle).func_216369_h(directionVec);
            this.hourHand.rotateTo(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }
        if (this.minuteHand != null) {
            vec = new Vec3d(1.0, 1.0, 1.0).func_186678_a((double)this.minuteAngle).func_216369_h(directionVec);
            this.minuteHand.rotateTo(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.hourHand != null && !this.field_145850_b.field_72995_K) {
            this.sendData();
        }
    }

    public float getHourArmSpeed() {
        float speed = this.getAngularSpeed() / 2.0f;
        if (speed != 0.0f) {
            int dayTime = (int)(this.field_145850_b.func_72820_D() % 24000L);
            int hours = (dayTime / 1000 + 6) % 24;
            int offset = ((Direction)this.func_195044_w().func_177229_b((IProperty)ClockworkBearingBlock.FACING)).func_176743_c().func_179524_a();
            float hourTarget = (float)(offset * -360) / 12.0f * (float)(hours % 12);
            float shortestAngleDiff = AngleHelper.getShortestAngleDiff(this.hourAngle, hourTarget);
            speed = shortestAngleDiff < 0.0f ? Math.max(speed, shortestAngleDiff) : Math.min(-speed, shortestAngleDiff);
        }
        return speed + this.clientHourAngleDiff / 3.0f;
    }

    public float getMinuteArmSpeed() {
        float speed = this.getAngularSpeed();
        if (speed != 0.0f) {
            int dayTime = (int)(this.field_145850_b.func_72820_D() % 24000L);
            int minutes = dayTime % 1000 * 60 / 1000;
            int offset = ((Direction)this.func_195044_w().func_177229_b((IProperty)ClockworkBearingBlock.FACING)).func_176743_c().func_179524_a();
            float minuteTarget = (float)(offset * -360) / 60.0f * (float)minutes;
            float shortestAngleDiff = AngleHelper.getShortestAngleDiff(this.minuteAngle, minuteTarget);
            speed = shortestAngleDiff < 0.0f ? Math.max(speed, shortestAngleDiff) : Math.min(-speed, shortestAngleDiff);
        }
        return speed + this.clientMinuteAngleDiff / 3.0f;
    }

    public float getAngularSpeed() {
        float speed = -Math.abs(this.getSpeed() * 3.0f / 10.0f);
        if (this.field_145850_b.field_72995_K) {
            speed *= ServerSpeedProvider.get();
        }
        return speed;
    }

    public void assemble() {
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof ClockworkBearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        Pair<ClockworkContraption, ClockworkContraption> contraption = ClockworkContraption.assembleClockworkAt(this.field_145850_b, this.field_174879_c, direction);
        if (contraption == null) {
            return;
        }
        if (contraption.getLeft() == null) {
            return;
        }
        if (((ClockworkContraption)contraption.getLeft()).blocks.isEmpty()) {
            return;
        }
        BlockPos anchor = this.field_174879_c.func_177972_a(direction);
        ((ClockworkContraption)contraption.getLeft()).removeBlocksFromWorld((IWorld)this.field_145850_b, BlockPos.field_177992_a);
        this.hourHand = ContraptionEntity.createStationary(this.field_145850_b, (Contraption)contraption.getLeft()).controlledBy(this);
        this.hourHand.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
        this.field_145850_b.func_217376_c((Entity)this.hourHand);
        if (contraption.getRight() != null) {
            anchor = this.field_174879_c.func_177967_a(direction, ((ClockworkContraption)contraption.getRight()).offset + 1);
            ((ClockworkContraption)contraption.getRight()).removeBlocksFromWorld((IWorld)this.field_145850_b, BlockPos.field_177992_a);
            this.minuteHand = ContraptionEntity.createStationary(this.field_145850_b, (Contraption)contraption.getRight()).controlledBy(this);
            this.minuteHand.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
            this.field_145850_b.func_217376_c((Entity)this.minuteHand);
        }
        this.running = true;
        this.hourAngle = 0.0f;
        this.minuteAngle = 0.0f;
        this.sendData();
    }

    public void disassemble() {
        if (!this.running && this.hourHand == null && this.minuteHand == null) {
            return;
        }
        this.hourAngle = 0.0f;
        this.minuteAngle = 0.0f;
        this.applyRotations();
        if (this.hourHand != null) {
            this.hourHand.disassemble();
        }
        if (this.minuteHand != null) {
            this.minuteHand.disassemble();
        }
        this.hourHand = null;
        this.minuteHand = null;
        this.running = false;
        this.sendData();
    }

    @Override
    public void attach(ContraptionEntity contraption) {
        if (!(contraption.getContraption() instanceof ClockworkContraption)) {
            return;
        }
        ClockworkContraption cc = (ClockworkContraption)contraption.getContraption();
        this.func_70296_d();
        Direction facing = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        BlockPos anchor = this.field_174879_c.func_177967_a(facing, cc.offset + 1);
        if (cc.handType == ClockworkContraption.HandType.HOUR) {
            this.hourHand = contraption;
            this.hourHand.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
        } else {
            this.minuteHand = contraption;
            this.minuteHand.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
        }
        if (!this.field_145850_b.field_72995_K) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74757_a("Running", this.running);
        tag.func_74776_a("HourAngle", this.hourAngle);
        tag.func_74776_a("MinuteAngle", this.minuteAngle);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.running = tag.func_74767_n("Running");
        this.hourAngle = tag.func_74760_g("HourAngle");
        this.minuteAngle = tag.func_74760_g("MinuteAngle");
        super.func_145839_a(tag);
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        float hourAngleBefore = this.hourAngle;
        float minuteAngleBefore = this.minuteAngle;
        super.readClientUpdate(tag);
        if (this.running) {
            this.clientHourAngleDiff = AngleHelper.getShortestAngleDiff(hourAngleBefore, this.hourAngle);
            this.clientMinuteAngleDiff = AngleHelper.getShortestAngleDiff(minuteAngleBefore, this.minuteAngle);
            this.hourAngle = hourAngleBefore;
            this.minuteAngle = minuteAngleBefore;
        } else {
            this.hourHand = null;
            this.minuteHand = null;
        }
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.assembleNextTick = true;
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public float getInterpolatedAngle(float partialTicks) {
        if (this.hourHand == null || this.hourHand.isStalled()) {
            partialTicks = 0.0f;
        }
        return MathHelper.func_219799_g((float)partialTicks, (float)this.hourAngle, (float)(this.hourAngle + this.getHourArmSpeed()));
    }

    @Override
    public void onStall() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendData();
        }
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.disassemble();
        }
        super.func_145843_s();
    }

    @Override
    public void collided() {
    }

    @Override
    public boolean isAttachedTo(ContraptionEntity contraption) {
        if (!(contraption.getContraption() instanceof ClockworkContraption)) {
            return false;
        }
        ClockworkContraption cc = (ClockworkContraption)contraption.getContraption();
        if (cc.handType == ClockworkContraption.HandType.HOUR) {
            return this.hourHand == contraption;
        }
        return this.minuteHand == contraption;
    }

    public boolean isRunning() {
        return this.running;
    }
}

