/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions.chassis;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.IHaveConnectedTextures;
import com.simibubi.create.modules.contraptions.components.contraptions.chassis.AbstractChassisBlock;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;

public class LinearChassisBlock
extends AbstractChassisBlock
implements IHaveConnectedTextures {
    public static final BooleanProperty STICKY_TOP = BooleanProperty.func_177716_a((String)"sticky_top");
    public static final BooleanProperty STICKY_BOTTOM = BooleanProperty.func_177716_a((String)"sticky_bottom");

    public LinearChassisBlock() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150331_J));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)STICKY_TOP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)STICKY_BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STICKY_TOP, STICKY_BOTTOM});
        super.func_206840_a(builder);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos placedOnPos = context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d());
        BlockState blockState = context.func_195991_k().func_180495_p(placedOnPos);
        if (LinearChassisBlock.isChassis(blockState) && !context.func_195998_g()) {
            return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_176298_M, blockState.func_177229_b((IProperty)field_176298_M));
        }
        if (!context.func_195998_g()) {
            return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_176298_M, (Comparable)context.func_196010_d().func_176740_k());
        }
        return super.func_196258_a(context);
    }

    @Override
    public BooleanProperty getGlueableSide(BlockState state, Direction face) {
        if (face.func_176740_k() != state.func_177229_b((IProperty)field_176298_M)) {
            return null;
        }
        return face.func_176743_c() == Direction.AxisDirection.POSITIVE ? STICKY_TOP : STICKY_BOTTOM;
    }

    public String func_149739_a() {
        Block block = AllBlocks.TRANSLATION_CHASSIS.get();
        if (this == block) {
            return super.func_149739_a();
        }
        return block.func_149739_a();
    }

    public static boolean isChassis(BlockState state) {
        return AllBlocks.TRANSLATION_CHASSIS.typeOf(state) || AllBlocks.TRANSLATION_CHASSIS_SECONDARY.typeOf(state);
    }

    public static boolean sameKind(BlockState state1, BlockState state2) {
        return state1.func_177230_c() == state2.func_177230_c();
    }

    @Override
    public ConnectedTextureBehaviour getBehaviour() {
        return new ChassisCTBehaviour();
    }

    private static class ChassisCTBehaviour
    extends ConnectedTextureBehaviour {
        static final CTSpriteShiftEntry regular = CTSpriteShifter.get(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "translation_chassis_top");
        static final CTSpriteShiftEntry sticky = CTSpriteShifter.get(CTSpriteShifter.CTType.OMNIDIRECTIONAL, "translation_chassis_top_sticky");

        private ChassisCTBehaviour() {
        }

        @Override
        public CTSpriteShiftEntry get(BlockState state, Direction direction) {
            Block block = state.func_177230_c();
            BooleanProperty glueableSide = ((LinearChassisBlock)block).getGlueableSide(state, direction);
            if (glueableSide == null) {
                return null;
            }
            return (Boolean)state.func_177229_b((IProperty)glueableSide) != false ? sticky : regular;
        }

        @Override
        public Iterable<CTSpriteShiftEntry> getAllCTShifts() {
            return Arrays.asList(regular, sticky);
        }

        @Override
        public boolean reverseUVs(BlockState state, Direction face) {
            if (((Direction.Axis)state.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)).func_176722_c() && face.func_176743_c() == Direction.AxisDirection.POSITIVE) {
                return true;
            }
            return super.reverseUVs(state, face);
        }

        @Override
        public boolean connectsTo(BlockState state, BlockState other, IEnviromentBlockReader reader, BlockPos pos, BlockPos otherPos, Direction face) {
            return LinearChassisBlock.sameKind(state, other) && state.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M) == other.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M);
        }
    }
}

