/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions.glue;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllItems;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.components.contraptions.glue.SuperGlueEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.PositionTextureVertex;
import net.minecraft.client.renderer.model.TexturedQuad;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SuperGlueRenderer
extends EntityRenderer<SuperGlueEntity> {
    private ResourceLocation regular = new ResourceLocation("create", "textures/entity/super_glue/slime.png");
    private ResourceLocation ghostly = new ResourceLocation("create", "textures/entity/super_glue/ghostly.png");
    private TexturedQuad quad1;
    private TexturedQuad quad2;

    public SuperGlueRenderer(EntityRendererManager renderManager) {
        super(renderManager);
        this.initQuads();
    }

    protected ResourceLocation getEntityTexture(SuperGlueEntity entity) {
        return this.isVisible(entity) ? this.regular : this.ghostly;
    }

    public void doRender(SuperGlueEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        Direction facing = entity.getFacingDirection();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        boolean visible = this.isVisible(entity);
        boolean holdingGlue = AllItems.SUPER_GLUE.typeOf(player.func_184614_ca()) || AllItems.SUPER_GLUE.typeOf(player.func_184592_cb());
        boolean bl = holdingGlue = holdingGlue && (Boolean)AllConfigs.CLIENT.showHiddenSuperGlue.get() != false;
        if (!visible && !holdingGlue) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.rotated((double)AngleHelper.horizontalAngle(facing), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)AngleHelper.verticalAngle(facing), (double)1.0, (double)0.0, (double)0.0);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        this.func_180548_c(entity);
        if (!visible) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.375f);
            GlStateManager.enableBlend();
            GlStateManager.disableDepthTest();
        }
        this.quad1.func_178765_a(buffer, 1.0f);
        this.quad2.func_178765_a(buffer, 1.0f);
        GlStateManager.disableBlend();
        GlStateManager.enableDepthTest();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    private boolean isVisible(SuperGlueEntity entity) {
        if (!entity.func_70089_S()) {
            return false;
        }
        BlockPos pos = entity.hangingPosition;
        BlockPos pos2 = pos.func_177972_a(entity.getFacingDirection().func_176734_d());
        return entity.field_70170_p.func_175623_d(pos) != entity.field_70170_p.func_175623_d(pos2);
    }

    private void initQuads() {
        Vec3d diff = new Vec3d(Direction.SOUTH.func_176730_m());
        Vec3d extension = diff.func_72432_b().func_186678_a(0.0234375);
        Vec3d plane = VecHelper.planeByNormal(diff);
        Direction.Axis axis = Direction.func_210769_a((double)diff.field_72450_a, (double)diff.field_72448_b, (double)diff.field_72449_c).func_176740_k();
        Vec3d start = Vec3d.field_186680_a.func_178788_d(extension);
        Vec3d end = Vec3d.field_186680_a.func_178787_e(extension);
        plane = plane.func_186678_a(0.5);
        Vec3d a1 = plane.func_178787_e(start);
        Vec3d b1 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3d a2 = plane.func_178787_e(start);
        Vec3d b2 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3d a3 = plane.func_178787_e(start);
        Vec3d b3 = plane.func_178787_e(end);
        plane = VecHelper.rotate(plane, -90.0, axis);
        Vec3d a4 = plane.func_178787_e(start);
        Vec3d b4 = plane.func_178787_e(end);
        PositionTextureVertex v11 = new PositionTextureVertex(a1, 1.0f, 0.0f);
        PositionTextureVertex v12 = new PositionTextureVertex(a2, 1.0f, 1.0f);
        PositionTextureVertex v13 = new PositionTextureVertex(a3, 0.0f, 1.0f);
        PositionTextureVertex v14 = new PositionTextureVertex(a4, 0.0f, 0.0f);
        PositionTextureVertex v21 = new PositionTextureVertex(b1, 1.0f, 0.0f);
        PositionTextureVertex v22 = new PositionTextureVertex(b2, 1.0f, 1.0f);
        PositionTextureVertex v23 = new PositionTextureVertex(b3, 0.0f, 1.0f);
        PositionTextureVertex v24 = new PositionTextureVertex(b4, 0.0f, 0.0f);
        this.quad1 = new TexturedQuad(new PositionTextureVertex[]{v14, v11, v12, v13}, 0, 0, 16, 16, 16.0f, 16.0f);
        this.quad2 = new TexturedQuad(new PositionTextureVertex[]{v21, v24, v23, v22}, 0, 0, 16, 16, 16.0f, 16.0f);
    }
}

