/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions.mounted;

import com.simibubi.create.AllItems;
import com.simibubi.create.modules.contraptions.components.contraptions.Contraption;
import com.simibubi.create.modules.contraptions.components.contraptions.ContraptionEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MinecartContraptionItem
extends Item {
    private final AbstractMinecartEntity.Type minecartType;
    private static final IDispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
            World world = source.func_197524_h();
            double d0 = source.func_82615_a() + (double)direction.func_82601_c() * 1.125;
            double d1 = Math.floor(source.func_82617_b()) + (double)direction.func_96559_d();
            double d2 = source.func_82616_c() + (double)direction.func_82599_e() * 1.125;
            BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
            BlockState blockstate = world.func_180495_p(blockpos);
            RailShape railShape = railshape = blockstate.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)world, blockpos, null) : RailShape.NORTH_SOUTH;
            if (blockstate.func_203425_a(BlockTags.field_203437_y)) {
                d3 = railshape.func_208092_c() ? 0.6 : 0.1;
            } else {
                if (!blockstate.isAir((IBlockReader)world, blockpos) || !world.func_180495_p(blockpos.func_177977_b()).func_203425_a(BlockTags.field_203437_y)) {
                    return this.behaviourDefaultDispenseItem.dispense(source, stack);
                }
                BlockState blockstate1 = world.func_180495_p(blockpos.func_177977_b());
                RailShape railshape1 = blockstate1.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate1.func_177230_c()).getRailDirection(blockstate1, (IBlockReader)world, blockpos.func_177977_b(), null) : RailShape.NORTH_SOUTH;
                d3 = direction != Direction.DOWN && railshape1.func_208092_c() ? -0.4 : -0.9;
            }
            AbstractMinecartEntity abstractminecartentity = AbstractMinecartEntity.func_184263_a((World)world, (double)d0, (double)(d1 + d3), (double)d2, (AbstractMinecartEntity.Type)((MinecartContraptionItem)stack.func_77973_b()).minecartType);
            if (stack.func_82837_s()) {
                abstractminecartentity.func_200203_b(stack.func_200301_q());
            }
            world.func_217376_c((Entity)abstractminecartentity);
            MinecartContraptionItem.addContraptionToMinecart(world, stack, abstractminecartentity, direction);
            stack.func_190918_g(1);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_197524_h().func_217379_c(1000, source.func_180699_d(), 0);
        }
    };

    public MinecartContraptionItem(AbstractMinecartEntity.Type minecartTypeIn, Item.Properties builder) {
        super(builder);
        this.minecartType = minecartTypeIn;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = context.func_195995_a());
        if (!blockstate.func_203425_a(BlockTags.field_203437_y)) {
            return ActionResultType.FAIL;
        }
        ItemStack itemstack = context.func_195996_i();
        if (!world.field_72995_K) {
            RailShape railshape = blockstate.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)world, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.func_208092_c()) {
                d0 = 0.5;
            }
            AbstractMinecartEntity abstractminecartentity = AbstractMinecartEntity.func_184263_a((World)world, (double)((double)blockpos.func_177958_n() + 0.5), (double)((double)blockpos.func_177956_o() + 0.0625 + d0), (double)((double)blockpos.func_177952_p() + 0.5), (AbstractMinecartEntity.Type)this.minecartType);
            if (itemstack.func_82837_s()) {
                abstractminecartentity.func_200203_b(itemstack.func_200301_q());
            }
            PlayerEntity player = context.func_195999_j();
            world.func_217376_c((Entity)abstractminecartentity);
            MinecartContraptionItem.addContraptionToMinecart(world, itemstack, abstractminecartentity, player == null ? null : player.func_174811_aO());
        }
        itemstack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    public static void addContraptionToMinecart(World world, ItemStack itemstack, AbstractMinecartEntity abstractminecartentity, @Nullable Direction newFacing) {
        CompoundNBT tag = itemstack.func_196082_o();
        if (tag.func_74764_b("Contraption")) {
            CompoundNBT contraptionTag = tag.func_74775_l("Contraption");
            float initialAngle = contraptionTag.func_74760_g("InitialAngle");
            Contraption mountedContraption = Contraption.fromNBT(world, contraptionTag);
            ContraptionEntity contraption = newFacing != null ? ContraptionEntity.createMounted(world, mountedContraption, initialAngle, newFacing) : ContraptionEntity.createMounted(world, mountedContraption, initialAngle);
            contraption.func_184220_m((Entity)abstractminecartentity);
            contraption.func_70107_b(abstractminecartentity.field_70165_t, abstractminecartentity.field_70163_u, abstractminecartentity.field_70161_v);
            world.func_217376_c((Entity)contraption);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return "item.create.minecart_contraption";
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    @SubscribeEvent
    public static void wrenchCanBeUsedToPickUpMinecartContraptions(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        PlayerEntity player = event.getPlayer();
        if (player == null || entity == null) {
            return;
        }
        ItemStack wrench = player.func_184586_b(event.getHand());
        if (!AllItems.WRENCH.typeOf(wrench)) {
            return;
        }
        if (entity instanceof ContraptionEntity) {
            entity = entity.func_184187_bx();
        }
        if (!(entity instanceof AbstractMinecartEntity)) {
            return;
        }
        AbstractMinecartEntity cart = (AbstractMinecartEntity)entity;
        AbstractMinecartEntity.Type type = cart.func_184264_v();
        if (type != AbstractMinecartEntity.Type.RIDEABLE && type != AbstractMinecartEntity.Type.FURNACE) {
            return;
        }
        List passengers = cart.func_184188_bt();
        if (passengers.isEmpty() || !(passengers.get(0) instanceof ContraptionEntity)) {
            return;
        }
        ContraptionEntity contraption = (ContraptionEntity)((Object)passengers.get(0));
        if (!event.getWorld().field_72995_K) {
            player.field_71071_by.func_191975_a(event.getWorld(), MinecartContraptionItem.create(type, contraption));
            contraption.func_70106_y();
            entity.func_70106_y();
        }
        event.setCancellationResult(ActionResultType.SUCCESS);
        event.setCanceled(true);
    }

    public static ItemStack create(AbstractMinecartEntity.Type type, ContraptionEntity entity) {
        ItemStack stack = (type == AbstractMinecartEntity.Type.RIDEABLE ? AllItems.MINECART_CONTRAPTION : AllItems.FURNACE_MINECART_CONTRAPTION).asStack();
        CompoundNBT tag = entity.getContraption().writeNBT();
        tag.func_82580_o("UUID");
        tag.func_82580_o("Pos");
        tag.func_82580_o("Motion");
        tag.func_74776_a("InitialAngle", entity.getInitialAngle());
        stack.func_196082_o().func_218657_a("Contraption", (INBT)tag);
        return stack;
    }
}

