/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions.piston;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.components.contraptions.AllContraptionTypes;
import com.simibubi.create.modules.contraptions.components.contraptions.BlockMovementTraits;
import com.simibubi.create.modules.contraptions.components.contraptions.Contraption;
import com.simibubi.create.modules.contraptions.components.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.modules.contraptions.components.contraptions.piston.MechanicalPistonBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.CarpetBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.commons.lang3.tuple.Pair;

public class PistonContraption
extends Contraption {
    protected AxisAlignedBB pistonExtensionCollisionBox;
    protected int extensionLength;
    protected int initialExtensionProgress;
    protected Direction orientation;

    @Override
    protected AllContraptionTypes getType() {
        return AllContraptionTypes.PISTON;
    }

    public static PistonContraption movePistonAt(World world, BlockPos pos, Direction direction, boolean retract) {
        if (PistonContraption.isFrozen()) {
            return null;
        }
        PistonContraption construct = new PistonContraption();
        construct.orientation = direction;
        if (!construct.collectExtensions(world, pos, direction)) {
            return null;
        }
        if (!construct.searchMovedStructure(world, construct.anchor, retract ? direction.func_176734_d() : direction)) {
            return null;
        }
        construct.initActors(world);
        return construct;
    }

    private boolean collectExtensions(World world, BlockPos pos, Direction direction) {
        ArrayList<Template.BlockInfo> poles = new ArrayList<Template.BlockInfo>();
        BlockPos actualStart = pos;
        BlockState nextBlock = world.func_180495_p(actualStart.func_177972_a(direction));
        int extensionsInFront = 0;
        BlockState blockState = world.func_180495_p(pos);
        boolean sticky = AllBlocks.STICKY_MECHANICAL_PISTON.typeOf(blockState);
        if (!(blockState.func_177230_c() instanceof MechanicalPistonBlock)) {
            return false;
        }
        if (blockState.func_177229_b(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
            while (AllBlocks.PISTON_POLE.typeOf(nextBlock) && ((Direction)nextBlock.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k() == direction.func_176740_k() || AllBlocks.MECHANICAL_PISTON_HEAD.typeOf(nextBlock) && nextBlock.func_177229_b((IProperty)BlockStateProperties.field_208155_H) == direction) {
                actualStart = actualStart.func_177972_a(direction);
                poles.add(new Template.BlockInfo(actualStart, (BlockState)nextBlock.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)direction), null));
                ++extensionsInFront;
                if (AllBlocks.MECHANICAL_PISTON_HEAD.typeOf(nextBlock)) break;
                nextBlock = world.func_180495_p(actualStart.func_177972_a(direction));
                if (extensionsInFront <= MechanicalPistonBlock.maxAllowedPistonPoles()) continue;
                return false;
            }
        }
        if (extensionsInFront == 0) {
            poles.add(new Template.BlockInfo(pos, (BlockState)((BlockState)AllBlocks.MECHANICAL_PISTON_HEAD.get().func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)direction)).func_206870_a((IProperty)BlockStateProperties.field_208144_as, (Comparable)(sticky ? PistonType.STICKY : PistonType.DEFAULT)), null));
        } else {
            poles.add(new Template.BlockInfo(pos, (BlockState)AllBlocks.PISTON_POLE.get().func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)direction), null));
        }
        BlockPos end = pos;
        nextBlock = world.func_180495_p(end.func_177972_a(direction.func_176734_d()));
        int extensionsInBack = 0;
        while (AllBlocks.PISTON_POLE.typeOf(nextBlock)) {
            end = end.func_177972_a(direction.func_176734_d());
            poles.add(new Template.BlockInfo(end, (BlockState)nextBlock.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)direction), null));
            nextBlock = world.func_180495_p(end.func_177972_a(direction.func_176734_d()));
            if (extensionsInFront + ++extensionsInBack <= MechanicalPistonBlock.maxAllowedPistonPoles()) continue;
            return false;
        }
        this.anchor = pos.func_177967_a(direction, this.initialExtensionProgress + 1);
        this.extensionLength = extensionsInBack + extensionsInFront;
        this.initialExtensionProgress = extensionsInFront;
        this.pistonExtensionCollisionBox = new AxisAlignedBB(end.func_177967_a(direction, -extensionsInFront).func_177973_b((Vec3i)this.anchor));
        if (this.extensionLength == 0) {
            return false;
        }
        this.bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (Template.BlockInfo pole : poles) {
            BlockPos relPos = pole.field_186242_a.func_177967_a(direction, -extensionsInFront);
            BlockPos localPos = relPos.func_177973_b((Vec3i)this.anchor);
            this.blocks.put(localPos, new Template.BlockInfo(localPos, pole.field_186243_b, null));
            this.pistonExtensionCollisionBox = this.pistonExtensionCollisionBox.func_111270_a(new AxisAlignedBB(localPos));
        }
        return true;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return this.pistonExtensionCollisionBox.func_72318_a(VecHelper.getCenterOf((Vec3i)pos.func_177973_b((Vec3i)this.anchor)));
    }

    @Override
    protected boolean addToInitialFrontier(World world, BlockPos pos, Direction direction, List<BlockPos> frontier) {
        boolean retracting;
        frontier.clear();
        boolean sticky = AllBlocks.STICKY_MECHANICAL_PISTON.typeOf(world.func_180495_p(pos.func_177967_a(this.orientation, -1)));
        boolean bl = retracting = direction != this.orientation;
        if (retracting && !sticky) {
            return true;
        }
        for (int offset = 0; offset <= (Integer)AllConfigs.SERVER.kinetics.maxChassisRange.get(); ++offset) {
            if (offset == 1 && retracting) {
                return true;
            }
            BlockPos currentPos = pos.func_177967_a(this.orientation, offset + this.initialExtensionProgress);
            if (!world.func_195588_v(currentPos)) {
                return false;
            }
            if (!BlockMovementTraits.movementNecessary(world, currentPos)) {
                return true;
            }
            BlockState state = world.func_180495_p(currentPos);
            if (BlockMovementTraits.isBrittle(state) && !(state.func_177230_c() instanceof CarpetBlock)) {
                return true;
            }
            if (AllBlocks.MECHANICAL_PISTON_HEAD.typeOf(state) && state.func_177229_b((IProperty)BlockStateProperties.field_208155_H) == direction.func_176734_d()) {
                return true;
            }
            if (!BlockMovementTraits.movementAllowed(world, currentPos)) {
                return retracting;
            }
            frontier.add(currentPos);
            if (!BlockMovementTraits.notSupportive(state, this.orientation)) continue;
            return true;
        }
        return true;
    }

    @Override
    public void add(BlockPos pos, Pair<Template.BlockInfo, TileEntity> capture) {
        super.add(pos.func_177967_a(this.orientation, -this.initialExtensionProgress), capture);
    }

    @Override
    public void addGlue(SuperGlueEntity entity) {
        BlockPos pos = entity.getHangingPosition();
        Direction direction = entity.getFacingDirection();
        BlockPos localPos = pos.func_177973_b((Vec3i)this.anchor).func_177967_a(this.orientation, -this.initialExtensionProgress);
        this.superglue.add(Pair.of((Object)localPos, (Object)direction));
        this.glueToRemove.add(entity);
    }

    @Override
    public void addBlocksToWorld(World world, BlockPos offset, Vec3d rotation) {
        super.addBlocksToWorld(world, offset, rotation, (pos, state) -> {
            BlockPos pistonPos = this.anchor.func_177967_a(this.orientation, -1);
            BlockState pistonState = world.func_180495_p(pistonPos);
            TileEntity te = world.func_175625_s(pistonPos);
            if (pos.equals((Object)pistonPos)) {
                if (te == null || te.func_145837_r()) {
                    return true;
                }
                if (!AllBlocks.PISTON_POLE.typeOf((BlockState)state) && pistonState.func_177230_c() instanceof MechanicalPistonBlock) {
                    world.func_180501_a(pistonPos, (BlockState)pistonState.func_206870_a(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.RETRACTED)), 19);
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public void removeBlocksFromWorld(IWorld world, BlockPos offset) {
        super.removeBlocksFromWorld(world, offset, (pos, state) -> {
            BlockPos pistonPos = this.anchor.func_177967_a(this.orientation, -1);
            BlockState blockState = world.func_180495_p(pos);
            if (pos.equals((Object)pistonPos) && blockState.func_177230_c() instanceof MechanicalPistonBlock) {
                world.func_180501_a(pos, (BlockState)blockState.func_206870_a(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.MOVING)), 82);
                return true;
            }
            return false;
        });
    }

    @Override
    public void readNBT(World world, CompoundNBT nbt) {
        super.readNBT(world, nbt);
        this.extensionLength = nbt.func_74762_e("ExtensionLength");
        this.initialExtensionProgress = nbt.func_74762_e("InitialLength");
        this.orientation = Direction.func_82600_a((int)nbt.func_74762_e("Orientation"));
        if (nbt.func_74764_b("BoundsBack")) {
            this.pistonExtensionCollisionBox = NBTHelper.readAABB(nbt.func_150295_c("BoundsBack", 5));
        }
    }

    @Override
    public CompoundNBT writeNBT() {
        CompoundNBT nbt = super.writeNBT();
        if (this.pistonExtensionCollisionBox != null) {
            ListNBT bb = NBTHelper.writeAABB(this.pistonExtensionCollisionBox);
            nbt.func_218657_a("BoundsBack", (INBT)bb);
        }
        nbt.func_74768_a("InitialLength", this.initialExtensionProgress);
        nbt.func_74768_a("ExtensionLength", this.extensionLength);
        nbt.func_74768_a("Orientation", this.orientation.func_176745_a());
        return nbt;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return super.getBoundingBox().func_111270_a(this.pistonExtensionCollisionBox);
    }
}

