/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions.pulley;

import com.simibubi.create.foundation.block.IHaveNoBlockItem;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.AllShapes;
import com.simibubi.create.modules.contraptions.base.HorizontalAxisKineticBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.pulley.PulleyTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PulleyBlock
extends HorizontalAxisKineticBlock
implements ITE<PulleyTileEntity> {
    public static EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.field_208199_z;

    public PulleyBlock() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_196656_g));
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PulleyTileEntity();
    }

    @Override
    protected boolean hasStaticPart() {
        return true;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            BlockState below;
            if (!worldIn.field_72995_K && (below = worldIn.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof RopeBlockBase) {
                worldIn.func_175655_b(pos.func_177977_b(), true);
            }
            worldIn.func_175713_t(pos);
        }
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_175142_cm()) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (player.func_184586_b(handIn).func_190926_b()) {
            this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
                te.assembleNextTick = true;
            });
            return true;
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.PULLEY.get((Direction.Axis)state.func_177229_b(HORIZONTAL_AXIS));
    }

    private static void onRopeBroken(World world, BlockPos pulleyPos) {
        TileEntity te = world.func_175625_s(pulleyPos);
        if (!(te instanceof PulleyTileEntity)) {
            return;
        }
        PulleyTileEntity pulley = (PulleyTileEntity)te;
        pulley.offset = 0.0f;
        pulley.sendData();
    }

    @Override
    public Class<PulleyTileEntity> getTileEntityClass() {
        return PulleyTileEntity.class;
    }

    public static class RopeBlock
    extends RopeBlockBase {
        public RopeBlock() {
            super(Block.Properties.func_200950_a((Block)Blocks.field_196556_aL));
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
            return AllShapes.FOUR_VOXEL_POLE.get(Direction.UP);
        }
    }

    public static class MagnetBlock
    extends RopeBlockBase {
        public MagnetBlock() {
            super(Block.Properties.func_200950_a((Block)Blocks.field_196656_g));
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
            return AllShapes.PULLEY_MAGNET;
        }
    }

    private static class RopeBlockBase
    extends Block
    implements IHaveNoBlockItem {
        public RopeBlockBase(Block.Properties properties) {
            super(properties);
        }

        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.BLOCK;
        }

        public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
            if (!isMoving) {
                PulleyBlock.onRopeBroken(worldIn, pos.func_177984_a());
                if (!worldIn.field_72995_K) {
                    BlockState above = worldIn.func_180495_p(pos.func_177984_a());
                    BlockState below = worldIn.func_180495_p(pos.func_177977_b());
                    if (above.func_177230_c() instanceof RopeBlockBase) {
                        worldIn.func_175655_b(pos.func_177984_a(), true);
                    }
                    if (below.func_177230_c() instanceof RopeBlockBase) {
                        worldIn.func_175655_b(pos.func_177977_b(), true);
                    }
                }
            }
            if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
                worldIn.func_175713_t(pos);
            }
        }
    }
}

