/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.contraptions.pulley;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.behaviour.ValueBoxTransform;
import com.simibubi.create.modules.contraptions.components.contraptions.BlockMovementTraits;
import com.simibubi.create.modules.contraptions.components.contraptions.ContraptionCollider;
import com.simibubi.create.modules.contraptions.components.contraptions.ContraptionEntity;
import com.simibubi.create.modules.contraptions.components.contraptions.piston.LinearActuatorTileEntity;
import com.simibubi.create.modules.contraptions.components.contraptions.pulley.PulleyBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.pulley.PulleyContraption;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class PulleyTileEntity
extends LinearActuatorTileEntity {
    protected int initialOffset;

    public PulleyTileEntity() {
        super(AllTileEntities.ROPE_PULLEY.type);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(0.0, (double)(-this.offset), 0.0);
    }

    public double func_145833_n() {
        return super.func_145833_n() + (double)(this.offset * this.offset);
    }

    @Override
    protected void assemble() {
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof PulleyBlock)) {
            return;
        }
        if (this.speed == 0.0f) {
            return;
        }
        if (this.offset >= (float)this.getExtensionRange() && this.getSpeed() > 0.0f) {
            return;
        }
        if (this.offset <= 0.0f && this.getSpeed() < 0.0f) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            BlockPos anchor = this.field_174879_c.func_177979_c((int)(this.offset + 1.0f));
            this.initialOffset = (int)this.offset;
            PulleyContraption contraption = PulleyContraption.assemblePulleyAt(this.field_145850_b, anchor, (int)this.offset);
            if (contraption != null) {
                Direction movementDirection;
                Direction direction = movementDirection = this.getSpeed() > 0.0f ? Direction.DOWN : Direction.UP;
                if (ContraptionCollider.isCollidingWithWorld(this.field_145850_b, contraption, anchor.func_177972_a(movementDirection), movementDirection)) {
                    contraption = null;
                }
            }
            if (contraption == null && this.getSpeed() > 0.0f) {
                return;
            }
            for (int i = (int)this.offset; i > 0; --i) {
                BlockPos offset = this.field_174879_c.func_177979_c(i);
                this.field_145850_b.func_180501_a(offset, Blocks.field_150350_a.func_176223_P(), 66);
            }
            if (contraption != null && !contraption.blocks.isEmpty()) {
                contraption.removeBlocksFromWorld((IWorld)this.field_145850_b, BlockPos.field_177992_a);
                this.movedContraption = ContraptionEntity.createStationary(this.field_145850_b, contraption).controlledBy(this);
                this.movedContraption.func_70107_b(anchor.func_177958_n(), anchor.func_177956_o(), anchor.func_177952_p());
                this.field_145850_b.func_217376_c((Entity)this.movedContraption);
                this.forceMove = true;
            }
        }
        this.clientOffsetDiff = 0.0f;
        this.running = true;
        this.sendData();
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        this.offset = this.getGridOffset(this.offset);
        if (this.movedContraption != null) {
            this.applyContraptionPosition();
        }
        if (!this.field_145850_b.field_72995_K) {
            int i;
            if (this.offset > 0.0f) {
                BlockPos magnetPos = this.field_174879_c.func_177979_c((int)this.offset);
                this.field_145850_b.func_175655_b(magnetPos, this.field_145850_b.func_180495_p(magnetPos).func_196952_d((IBlockReader)this.field_145850_b, magnetPos).func_197766_b());
                this.field_145850_b.func_180501_a(magnetPos, AllBlocks.PULLEY_MAGNET.getDefault(), 66);
            }
            for (i = 1; i <= (int)this.offset - 1; ++i) {
                BlockPos ropePos = this.field_174879_c.func_177979_c(i);
                this.field_145850_b.func_175655_b(ropePos, this.field_145850_b.func_180495_p(ropePos).func_196952_d((IBlockReader)this.field_145850_b, ropePos).func_197766_b());
            }
            for (i = 1; i <= (int)this.offset - 1; ++i) {
                this.field_145850_b.func_180501_a(this.field_174879_c.func_177979_c(i), AllBlocks.ROPE.getDefault(), 66);
            }
            if (this.movedContraption != null) {
                this.movedContraption.disassemble();
            }
        }
        if (this.movedContraption != null) {
            this.movedContraption.func_70106_y();
        }
        this.movedContraption = null;
        this.initialOffset = 0;
        this.running = false;
        this.sendData();
    }

    @Override
    protected Vec3d toPosition(float offset) {
        if (this.movedContraption.getContraption() instanceof PulleyContraption) {
            PulleyContraption contraption = (PulleyContraption)this.movedContraption.getContraption();
            return new Vec3d((Vec3i)contraption.getAnchor()).func_72441_c(0.0, (double)((float)contraption.initialOffset - offset), 0.0);
        }
        return Vec3d.field_186680_a;
    }

    @Override
    protected void visitNewPosition() {
        super.visitNewPosition();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.movedContraption != null) {
            return;
        }
        if (this.getSpeed() <= 0.0f) {
            return;
        }
        BlockPos posBelow = this.field_174879_c.func_177979_c((int)(this.offset + this.getMovementSpeed()) + 1);
        if (!BlockMovementTraits.movementNecessary(this.field_145850_b, posBelow)) {
            return;
        }
        if (BlockMovementTraits.isBrittle(this.field_145850_b.func_180495_p(posBelow))) {
            return;
        }
        this.disassemble();
        this.assembleNextTick = true;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.initialOffset = tag.func_74762_e("InitialOffset");
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("InitialOffset", this.initialOffset);
        return super.func_189515_b(tag);
    }

    @Override
    protected int getExtensionRange() {
        return Math.max(0, Math.min((Integer)AllConfigs.SERVER.kinetics.maxRopeLength.get(), this.field_174879_c.func_177956_o() - 1));
    }

    @Override
    protected int getInitialOffset() {
        return this.initialOffset;
    }

    @Override
    protected Vec3d toMotionVector(float speed) {
        return new Vec3d(0.0, (double)(-speed), 0.0);
    }

    @Override
    protected ValueBoxTransform getMovementModeSlot() {
        return new CenteredSideValueBoxTransform((state, d) -> d == Direction.UP);
    }
}

