/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.crafter;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.modules.contraptions.components.crafter.CrafterHelper;
import com.simibubi.create.modules.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.modules.contraptions.components.crafter.MechanicalCrafterTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class ConnectedInputHandler {
    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            return;
        }
        if (!AllItems.WRENCH.typeOf(heldItem)) {
            return;
        }
        BlockState blockState = world.func_180495_p(pos);
        if (!AllBlocks.MECHANICAL_CRAFTER.typeOf(blockState)) {
            return;
        }
        BlockRayTraceResult ray = RaycastHelper.rayTraceRange(world, player, 10.0);
        if (ray == null) {
            return;
        }
        if (ray.func_216354_b() == blockState.func_177229_b(MechanicalCrafterBlock.HORIZONTAL_FACING)) {
            return;
        }
        Direction activatedDirection = ConnectedInputHandler.getActivatedDirection(world, pos, ray.func_216354_b(), ray.func_216347_e());
        if (activatedDirection != null) {
            if (event.getSide() != LogicalSide.CLIENT) {
                ConnectedInputHandler.toggleConnection(world, pos, pos.func_177972_a(activatedDirection));
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            world.func_184133_a(null, pos, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 0.25f, 0.1f);
        }
    }

    public static List<Pair<Direction, Vec3d>> getConnectiveSides(World world, BlockPos pos, Direction face) {
        ArrayList<Pair<Direction, Vec3d>> sides = new ArrayList<Pair<Direction, Vec3d>>(6);
        BlockState refState = world.func_180495_p(pos);
        Direction refDirection = (Direction)refState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING);
        Vec3d faceOffset = new Vec3d(face.func_176730_m()).func_186678_a(0.5).func_178787_e(VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a));
        if (Block.func_220056_d((BlockState)world.func_180495_p(pos.func_177972_a(face)), (IBlockReader)world, (BlockPos)pos.func_177972_a(face), (Direction)face.func_176734_d())) {
            return sides;
        }
        for (Direction direction : Direction.values()) {
            BlockPos neighbourPos;
            BlockState neighbour;
            if (direction.func_176740_k() == face.func_176740_k() || direction.func_176740_k() == refDirection.func_176740_k() || !AllBlocks.MECHANICAL_CRAFTER.typeOf(neighbour = world.func_180495_p(neighbourPos = pos.func_177972_a(direction))) || refDirection != neighbour.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING) || Block.func_220056_d((BlockState)world.func_180495_p(neighbourPos.func_177972_a(face)), (IBlockReader)world, (BlockPos)neighbourPos.func_177972_a(face), (Direction)face.func_176734_d())) continue;
            Vec3d bbPos = new Vec3d(direction.func_176730_m()).func_186678_a(0.5).func_178787_e(faceOffset);
            sides.add((Pair<Direction, Vec3d>)Pair.of((Object)direction, (Object)bbPos));
        }
        return sides;
    }

    public static Direction getActivatedDirection(World world, BlockPos pos, Direction face, Vec3d hit) {
        Vec3d localHit = hit.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        for (Pair<Direction, Vec3d> pair : ConnectedInputHandler.getConnectiveSides(world, pos, face)) {
            Vec3d bbPos = (Vec3d)pair.getRight();
            AxisAlignedBB bb = new AxisAlignedBB(bbPos, bbPos).func_186662_g(0.1666666716337204);
            if (!bb.func_72318_a(localHit)) continue;
            return (Direction)pair.getKey();
        }
        return null;
    }

    public static void toggleConnection(World world, BlockPos pos, BlockPos pos2) {
        BlockPos controllerPos2;
        MechanicalCrafterTileEntity crafter1 = CrafterHelper.getCrafter((IEnviromentBlockReader)world, pos);
        MechanicalCrafterTileEntity crafter2 = CrafterHelper.getCrafter((IEnviromentBlockReader)world, pos2);
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        BlockPos controllerPos1 = crafter1.func_174877_v().func_177971_a((Vec3i)crafter1.input.data.get(0));
        if (controllerPos1.equals((Object)(controllerPos2 = crafter2.func_174877_v().func_177971_a((Vec3i)crafter2.input.data.get(0))))) {
            MechanicalCrafterTileEntity controller = CrafterHelper.getCrafter((IEnviromentBlockReader)world, controllerPos1);
            Set<BlockPos> positions = controller.input.data.stream().map(l -> controllerPos1.func_177971_a((Vec3i)l)).collect(Collectors.toSet());
            LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
            ArrayList<BlockPos> splitGroup = new ArrayList<BlockPos>();
            frontier.add(pos2);
            positions.remove(pos2);
            positions.remove(pos);
            while (!frontier.isEmpty()) {
                BlockPos current = (BlockPos)frontier.remove(0);
                for (Direction direction : Direction.values()) {
                    BlockPos next = current.func_177972_a(direction);
                    if (!positions.remove(next)) continue;
                    splitGroup.add(next);
                    frontier.add(next);
                }
            }
            ConnectedInputHandler.initAndAddAll(world, crafter1, positions);
            ConnectedInputHandler.initAndAddAll(world, crafter2, splitGroup);
            crafter1.func_70296_d();
            crafter1.connectivityChanged();
            crafter2.func_70296_d();
            crafter2.connectivityChanged();
            return;
        }
        if (!crafter1.input.isController) {
            crafter1 = CrafterHelper.getCrafter((IEnviromentBlockReader)world, controllerPos1);
        }
        if (!crafter2.input.isController) {
            crafter2 = CrafterHelper.getCrafter((IEnviromentBlockReader)world, controllerPos2);
        }
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        ConnectedInputHandler.connectControllers(world, crafter1, crafter2);
        world.func_180501_a(crafter1.func_174877_v(), crafter1.func_195044_w(), 3);
        crafter1.func_70296_d();
        crafter1.connectivityChanged();
        crafter2.func_70296_d();
        crafter2.connectivityChanged();
    }

    public static void initAndAddAll(World world, MechanicalCrafterTileEntity crafter, Collection<BlockPos> positions) {
        crafter.input = new ConnectedInput();
        positions.forEach(splitPos -> ConnectedInputHandler.modifyAndUpdate(world, splitPos, input -> {
            input.attachTo(crafter.func_174877_v(), (BlockPos)splitPos);
            crafter.input.data.add(splitPos.func_177973_b((Vec3i)crafter.func_174877_v()));
        }));
    }

    public static void connectControllers(World world, MechanicalCrafterTileEntity crafter1, MechanicalCrafterTileEntity crafter2) {
        crafter1.input.data.forEach(offset -> {
            BlockPos connectedPos = crafter1.func_174877_v().func_177971_a((Vec3i)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {});
        });
        crafter2.input.data.forEach(offset -> {
            if (offset.equals((Object)BlockPos.field_177992_a)) {
                return;
            }
            BlockPos connectedPos = crafter2.func_174877_v().func_177971_a((Vec3i)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {
                input.attachTo(crafter1.func_174877_v(), connectedPos);
                crafter1.input.data.add(BlockPos.field_177992_a.func_177973_b((Vec3i)input.data.get(0)));
            });
        });
        crafter2.input.attachTo(crafter1.func_174877_v(), crafter2.func_174877_v());
        crafter1.input.data.add(BlockPos.field_177992_a.func_177973_b((Vec3i)crafter2.input.data.get(0)));
    }

    private static void modifyAndUpdate(World world, BlockPos pos, Consumer<ConnectedInput> callback) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof MechanicalCrafterTileEntity)) {
            return;
        }
        MechanicalCrafterTileEntity crafter = (MechanicalCrafterTileEntity)te;
        callback.accept(crafter.input);
        crafter.func_70296_d();
        crafter.connectivityChanged();
    }

    public static class ConnectedInput {
        boolean isController = true;
        List<BlockPos> data = Collections.synchronizedList(new ArrayList());

        public ConnectedInput() {
            this.data.add(BlockPos.field_177992_a);
        }

        public void attachTo(BlockPos controllerPos, BlockPos myPos) {
            this.isController = false;
            this.data.clear();
            this.data.add(controllerPos.func_177973_b((Vec3i)myPos));
        }

        public IItemHandler getItemHandler(World world, BlockPos pos) {
            if (!this.isController) {
                BlockPos controllerPos = pos.func_177971_a((Vec3i)this.data.get(0));
                ConnectedInput input = CrafterHelper.getInput((IEnviromentBlockReader)world, controllerPos);
                if (input == this || input == null || !input.isController) {
                    return new ItemStackHandler();
                }
                return input.getItemHandler(world, controllerPos);
            }
            List list = this.data.stream().map(l -> CrafterHelper.getCrafter((IEnviromentBlockReader)world, pos.func_177971_a((Vec3i)l))).filter((Predicate<MechanicalCrafterTileEntity>)Predicates.notNull()).map(crafter -> crafter.inventory).collect(Collectors.toList());
            return new CombinedInvWrapper((IItemHandlerModifiable[])Arrays.copyOf(list.toArray(), list.size(), IItemHandlerModifiable[].class));
        }

        public void write(CompoundNBT nbt) {
            nbt.func_74757_a("Controller", this.isController);
            ListNBT list = new ListNBT();
            this.data.forEach(pos -> list.add((Object)NBTUtil.func_186859_a((BlockPos)pos)));
            nbt.func_218657_a("Data", (INBT)list);
        }

        public void read(CompoundNBT nbt) {
            this.isController = nbt.func_74767_n("Controller");
            this.data.clear();
            nbt.func_150295_c("Data", 10).forEach(inbt -> this.data.add(NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)inbt))));
        }
    }
}

