/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.crafter;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.inventory.InsertingBehaviour;
import com.simibubi.create.foundation.behaviour.inventory.InventoryManagementBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.components.crafter.ConnectedInputHandler;
import com.simibubi.create.modules.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.modules.contraptions.components.crafter.RecipeGridHandler;
import com.simibubi.create.modules.contraptions.relays.belt.BeltTileEntity;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class MechanicalCrafterTileEntity
extends KineticTileEntity {
    protected ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (MechanicalCrafterTileEntity.this.phase != Phase.IDLE) {
                return stack;
            }
            if (MechanicalCrafterTileEntity.this.covered) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            if (!this.getStackInSlot(slot).func_190926_b() && MechanicalCrafterTileEntity.this.phase == Phase.IDLE) {
                MechanicalCrafterTileEntity.this.checkCompletedRecipe();
            }
            MechanicalCrafterTileEntity.this.func_70296_d();
            MechanicalCrafterTileEntity.this.sendData();
        }
    };
    protected RecipeGridHandler.GroupedItems groupedItems = new RecipeGridHandler.GroupedItems();
    protected ConnectedInputHandler.ConnectedInput input = new ConnectedInputHandler.ConnectedInput();
    protected LazyOptional<IItemHandler> invSupplier = LazyOptional.of(() -> this.input.getItemHandler(this.field_145850_b, this.field_174879_c));
    protected boolean reRender;
    protected Phase phase;
    protected int countDown;
    protected boolean covered;
    protected RecipeGridHandler.GroupedItems groupedItemsBeforeCraft;
    private InsertingBehaviour inserting;

    public MechanicalCrafterTileEntity() {
        super(AllTileEntities.MECHANICAL_CRAFTER.type);
        this.setLazyTickRate(20);
        this.phase = Phase.IDLE;
        this.groupedItemsBeforeCraft = new RecipeGridHandler.GroupedItems();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.inserting = new InsertingBehaviour(this, InventoryManagementBehaviour.Attachments.toward(this::getTargetFacing));
        behaviours.add(this.inserting);
    }

    public void blockChanged() {
        this.removeBehaviour(InsertingBehaviour.TYPE);
        this.inserting = new InsertingBehaviour(this, InventoryManagementBehaviour.Attachments.toward(this::getTargetFacing));
        this.putBehaviour(this.inserting);
    }

    public Direction getTargetFacing() {
        return MechanicalCrafterBlock.getTargetDirection(this.field_145850_b.func_180495_p(this.field_174879_c));
    }

    @Override
    public boolean hasFastRenderer() {
        return false;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        CompoundNBT inputNBT = new CompoundNBT();
        this.input.write(inputNBT);
        compound.func_218657_a("ConnectedInput", (INBT)inputNBT);
        CompoundNBT groupedItemsNBT = new CompoundNBT();
        this.groupedItems.write(groupedItemsNBT);
        compound.func_218657_a("GroupedItems", (INBT)groupedItemsNBT);
        compound.func_74778_a("Phase", this.phase.name());
        compound.func_74768_a("CountDown", this.countDown);
        compound.func_74757_a("Cover", this.covered);
        return super.func_189515_b(compound);
    }

    @Override
    public CompoundNBT writeToClient(CompoundNBT tag) {
        if (this.reRender) {
            tag.func_74757_a("Redraw", true);
            this.reRender = false;
        }
        return super.writeToClient(tag);
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        if (tag.func_74764_b("Redraw")) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 16);
        }
        Phase phaseBefore = this.phase;
        RecipeGridHandler.GroupedItems before = this.groupedItems;
        super.readClientUpdate(tag);
        if (phaseBefore != this.phase && this.phase == Phase.CRAFTING) {
            this.groupedItemsBeforeCraft = before;
        }
        if (phaseBefore == Phase.EXPORTING && this.phase == Phase.WAITING) {
            Direction facing = (Direction)this.func_195044_w().func_177229_b(MechanicalCrafterBlock.HORIZONTAL_FACING);
            Vec3d vec = new Vec3d(facing.func_176730_m()).func_186678_a(0.75).func_178787_e(VecHelper.getCenterOf((Vec3i)this.field_174879_c));
            Direction targetDirection = MechanicalCrafterBlock.getTargetDirection(this.func_195044_w());
            vec = vec.func_178787_e(new Vec3d(targetDirection.func_176730_m()).func_186678_a(1.0));
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197614_g, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        this.input.read(compound.func_74775_l("ConnectedInput"));
        this.groupedItems = RecipeGridHandler.GroupedItems.read(compound.func_74775_l("GroupedItems"));
        this.phase = Phase.IDLE;
        String name = compound.func_74779_i("Phase");
        for (Phase phase : Phase.values()) {
            if (!phase.name().equals(name)) continue;
            this.phase = phase;
        }
        this.countDown = compound.func_74762_e("CountDown");
        this.covered = compound.func_74767_n("Cover");
        super.func_145839_a(compound);
    }

    @Override
    public void func_145843_s() {
        this.invSupplier.invalidate();
        super.func_145843_s();
    }

    public int getCountDownSpeed() {
        if (this.getSpeed() == 0.0f) {
            return 0;
        }
        return MathHelper.func_76125_a((int)((int)Math.abs(this.getSpeed())), (int)4, (int)250);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.phase == Phase.ACCEPTING) {
            return;
        }
        if (this.phase == Phase.ASSEMBLING) {
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                this.countDown = 0;
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                if (RecipeGridHandler.getTargetingCrafter(this) != null) {
                    this.phase = Phase.EXPORTING;
                    this.countDown = 1000;
                    this.sendData();
                    return;
                }
                ItemStack result = RecipeGridHandler.tryToApplyRecipe(this.field_145850_b, this.groupedItems);
                if (result != null) {
                    ArrayList containers = new ArrayList();
                    this.groupedItems.grid.values().forEach(stack -> {
                        if (stack.hasContainerItem()) {
                            containers.add(stack.getContainerItem().func_77946_l());
                        }
                    });
                    this.groupedItems = new RecipeGridHandler.GroupedItems(result);
                    for (int i = 0; i < containers.size(); ++i) {
                        ItemStack stack2 = (ItemStack)containers.get(i);
                        RecipeGridHandler.GroupedItems container = new RecipeGridHandler.GroupedItems();
                        container.grid.put((Pair<Integer, Integer>)Pair.of((Object)i, (Object)0), stack2);
                        container.mergeOnto(this.groupedItems, MechanicalCrafterBlock.Pointing.LEFT);
                    }
                    this.phase = Phase.CRAFTING;
                    this.countDown = 2000;
                    this.sendData();
                    return;
                }
                this.ejectWholeGrid();
                return;
            }
        }
        if (this.phase == Phase.EXPORTING) {
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                this.countDown = 0;
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                MechanicalCrafterTileEntity targetingCrafter = RecipeGridHandler.getTargetingCrafter(this);
                if (targetingCrafter == null) {
                    this.ejectWholeGrid();
                    return;
                }
                MechanicalCrafterBlock.Pointing pointing = (MechanicalCrafterBlock.Pointing)((Object)this.func_195044_w().func_177229_b(MechanicalCrafterBlock.POINTING));
                this.groupedItems.mergeOnto(targetingCrafter.groupedItems, pointing);
                this.groupedItems = new RecipeGridHandler.GroupedItems();
                this.phase = Phase.WAITING;
                this.countDown = 0;
                this.sendData();
                targetingCrafter.continueIfAllPrecedingFinished();
                targetingCrafter.sendData();
                return;
            }
        }
        if (this.phase == Phase.CRAFTING) {
            if (this.field_145850_b.field_72995_K) {
                Direction facing = (Direction)this.func_195044_w().func_177229_b(MechanicalCrafterBlock.HORIZONTAL_FACING);
                float progress = (float)this.countDown / 2000.0f;
                Vec3d facingVec = new Vec3d(facing.func_176730_m());
                Vec3d vec = facingVec.func_186678_a(0.65).func_178787_e(VecHelper.getCenterOf((Vec3i)this.field_174879_c));
                Vec3d offset = VecHelper.offsetRandomly(Vec3d.field_186680_a, this.field_145850_b.field_73012_v, 0.125f).func_216369_h(VecHelper.planeByNormal(facingVec)).func_72432_b().func_186678_a((double)(progress * 0.5f)).func_178787_e(vec);
                if (progress > 0.5f) {
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197614_g, offset.field_72450_a, offset.field_72448_b, offset.field_72449_c, 0.0, 0.0, 0.0);
                }
                if (!this.groupedItemsBeforeCraft.grid.isEmpty() && progress < 0.5f && this.groupedItems.grid.containsKey(Pair.of((Object)0, (Object)0))) {
                    ItemStack stack3 = this.groupedItems.grid.get(Pair.of((Object)0, (Object)0));
                    this.groupedItemsBeforeCraft = new RecipeGridHandler.GroupedItems();
                    for (int i = 0; i < 10; ++i) {
                        Vec3d randVec = VecHelper.offsetRandomly(Vec3d.field_186680_a, this.field_145850_b.field_73012_v, 0.125f).func_216369_h(VecHelper.planeByNormal(facingVec)).func_72432_b().func_186678_a(0.25);
                        Vec3d offset2 = randVec.func_178787_e(vec);
                        randVec = randVec.func_186678_a((double)0.35f);
                        this.field_145850_b.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack3), offset2.field_72450_a, offset2.field_72448_b, offset2.field_72449_c, randVec.field_72450_a, randVec.field_72448_b, randVec.field_72449_c);
                    }
                }
            }
            this.countDown -= this.getCountDownSpeed();
            if (this.countDown < 0) {
                this.countDown = 0;
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                this.tryInsert();
                return;
            }
        }
        if (this.phase == Phase.INSERTING) {
            if (!this.field_145850_b.field_72995_K && this.isTargetingBelt()) {
                this.tryInsert();
            }
            return;
        }
    }

    protected boolean isTargetingBelt() {
        BlockPos targetPos = this.field_174879_c.func_177972_a(this.getTargetFacing());
        if (!AllBlocks.BELT.typeOf(this.field_145850_b.func_180495_p(targetPos))) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(targetPos);
        if (!(te instanceof BeltTileEntity)) {
            return false;
        }
        return ((KineticTileEntity)te).getSpeed() != 0.0f;
    }

    public void tryInsert() {
        if (this.inserting.getInventory() == null && !this.isTargetingBelt()) {
            this.ejectWholeGrid();
            return;
        }
        boolean chagedPhase = this.phase != Phase.INSERTING;
        LinkedList inserted = new LinkedList();
        this.groupedItems.grid.forEach((pair, stack) -> {
            if (this.isTargetingBelt()) {
                Direction facing = this.getTargetFacing();
                BlockPos targetPos = this.field_174879_c.func_177972_a(facing);
                BeltTileEntity te = (BeltTileEntity)this.field_145850_b.func_175625_s(targetPos);
                if (te.tryInsertingFromSide(facing, (ItemStack)stack, false)) {
                    inserted.add(pair);
                }
                return;
            }
            ItemStack remainder = this.inserting.insert(stack.func_77946_l(), false);
            if (!remainder.func_190926_b()) {
                stack.func_190920_e(remainder.func_190916_E());
            } else {
                inserted.add(pair);
            }
        });
        inserted.forEach(this.groupedItems.grid::remove);
        if (this.groupedItems.grid.isEmpty()) {
            this.ejectWholeGrid();
        } else {
            this.phase = Phase.INSERTING;
        }
        if (!inserted.isEmpty() || chagedPhase) {
            this.sendData();
        }
    }

    public void ejectWholeGrid() {
        List<MechanicalCrafterTileEntity> chain = RecipeGridHandler.getAllCraftersOfChain(this);
        if (chain == null) {
            return;
        }
        chain.forEach(MechanicalCrafterTileEntity::eject);
    }

    public void eject() {
        BlockState blockState = this.func_195044_w();
        boolean present = AllBlocks.MECHANICAL_CRAFTER.typeOf(blockState);
        Vec3d vec = present ? new Vec3d(((Direction)blockState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176730_m()).func_186678_a(0.75) : Vec3d.field_186680_a;
        Vec3d ejectPos = VecHelper.getCenterOf((Vec3i)this.field_174879_c).func_178787_e(vec);
        this.groupedItems.grid.forEach((pair, stack) -> this.dropItem(ejectPos, (ItemStack)stack));
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            this.dropItem(ejectPos, this.inventory.getStackInSlot(0));
        }
        this.phase = Phase.IDLE;
        this.groupedItems = new RecipeGridHandler.GroupedItems();
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        this.sendData();
    }

    public void dropItem(Vec3d ejectPos, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.field_145850_b, ejectPos.field_72450_a, ejectPos.field_72448_b, ejectPos.field_72449_c, stack);
        itemEntity.func_174869_p();
        this.field_145850_b.func_217376_c((Entity)itemEntity);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.phase == Phase.IDLE && this.craftingItemPresent()) {
            this.checkCompletedRecipe();
        }
        if (this.phase == Phase.INSERTING) {
            this.tryInsert();
        }
    }

    public boolean craftingItemPresent() {
        return !this.inventory.getStackInSlot(0).func_190926_b() || this.covered;
    }

    protected void checkCompletedRecipe() {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List<MechanicalCrafterTileEntity> chain = RecipeGridHandler.getAllCraftersOfChainIf(this, MechanicalCrafterTileEntity::craftingItemPresent);
        if (chain == null) {
            return;
        }
        chain.forEach(MechanicalCrafterTileEntity::begin);
    }

    protected void begin() {
        this.phase = Phase.ACCEPTING;
        this.groupedItems = new RecipeGridHandler.GroupedItems(this.inventory.getStackInSlot(0));
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        if (RecipeGridHandler.getPrecedingCrafters(this).isEmpty()) {
            this.phase = Phase.ASSEMBLING;
            this.countDown = 500;
        }
        this.sendData();
    }

    protected void continueIfAllPrecedingFinished() {
        List<MechanicalCrafterTileEntity> preceding = RecipeGridHandler.getPrecedingCrafters(this);
        if (preceding == null) {
            this.ejectWholeGrid();
            return;
        }
        for (MechanicalCrafterTileEntity mechanicalCrafterTileEntity : preceding) {
            if (mechanicalCrafterTileEntity.phase == Phase.WAITING) continue;
            return;
        }
        this.phase = Phase.ASSEMBLING;
        this.countDown = Math.max(100, this.getCountDownSpeed() + 1);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.func_195044_w().func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING) == side) {
                return LazyOptional.empty();
            }
            return this.invSupplier.cast();
        }
        return super.getCapability(cap, side);
    }

    public void connectivityChanged() {
        this.reRender = true;
        this.sendData();
        this.invSupplier.invalidate();
        this.invSupplier = LazyOptional.of(() -> this.input.getItemHandler(this.field_145850_b, this.field_174879_c));
    }

    static enum Phase {
        IDLE,
        ACCEPTING,
        ASSEMBLING,
        EXPORTING,
        WAITING,
        CRAFTING,
        INSERTING;

    }
}

