/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.crafter;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.foundation.block.SafeTileEntityRenderer;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.block.render.SpriteShifter;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import com.simibubi.create.modules.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.modules.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.modules.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.modules.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.modules.contraptions.components.crafter.RecipeGridHandler;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IEnviromentBlockReader;

public class MechanicalCrafterTileEntityRenderer
extends SafeTileEntityRenderer<MechanicalCrafterTileEntity> {
    public static SpriteShiftEntry animatedTexture = SpriteShifter.get("block/crafter_thingies", "block/crafter_thingies");

    @Override
    public void renderWithGL(MechanicalCrafterTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.pushMatrix();
        Direction facing = (Direction)te.func_195044_w().func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING);
        Vec3d vec = new Vec3d(facing.func_176730_m()).func_186678_a(0.58).func_72441_c(0.5, 0.5, 0.5);
        if (te.phase == MechanicalCrafterTileEntity.Phase.EXPORTING) {
            Direction targetDirection = MechanicalCrafterBlock.getTargetDirection(te.func_195044_w());
            float progress = MathHelper.func_76131_a((float)(((float)(1000 - te.countDown) + (float)te.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
            vec = vec.func_178787_e(new Vec3d(targetDirection.func_176730_m()).func_186678_a((double)(progress * 0.75f)));
        }
        GlStateManager.translated((double)(x + vec.field_72450_a), (double)(y + vec.field_72448_b), (double)(z + vec.field_72449_c));
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        float yRot = AngleHelper.horizontalAngle(facing);
        GlStateManager.rotated((double)yRot, (double)0.0, (double)1.0, (double)0.0);
        this.renderItems(te, partialTicks);
        GlStateManager.popMatrix();
        TessellatorHelper.prepareFastRender();
        TessellatorHelper.begin(DefaultVertexFormats.field_176600_a);
        this.renderTileEntityFast(te, x, y, z, partialTicks, destroyStage, Tessellator.func_178181_a().func_178180_c());
        TessellatorHelper.draw();
    }

    public void renderItems(MechanicalCrafterTileEntity te, float partialTicks) {
        RenderHelper.func_74519_b();
        if (te.phase == MechanicalCrafterTileEntity.Phase.IDLE) {
            ItemStack stack2 = te.inventory.getStackInSlot(0);
            if (!stack2.func_190926_b()) {
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-0.00390625f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(stack2, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.popMatrix();
            }
        } else {
            RecipeGridHandler.GroupedItems items = te.groupedItems;
            float distance = 0.5f;
            GlStateManager.pushMatrix();
            if (te.phase == MechanicalCrafterTileEntity.Phase.CRAFTING) {
                items = te.groupedItemsBeforeCraft;
                items.calcStats();
                float progress = MathHelper.func_76131_a((float)(((float)(2000 - te.countDown) + (float)te.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = MathHelper.func_76131_a((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = MathHelper.func_76131_a((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                GlStateManager.scaled((double)(1.0f - lateProgress), (double)(1.0f - lateProgress), (double)(1.0f - lateProgress));
                Vec3d centering = new Vec3d((double)((float)(-items.minX) + (float)(-items.width + 1) / 2.0f), (double)((float)(-items.minY) + (float)(-items.height + 1) / 2.0f), 0.0).func_186678_a((double)earlyProgress);
                GlStateManager.translated((double)(centering.field_72450_a * 0.5), (double)(centering.field_72448_b * 0.5), (double)0.0);
                distance += (-4.0f * (progress - 0.5f) * (progress - 0.5f) + 1.0f) * 0.25f;
            }
            boolean onlyRenderFirst = te.phase == MechanicalCrafterTileEntity.Phase.INSERTING || te.phase == MechanicalCrafterTileEntity.Phase.CRAFTING && te.countDown < 1000;
            float spacing = distance;
            items.grid.forEach((pair, stack) -> {
                if (onlyRenderFirst && ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0)) {
                    return;
                }
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)((float)((Integer)pair.getKey()).intValue() * spacing), (float)((float)((Integer)pair.getValue()).intValue() * spacing), (float)0.0f);
                TessellatorHelper.fightZFighting(pair.hashCode() + te.func_174877_v().hashCode());
                Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.popMatrix();
            });
            GlStateManager.popMatrix();
            if (te.phase == MechanicalCrafterTileEntity.Phase.CRAFTING) {
                items = te.groupedItems;
                float progress = MathHelper.func_76131_a((float)(((float)(1000 - te.countDown) + (float)te.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = MathHelper.func_76131_a((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = MathHelper.func_76131_a((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                GlStateManager.rotated((double)(earlyProgress * 2.0f * 360.0f), (double)0.0, (double)0.0, (double)1.0);
                float upScaling = earlyProgress * 1.125f;
                float downScaling = 1.0f + (1.0f - lateProgress) * 0.125f;
                GlStateManager.scaled((double)upScaling, (double)upScaling, (double)upScaling);
                GlStateManager.scaled((double)downScaling, (double)downScaling, (double)downScaling);
                items.grid.forEach((pair, stack) -> {
                    if ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0) {
                        return;
                    }
                    Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                });
            }
        }
        RenderHelper.func_74518_a();
    }

    @Override
    public void renderFast(MechanicalCrafterTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder buffer) {
        BlockState blockState = te.func_195044_w();
        SuperByteBuffer superBuffer = AllBlockPartials.SHAFTLESS_COGWHEEL.renderOn(blockState);
        superBuffer.rotateCentered(Direction.Axis.X, 1.5707964f);
        superBuffer.rotateCentered(Direction.Axis.Y, (float)(((Direction)blockState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176740_k() != Direction.Axis.X ? 0.0 : 1.5707963267948966));
        KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, this.func_178459_a()).translate(x, y, z).renderInto(buffer);
        Direction targetDirection = MechanicalCrafterBlock.getTargetDirection(blockState);
        BlockPos pos = te.func_174877_v();
        if ((te.covered || te.phase != MechanicalCrafterTileEntity.Phase.IDLE) && te.phase != MechanicalCrafterTileEntity.Phase.CRAFTING && te.phase != MechanicalCrafterTileEntity.Phase.INSERTING) {
            SuperByteBuffer lidBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_LID, blockState, pos);
            lidBuffer.translate(x, y, z).renderInto(buffer);
        }
        if (MechanicalCrafterBlock.isValidTarget(this.func_178459_a(), pos.func_177972_a(targetDirection), blockState)) {
            SuperByteBuffer beltBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_BELT, blockState, pos);
            SuperByteBuffer beltFrameBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_BELT_FRAME, blockState, pos);
            if (te.phase == MechanicalCrafterTileEntity.Phase.EXPORTING) {
                int textureIndex = (int)((float)te.getCountDownSpeed() / 128.0f * (float)AnimationTickHolder.ticks);
                beltBuffer.shiftUVtoSheet(animatedTexture, (float)(textureIndex % 4) / 4.0f, 0.0f, 1);
            } else {
                beltBuffer.dontShiftUV();
            }
            beltBuffer.translate(x, y, z).renderInto(buffer);
            beltFrameBuffer.translate(x, y, z).renderInto(buffer);
        } else {
            SuperByteBuffer arrowBuffer = this.renderAndTransform(AllBlockPartials.MECHANICAL_CRAFTER_ARROW, blockState, pos);
            arrowBuffer.translate(x, y, z).renderInto(buffer);
        }
    }

    private SuperByteBuffer renderAndTransform(AllBlockPartials renderBlock, BlockState crafterState, BlockPos pos) {
        SuperByteBuffer buffer = renderBlock.renderOn(crafterState);
        float xRot = ((MechanicalCrafterBlock.Pointing)((Object)crafterState.func_177229_b(MechanicalCrafterBlock.POINTING))).getXRotation();
        float yRot = AngleHelper.horizontalAngle((Direction)crafterState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING));
        buffer.rotateCentered(Direction.Axis.X, (float)((double)(xRot / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.Axis.Y, (float)((double)((yRot + 90.0f) / 180.0f) * Math.PI));
        buffer.light(crafterState.func_215684_a((IEnviromentBlockReader)this.func_178459_a(), pos));
        return buffer;
    }
}

