/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.deployer;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.behaviour.inventory.ExtractingBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.modules.contraptions.components.deployer.DeployerFilterSlot;
import com.simibubi.create.modules.contraptions.components.deployer.DeployerHandler;
import com.simibubi.create.modules.contraptions.components.deployer.DeployerItemHandler;
import com.simibubi.create.modules.curiosities.tools.SandPaperItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class DeployerTileEntity
extends KineticTileEntity {
    private static final List<Pair<BlockPos, Direction>> EXTRACTING_LOCATIONS = Arrays.asList(Direction.values()).stream().map(d -> Pair.of((Object)BlockPos.field_177992_a.func_177972_a(d), (Object)d.func_176734_d())).collect(Collectors.toList());
    private FilteringBehaviour filtering;
    private ExtractingBehaviour extracting;
    protected State state;
    protected Mode mode;
    protected ItemStack heldItem = ItemStack.field_190927_a;
    protected DeployerFakePlayer player;
    protected int timer;
    protected float reach;
    protected boolean boop = false;
    protected List<ItemStack> overflowItems = new ArrayList<ItemStack>();
    private ListNBT deferredInventoryList;
    private LazyOptional<IItemHandlerModifiable> invHandler;

    public DeployerTileEntity() {
        super(AllTileEntities.DEPLOYER.type);
        this.state = State.WAITING;
        this.mode = Mode.USE;
        this.heldItem = ItemStack.field_190927_a;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour(this, new DeployerFilterSlot());
        this.extracting = new ExtractingBehaviour(this, this::getExtractingLocations, this::onExtract);
        behaviours.add(this.filtering);
        behaviours.add(this.extracting);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.field_145850_b.field_72995_K) {
            this.player = new DeployerFakePlayer((ServerWorld)this.field_145850_b);
            if (this.deferredInventoryList != null) {
                this.player.field_71071_by.func_70443_b(this.deferredInventoryList);
                this.deferredInventoryList = null;
                this.heldItem = this.player.func_184614_ca();
                this.sendData();
            }
            Vec3d initialPos = VecHelper.getCenterOf((Vec3i)this.field_174879_c.func_177972_a((Direction)this.func_195044_w().func_177229_b((IProperty)DirectionalKineticBlock.FACING)));
            this.player.func_70107_b(initialPos.field_72450_a, initialPos.field_72448_b, initialPos.field_72449_c);
        }
        this.invHandler = LazyOptional.of(this::createHandler);
    }

    protected void onExtract(ItemStack stack) {
        this.player.func_184611_a(Hand.MAIN_HAND, stack.func_77946_l());
        this.sendData();
        this.func_70296_d();
    }

    protected List<Pair<BlockPos, Direction>> getExtractingLocations() {
        return EXTRACTING_LOCATIONS;
    }

    protected int getTimerSpeed() {
        return (int)(this.getSpeed() == 0.0f ? 0.0f : MathHelper.func_76131_a((float)Math.abs(this.getSpeed() * 2.0f), (float)8.0f, (float)512.0f));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.player != null && this.player.blockBreakingProgress != null && this.field_145850_b.func_175623_d((BlockPos)this.player.blockBreakingProgress.getKey())) {
            this.field_145850_b.func_175715_c(this.player.func_145782_y(), (BlockPos)this.player.blockBreakingProgress.getKey(), -1);
            this.player.blockBreakingProgress = null;
        }
        if (this.timer > 0) {
            this.timer -= this.getTimerSpeed();
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack stack = this.player.func_184614_ca();
        if (this.state == State.WAITING) {
            if (!this.overflowItems.isEmpty()) {
                this.tryDisposeOfItems();
                if (!this.overflowItems.isEmpty()) {
                    this.timer = this.getTimerSpeed() * 10;
                }
                return;
            }
            if (!this.filtering.test(stack)) {
                if (!stack.func_190926_b()) {
                    this.overflowItems.add(stack);
                    this.player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                    this.sendData();
                    return;
                }
                this.extracting.extract(1);
                if (!this.filtering.test(stack)) {
                    this.timer = this.getTimerSpeed() * 10;
                }
                return;
            }
            if (this.filtering.getFilter().func_190926_b() && stack.func_190926_b()) {
                this.extracting.extract(1);
            }
            Direction facing = (Direction)this.func_195044_w().func_177229_b((IProperty)DirectionalKineticBlock.FACING);
            if (this.mode == Mode.USE && !DeployerHandler.shouldActivate(stack, this.field_145850_b, this.field_174879_c.func_177967_a(facing, 2))) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            if (this.mode == Mode.PUNCH && !this.boop && this.startBoop(facing)) {
                return;
            }
            this.state = State.EXPANDING;
            Vec3d movementVector = this.getMovementVector();
            Vec3d rayOrigin = VecHelper.getCenterOf((Vec3i)this.field_174879_c).func_178787_e(movementVector.func_186678_a(1.5));
            Vec3d rayTarget = VecHelper.getCenterOf((Vec3i)this.field_174879_c).func_178787_e(movementVector.func_186678_a(2.5));
            RayTraceContext rayTraceContext = new RayTraceContext(rayOrigin, rayTarget, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)this.player);
            BlockRayTraceResult result = this.field_145850_b.func_217299_a(rayTraceContext);
            this.reach = (float)(0.5 + Math.min(result.func_216347_e().func_178788_d(rayOrigin).func_72433_c(), 0.75));
            this.timer = 1000;
            this.sendData();
            return;
        }
        if (this.state == State.EXPANDING) {
            if (this.boop) {
                this.triggerBoop();
            } else {
                this.activate();
            }
            this.state = State.RETRACTING;
            this.timer = 1000;
            this.sendData();
            return;
        }
        if (this.state == State.RETRACTING) {
            this.state = State.WAITING;
            this.timer = 500;
            this.returnAndDeposit();
            this.sendData();
            return;
        }
    }

    public boolean startBoop(Direction facing) {
        if (!this.field_145850_b.func_175623_d(this.field_174879_c.func_177967_a(facing, 1)) || !this.field_145850_b.func_175623_d(this.field_174879_c.func_177967_a(facing, 2))) {
            return false;
        }
        BlockPos otherDeployer = this.field_174879_c.func_177967_a(facing, 4);
        if (!this.field_145850_b.func_195588_v(otherDeployer)) {
            return false;
        }
        TileEntity otherTile = this.field_145850_b.func_175625_s(otherDeployer);
        if (!(otherTile instanceof DeployerTileEntity)) {
            return false;
        }
        DeployerTileEntity deployerTile = (DeployerTileEntity)otherTile;
        if (((Direction)this.field_145850_b.func_180495_p(otherDeployer).func_177229_b((IProperty)DirectionalKineticBlock.FACING)).func_176734_d() != facing || deployerTile.mode != Mode.PUNCH) {
            return false;
        }
        this.boop = true;
        this.reach = 1.0f;
        this.timer = 1000;
        this.state = State.EXPANDING;
        this.sendData();
        return true;
    }

    public void triggerBoop() {
        TileEntity otherTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((IProperty)DirectionalKineticBlock.FACING), 4));
        if (!(otherTile instanceof DeployerTileEntity)) {
            return;
        }
        DeployerTileEntity deployerTile = (DeployerTileEntity)otherTile;
        if (!deployerTile.boop || deployerTile.state != State.EXPANDING) {
            return;
        }
        if (deployerTile.timer > 0) {
            return;
        }
        this.boop = false;
        deployerTile.boop = false;
        deployerTile.state = State.RETRACTING;
        deployerTile.timer = 1000;
        deployerTile.sendData();
        List players = this.field_145850_b.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(9.0));
        players.forEach(AllTriggers.DEPLOYER_BOOP::trigger);
    }

    protected void activate() {
        Vec3d movementVector = this.getMovementVector();
        Direction direction = (Direction)this.func_195044_w().func_177229_b((IProperty)DirectionalKineticBlock.FACING);
        Vec3d center = VecHelper.getCenterOf((Vec3i)this.field_174879_c);
        BlockPos clickedPos = this.field_174879_c.func_177967_a(direction, 2);
        this.player.field_70177_z = direction.func_185119_l();
        this.player.field_70125_A = direction == Direction.UP ? -90.0f : (direction == Direction.DOWN ? 90.0f : 0.0f);
        DeployerHandler.activate(this.player, center, clickedPos, movementVector, this.mode);
        if (this.player != null) {
            this.heldItem = this.player.func_184614_ca();
        }
    }

    protected void returnAndDeposit() {
        PlayerInventory inv = this.player.field_71071_by;
        for (List list : Arrays.asList(inv.field_70460_b, inv.field_184439_c, inv.field_70462_a)) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack = (ItemStack)list.get(i);
                if (itemstack.func_190926_b() || list == inv.field_70462_a && i == inv.field_70461_c && this.filtering.test(itemstack)) continue;
                if (!(itemstack = this.insert(itemstack, false)).func_190926_b()) {
                    ItemHelper.addToList(itemstack, this.overflowItems);
                }
                list.set(i, ItemStack.field_190927_a);
            }
        }
        this.heldItem = this.player.func_184614_ca();
    }

    protected void tryDisposeOfItems() {
        boolean noInv = this.extracting.getInventories().isEmpty();
        Iterator<ItemStack> iterator = this.overflowItems.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            if (noInv) {
                Vec3d offset = this.getMovementVector();
                Vec3d outPos = VecHelper.getCenterOf((Vec3i)this.field_174879_c).func_178787_e(offset.func_186678_a((double)-0.65f));
                Vec3d motion = offset.func_186678_a(-0.25);
                ItemEntity e = new ItemEntity(this.field_145850_b, outPos.field_72450_a, outPos.field_72448_b, outPos.field_72449_c, itemStack.func_77946_l());
                e.func_213317_d(motion);
                this.field_145850_b.func_217376_c((Entity)e);
                iterator.remove();
                continue;
            }
            if (!(itemStack = this.insert(itemStack, false)).func_190926_b()) continue;
            iterator.remove();
        }
    }

    protected ItemStack insert(ItemStack stack, boolean simulate) {
        IItemHandler inv;
        Iterator<IItemHandler> iterator = this.extracting.getInventories().iterator();
        while (iterator.hasNext() && !(stack = ItemHandlerHelper.insertItemStacked((IItemHandler)(inv = iterator.next()), (ItemStack)stack, (boolean)simulate)).func_190926_b()) {
        }
        return stack;
    }

    protected Vec3d getMovementVector() {
        if (!AllBlocks.DEPLOYER.typeOf(this.func_195044_w())) {
            return Vec3d.field_186680_a;
        }
        return new Vec3d(((Direction)this.func_195044_w().func_177229_b((IProperty)DirectionalKineticBlock.FACING)).func_176730_m());
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.state = NBTHelper.readEnum(compound.func_74779_i("State"), State.class);
        this.mode = NBTHelper.readEnum(compound.func_74779_i("Mode"), Mode.class);
        this.timer = compound.func_74762_e("Timer");
        this.deferredInventoryList = compound.func_150295_c("Inventory", 10);
        this.overflowItems = NBTHelper.readItemList(compound.func_150295_c("Overflow", 10));
        if (compound.func_74764_b("HeldItem")) {
            this.heldItem = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("HeldItem"));
        }
        super.func_145839_a(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74778_a("Mode", NBTHelper.writeEnum(this.mode));
        compound.func_74778_a("State", NBTHelper.writeEnum(this.state));
        compound.func_74768_a("Timer", this.timer);
        if (this.player != null) {
            compound.func_218657_a("HeldItem", (INBT)this.player.func_184614_ca().serializeNBT());
            ListNBT invNBT = new ListNBT();
            this.player.field_71071_by.func_70442_a(invNBT);
            compound.func_218657_a("Inventory", (INBT)invNBT);
            compound.func_218657_a("Overflow", (INBT)NBTHelper.writeItemList(this.overflowItems));
        }
        return super.func_189515_b(compound);
    }

    @Override
    public CompoundNBT writeToClient(CompoundNBT compound) {
        compound.func_74776_a("Reach", this.reach);
        if (this.player != null) {
            compound.func_218657_a("HeldItem", (INBT)this.player.func_184614_ca().serializeNBT());
            if (this.player.spawnedItemEffects != null) {
                compound.func_218657_a("Particle", (INBT)this.player.spawnedItemEffects.serializeNBT());
                this.player.spawnedItemEffects = null;
            }
        }
        return super.writeToClient(compound);
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        this.reach = tag.func_74760_g("Reach");
        if (tag.func_74764_b("Particle")) {
            ItemStack particleStack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Particle"));
            SandPaperItem.spawnParticles(VecHelper.getCenterOf((Vec3i)this.field_174879_c).func_178787_e(this.getMovementVector().func_186678_a(2.0)), particleStack, this.field_145850_b);
        }
        super.readClientUpdate(tag);
    }

    private IItemHandlerModifiable createHandler() {
        return new DeployerItemHandler(this);
    }

    @Override
    public boolean hasFastRenderer() {
        return false;
    }

    public AllBlockPartials getHandPose() {
        return this.mode == Mode.PUNCH ? AllBlockPartials.DEPLOYER_HAND_PUNCHING : (this.heldItem.func_190926_b() ? AllBlockPartials.DEPLOYER_HAND_POINTING : AllBlockPartials.DEPLOYER_HAND_HOLDING);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(3.0);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    public void changeMode() {
        this.mode = this.mode == Mode.PUNCH ? Mode.USE : Mode.PUNCH;
        this.func_70296_d();
        this.sendData();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.invHandler != null) {
            return this.invHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    static enum Mode {
        PUNCH,
        USE;

    }

    static enum State {
        WAITING,
        EXPANDING,
        RETRACTING,
        DUMPING;

    }
}

