/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.deployer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.block.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.base.DirectionalAxisKineticBlock;
import com.simibubi.create.modules.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.modules.contraptions.base.IRotate;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.modules.contraptions.components.contraptions.MovementContext;
import com.simibubi.create.modules.contraptions.components.deployer.DeployerTileEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.BlockItem;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;

public class DeployerTileEntityRenderer
extends SafeTileEntityRenderer<DeployerTileEntity> {
    @Override
    public void renderWithGL(DeployerTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        this.renderItem(te, x, y, z, partialTicks);
        FilteringRenderer.renderOnTileEntity(te, x, y, z, partialTicks, destroyStage);
        this.renderComponents(te, x, y, z, partialTicks);
    }

    protected void renderItem(DeployerTileEntity te, double x, double y, double z, float partialTicks) {
        boolean isBlockItem;
        BlockState deployerState = te.func_195044_w();
        Vec3d offset = this.getHandOffset(te, partialTicks, deployerState).func_178787_e(VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a));
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(offset.field_72450_a + x), (double)(offset.field_72448_b + y), (double)(offset.field_72449_c + z));
        Direction facing = (Direction)deployerState.func_177229_b((IProperty)DirectionalKineticBlock.FACING);
        boolean punching = te.mode == DeployerTileEntity.Mode.PUNCH;
        float yRot = AngleHelper.horizontalAngle(facing) + 180.0f;
        float zRot = facing == Direction.UP ? 90.0f : (facing == Direction.DOWN ? 270.0f : 0.0f);
        boolean displayMode = facing == Direction.UP && te.getSpeed() == 0.0f && !punching;
        GlStateManager.rotatef((float)yRot, (float)0.0f, (float)1.0f, (float)0.0f);
        if (!displayMode) {
            GlStateManager.rotatef((float)zRot, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translated((double)0.0, (double)0.0, (double)-0.6875);
        }
        if (punching) {
            GlStateManager.translatef((float)0.0f, (float)0.125f, (float)-0.0625f);
        }
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        ItemCameraTransforms.TransformType transform = ItemCameraTransforms.TransformType.NONE;
        boolean bl = isBlockItem = te.heldItem.func_77973_b() instanceof BlockItem && itemRenderer.func_204206_b(te.heldItem).func_177556_c();
        if (displayMode) {
            float scale = isBlockItem ? 1.25f : 1.0f;
            GlStateManager.translated((double)0.0, (double)(isBlockItem ? 0.5625 : 0.6875), (double)0.0);
            GlStateManager.scaled((double)scale, (double)scale, (double)scale);
            transform = ItemCameraTransforms.TransformType.GROUND;
            GlStateManager.rotatef((float)AnimationTickHolder.getRenderTick(), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            float scale = punching ? 0.75f : (isBlockItem ? 0.734375f : 0.5f);
            GlStateManager.scaled((double)scale, (double)scale, (double)scale);
            transform = punching ? ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIXED;
        }
        itemRenderer.func_181564_a(te.heldItem, transform);
        GlStateManager.popMatrix();
    }

    protected void renderComponents(DeployerTileEntity te, double x, double y, double z, float partialTicks) {
        TessellatorHelper.prepareFastRender();
        TessellatorHelper.begin(DefaultVertexFormats.field_176600_a);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        KineticTileEntityRenderer.renderRotatingKineticBlock(te, this.func_178459_a(), this.getRenderedBlockState(te), x, y, z, buffer);
        BlockState blockState = te.func_195044_w();
        BlockPos pos = te.func_174877_v();
        SuperByteBuffer pole = DeployerTileEntityRenderer.renderAndTransform(this.func_178459_a(), AllBlockPartials.DEPLOYER_POLE, blockState, pos, true);
        SuperByteBuffer hand = DeployerTileEntityRenderer.renderAndTransform(this.func_178459_a(), te.getHandPose(), blockState, pos, false);
        Vec3d offset = this.getHandOffset(te, partialTicks, blockState);
        pole.translate(x + offset.field_72450_a, y + offset.field_72448_b, z + offset.field_72449_c).renderInto(buffer);
        hand.translate(x + offset.field_72450_a, y + offset.field_72448_b, z + offset.field_72449_c).renderInto(buffer);
        TessellatorHelper.draw();
    }

    protected Vec3d getHandOffset(DeployerTileEntity te, float partialTicks, BlockState blockState) {
        float progress = 0.0f;
        if (te.state == DeployerTileEntity.State.EXPANDING) {
            progress = 1.0f - ((float)te.timer - partialTicks * (float)te.getTimerSpeed()) / 1000.0f;
        }
        if (te.state == DeployerTileEntity.State.RETRACTING) {
            progress = ((float)te.timer - partialTicks * (float)te.getTimerSpeed()) / 1000.0f;
        }
        float handLength = te.getHandPose() == AllBlockPartials.DEPLOYER_HAND_POINTING ? 0.0f : (te.getHandPose() == AllBlockPartials.DEPLOYER_HAND_HOLDING ? 0.25f : 0.1875f);
        float distance = Math.min(MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f) * (te.reach + handLength), 1.3125f);
        Vec3d offset = new Vec3d(((Direction)blockState.func_177229_b((IProperty)DirectionalKineticBlock.FACING)).func_176730_m()).func_186678_a((double)distance);
        return offset;
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        BlockState state = te.func_195044_w();
        if (!AllBlocks.DEPLOYER.typeOf(state)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return (BlockState)AllBlocks.SHAFT.get().func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)((IRotate)state.func_177230_c()).getRotationAxis(state));
    }

    private static SuperByteBuffer renderAndTransform(World world, AllBlockPartials renderBlock, BlockState deployerState, BlockPos pos, boolean axisDirectionMatters) {
        SuperByteBuffer buffer = renderBlock.renderOn(deployerState);
        Direction facing = (Direction)deployerState.func_177229_b((IProperty)DirectionalKineticBlock.FACING);
        float zRotFirst = axisDirectionMatters && (Boolean)deployerState.func_177229_b((IProperty)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.func_176740_k() == Direction.Axis.Z ? 90.0f : 0.0f;
        float yRot = AngleHelper.horizontalAngle(facing);
        float zRot = facing == Direction.UP ? 270.0f : (facing == Direction.DOWN ? 90.0f : 0.0f);
        buffer.rotateCentered(Direction.Axis.Z, (float)((double)(zRotFirst / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.Axis.Y, (float)((double)(yRot / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.Axis.Z, (float)((double)(zRot / 180.0f) * Math.PI));
        buffer.light(deployerState.func_215684_a((IEnviromentBlockReader)world, pos));
        return buffer;
    }

    public static List<SuperByteBuffer> renderListInContraption(MovementContext context) {
        double factor;
        BlockState blockState = context.state;
        BlockPos pos = BlockPos.field_177992_a;
        DeployerTileEntity.Mode mode = NBTHelper.readEnum(context.tileData.func_74779_i("Mode"), DeployerTileEntity.Mode.class);
        World world = context.world;
        AllBlockPartials handPose = mode == DeployerTileEntity.Mode.PUNCH ? AllBlockPartials.DEPLOYER_HAND_PUNCHING : AllBlockPartials.DEPLOYER_HAND_POINTING;
        SuperByteBuffer pole = DeployerTileEntityRenderer.renderAndTransform(world, AllBlockPartials.DEPLOYER_POLE, blockState, pos, true);
        SuperByteBuffer hand = DeployerTileEntityRenderer.renderAndTransform(world, handPose, blockState, pos, false);
        if (context.contraption.stalled || context.position == null || context.data.func_74764_b("StationaryTimer")) {
            factor = MathHelper.func_76126_a((float)(AnimationTickHolder.getRenderTick() * 0.5f)) * 0.25f + 0.25f;
        } else {
            Vec3d center = VecHelper.getCenterOf((Vec3i)new BlockPos(context.position));
            double distance = context.position.func_72438_d(center);
            double nextDistance = context.position.func_178787_e(context.motion).func_72438_d(center);
            factor = 0.5 - MathHelper.func_151237_a((double)MathHelper.func_219803_d((double)Minecraft.func_71410_x().func_184121_ak(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        Vec3d offset = new Vec3d(((Direction)blockState.func_177229_b((IProperty)DirectionalKineticBlock.FACING)).func_176730_m()).func_186678_a(factor);
        pole.translate(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        hand.translate(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        return Arrays.asList(pole, hand);
    }
}

