/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.fan;

import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.components.fan.EncasedFanTileEntity;
import com.simibubi.create.modules.contraptions.particle.AirFlowParticleData;
import com.simibubi.create.modules.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.modules.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.modules.logistics.InWorldProcessing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;

public class AirCurrent {
    private static DamageSource damageSourceFire = new DamageSource("create.fan_fire").func_76351_m().func_76361_j();
    private static DamageSource damageSourceLava = new DamageSource("create.fan_lava").func_76351_m().func_76361_j();
    public final EncasedFanTileEntity source;
    public AxisAlignedBB bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public List<AirCurrentSegment> segments = new ArrayList<AirCurrentSegment>();
    public Direction direction;
    public boolean pushing;
    public float maxDistance;
    protected List<Pair<BeltTileEntity, InWorldProcessing.Type>> affectedBelts = new ArrayList<Pair<BeltTileEntity, InWorldProcessing.Type>>();
    protected List<Entity> caughtEntities = new ArrayList<Entity>();

    public AirCurrent(EncasedFanTileEntity source) {
        this.source = source;
    }

    public void tick() {
        World world = this.source.func_145831_w();
        Direction facing = this.direction;
        if (world.field_72995_K) {
            float offset = this.pushing ? 0.5f : this.maxDistance + 0.5f;
            Vec3d pos = VecHelper.getCenterOf((Vec3i)this.source.func_174877_v()).func_178787_e(new Vec3d(facing.func_176730_m()).func_186678_a((double)offset));
            if ((double)world.field_73012_v.nextFloat() < (Double)AllConfigs.CLIENT.fanParticleDensity.get()) {
                world.func_195594_a((IParticleData)new AirFlowParticleData((Vec3i)this.source.func_174877_v()), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
        Iterator<Entity> iterator = this.caughtEntities.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (!entity.func_174813_aQ().func_72326_a(this.bounds)) {
                iterator.remove();
                continue;
            }
            Vec3d center = VecHelper.getCenterOf((Vec3i)this.source.func_174877_v());
            Vec3i flow = (this.pushing ? facing : facing.func_176734_d()).func_176730_m();
            float sneakModifier = entity.func_70093_af() ? 4096.0f : 512.0f;
            float speed = Math.abs(this.source.getSpeed());
            double entityDistance = entity.func_213303_ch().func_72438_d(center);
            float acceleration = (float)((double)(speed / sneakModifier) / (entityDistance / (double)this.maxDistance));
            Vec3d previousMotion = entity.func_213322_ci();
            float maxAcceleration = 5.0f;
            double xIn = MathHelper.func_151237_a((double)((double)((float)flow.func_177958_n() * acceleration) - previousMotion.field_72450_a), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = MathHelper.func_151237_a((double)((double)((float)flow.func_177956_o() * acceleration) - previousMotion.field_72448_b), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = MathHelper.func_151237_a((double)((double)((float)flow.func_177952_p() * acceleration) - previousMotion.field_72449_c), (double)(-maxAcceleration), (double)maxAcceleration);
            entity.func_213317_d(previousMotion.func_178787_e(new Vec3d(xIn, yIn, zIn).func_186678_a(0.125)));
            entity.field_70143_R = 0.0f;
            if (entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).field_71135_a.field_147365_f = 0;
            }
            if (InWorldProcessing.isFrozen()) {
                return;
            }
            InWorldProcessing.Type processingType = this.getSegmentAt((float)(entityDistance -= 0.5));
            if (processingType == null) continue;
            if (entity instanceof ItemEntity) {
                InWorldProcessing.spawnParticlesForProcessing(world, entity.func_213303_ch(), processingType);
                if (!InWorldProcessing.canProcess((ItemEntity)entity, processingType)) continue;
                InWorldProcessing.applyProcessing((ItemEntity)entity, processingType);
                continue;
            }
            switch (processingType) {
                case BLASTING: {
                    entity.func_70015_d(10);
                    entity.func_70097_a(damageSourceLava, 4.0f);
                    break;
                }
                case SMOKING: {
                    entity.func_70015_d(2);
                    entity.func_70097_a(damageSourceFire, 2.0f);
                    break;
                }
                case SPLASHING: {
                    if (!entity.func_70027_ad()) break;
                    entity.func_70066_B();
                    world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187541_bC, SoundCategory.NEUTRAL, 0.7f, 1.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
                    break;
                }
            }
        }
        this.tickBelts();
    }

    public void rebuild() {
        BlockPos currentPos;
        if (this.source.getSpeed() == 0.0f) {
            this.maxDistance = 0.0f;
            this.segments.clear();
            this.bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            return;
        }
        World world = this.source.func_145831_w();
        BlockPos start = this.source.func_174877_v();
        this.direction = (Direction)this.source.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        this.pushing = this.source.getAirFlowDirection() == this.direction;
        Vec3d directionVec = new Vec3d(this.direction.func_176730_m());
        Vec3d planeVec = VecHelper.planeByNormal(directionVec);
        float offsetDistance = 0.25f;
        Vec3d[] offsets = new Vec3d[]{planeVec.func_216372_d((double)offsetDistance, (double)offsetDistance, (double)offsetDistance), planeVec.func_216372_d((double)(-offsetDistance), (double)(-offsetDistance), (double)offsetDistance), planeVec.func_216372_d((double)offsetDistance, (double)(-offsetDistance), (double)(-offsetDistance)), planeVec.func_216372_d((double)(-offsetDistance), (double)offsetDistance, (double)(-offsetDistance))};
        this.maxDistance = this.source.getMaxDistance();
        float limitedDistance = 0.0f;
        int i = 1;
        while ((float)i < this.maxDistance && world.func_195588_v(currentPos = start.func_177967_a(this.direction, i))) {
            block12: {
                VoxelShape voxelshape;
                BlockState state = world.func_180495_p(currentPos);
                if (!AirCurrent.shouldAlwaysPass(state) && !(voxelshape = state.func_215685_b((IBlockReader)world, currentPos, ISelectionContext.func_216377_a())).func_197766_b()) {
                    if (voxelshape == VoxelShapes.func_197868_b()) {
                        this.maxDistance = i - 1;
                        break;
                    }
                    for (Vec3d offset : offsets) {
                        Vec3d rayEnd;
                        Vec3d rayStart = VecHelper.getCenterOf((Vec3i)currentPos).func_178788_d(directionVec.func_186678_a(0.53125)).func_178787_e(offset);
                        BlockRayTraceResult blockraytraceresult = world.func_217296_a(rayStart, rayEnd = rayStart.func_178787_e(directionVec.func_186678_a(1.03125)), currentPos, voxelshape, state);
                        if (blockraytraceresult != null) {
                            double distance = (double)(i - 1) + blockraytraceresult.func_216347_e().func_72438_d(rayStart);
                            if (!((double)limitedDistance < distance)) continue;
                            limitedDistance = (float)distance;
                            continue;
                        }
                        break block12;
                    }
                    this.maxDistance = limitedDistance;
                    break;
                }
            }
            ++i;
        }
        AirCurrentSegment currentSegment = new AirCurrentSegment();
        this.segments.clear();
        currentSegment.startOffset = 0;
        InWorldProcessing.Type type = null;
        int limit = (int)(this.maxDistance + 0.5f);
        int searchStart = this.pushing ? 0 : limit;
        int searchEnd = this.pushing ? limit : 0;
        int searchStep = this.pushing ? 1 : -1;
        int i2 = searchStart;
        while (i2 * searchStep <= searchEnd * searchStep) {
            BlockPos currentPos2 = start.func_177967_a(this.direction, i2);
            InWorldProcessing.Type newType = InWorldProcessing.Type.byBlock((IBlockReader)world, currentPos2);
            if (newType != null) {
                type = newType;
            }
            if (currentSegment.type != type || currentSegment.startOffset == 0) {
                currentSegment.endOffset = i2;
                if (currentSegment.startOffset != 0) {
                    this.segments.add(currentSegment);
                }
                currentSegment = new AirCurrentSegment();
                currentSegment.startOffset = i2;
                currentSegment.type = type;
            }
            i2 += searchStep;
        }
        currentSegment.endOffset = searchEnd + searchStep;
        this.segments.add(currentSegment);
        if (this.maxDistance < 0.25f) {
            this.bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            float factor = this.maxDistance - 1.0f;
            Vec3d scale = directionVec.func_186678_a((double)factor);
            this.bounds = factor > 0.0f ? new AxisAlignedBB(start.func_177972_a(this.direction)).func_216361_a(scale) : new AxisAlignedBB(start.func_177972_a(this.direction)).func_191195_a(scale.field_72450_a, scale.field_72448_b, scale.field_72449_c).func_191194_a(scale);
        }
        this.findAffectedBelts();
    }

    public void findEntities() {
        this.caughtEntities.clear();
        this.caughtEntities = this.source.func_145831_w().func_72839_b(null, this.bounds);
    }

    public void findAffectedBelts() {
        World world = this.source.func_145831_w();
        BlockPos start = this.source.func_174877_v();
        this.affectedBelts.clear();
        int i = 0;
        while ((float)i < this.maxDistance + 1.0f) {
            InWorldProcessing.Type type = this.getSegmentAt(i);
            if (type != null) {
                BlockPos pos = start.func_177967_a(this.direction, i);
                TileEntity te = world.func_175625_s(pos);
                if (te != null && te instanceof BeltTileEntity) {
                    this.affectedBelts.add((Pair<BeltTileEntity, InWorldProcessing.Type>)Pair.of((Object)((BeltTileEntity)te), (Object)((Object)type)));
                }
                if (!this.direction.func_176740_k().func_200128_b() && (te = world.func_175625_s(pos = pos.func_177977_b())) != null && te instanceof BeltTileEntity) {
                    this.affectedBelts.add((Pair<BeltTileEntity, InWorldProcessing.Type>)Pair.of((Object)((BeltTileEntity)te), (Object)((Object)type)));
                }
            }
            ++i;
        }
    }

    public void tickBelts() {
        for (Pair<BeltTileEntity, InWorldProcessing.Type> pair : this.affectedBelts) {
            BeltTileEntity belt = (BeltTileEntity)pair.getKey();
            World world = belt.func_145831_w();
            InWorldProcessing.Type processingType = (InWorldProcessing.Type)((Object)pair.getRight());
            BeltTileEntity controller = belt.getControllerTE();
            if (controller == null) continue;
            controller.getInventory().forEachWithin((float)belt.index + 0.5f, 0.51f, transported -> {
                InWorldProcessing.spawnParticlesForProcessing(world, BeltHelper.getVectorForOffset(controller, transported.beltPosition), processingType);
                if (world.field_72995_K) {
                    return null;
                }
                return InWorldProcessing.applyProcessing(transported, belt, processingType);
            });
        }
    }

    public void writeToNBT(CompoundNBT nbt) {
    }

    public void readFromNBT(CompoundNBT nbt) {
    }

    private static boolean shouldAlwaysPass(BlockState state) {
        if (state.func_203425_a(Tags.Blocks.FENCES)) {
            return true;
        }
        return state.func_177230_c() == Blocks.field_150411_aY;
    }

    public InWorldProcessing.Type getSegmentAt(float offset) {
        for (AirCurrentSegment airCurrentSegment : this.segments) {
            if (offset > (float)airCurrentSegment.endOffset && this.pushing || offset < (float)airCurrentSegment.endOffset && !this.pushing) continue;
            return airCurrentSegment.type;
        }
        return null;
    }

    public static class AirCurrentSegment {
        InWorldProcessing.Type type;
        int startOffset;
        int endOffset;
    }
}

