/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.fan;

import com.simibubi.create.AllBlockTags;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.config.CKinetics;
import com.simibubi.create.modules.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.modules.contraptions.components.fan.AirCurrent;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public class EncasedFanTileEntity
extends GeneratingKineticTileEntity {
    public AirCurrent airCurrent = new AirCurrent(this);
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean isGenerator = false;
    protected boolean updateAirFlow = true;

    public EncasedFanTileEntity() {
        super(AllTileEntities.ENCASED_FAN.type);
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        super.readClientUpdate(tag);
        this.airCurrent.rebuild();
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.isGenerator = compound.func_74767_n("Generating");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("Generating", this.isGenerator);
        return super.func_189515_b(compound);
    }

    @Override
    public float calculateAddedStressCapacity() {
        return this.isGenerator ? super.calculateAddedStressCapacity() : 0.0f;
    }

    @Override
    public float calculateStressApplied() {
        return this.isGenerator ? 0.0f : super.calculateStressApplied();
    }

    @Override
    public float getGeneratedSpeed() {
        return this.isGenerator ? (float)((Integer)AllConfigs.SERVER.kinetics.generatingFanSpeed.get()).intValue() : 0.0f;
    }

    public void updateGenerator(Direction facing) {
        boolean shouldGenerate;
        boolean bl = shouldGenerate = this.field_145850_b.func_175640_z(this.field_174879_c) && facing == Direction.DOWN && this.field_145850_b.func_195588_v(this.field_174879_c.func_177977_b()) && this.blockBelowIsHot();
        if (shouldGenerate == this.isGenerator) {
            return;
        }
        this.isGenerator = shouldGenerate;
        this.updateGeneratedRotation();
    }

    public boolean blockBelowIsHot() {
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c().func_203417_a(AllBlockTags.FAN_HEATERS.tag);
    }

    public float getMaxDistance() {
        float speed = Math.abs(this.getSpeed());
        CKinetics config = AllConfigs.SERVER.kinetics;
        float distanceFactor = Math.min(speed / (float)((Integer)config.fanRotationArgmax.get()).intValue(), 1.0f);
        float pushDistance = MathHelper.func_219799_g((float)distanceFactor, (float)3.0f, (float)((Integer)config.fanPushDistance.get()).intValue());
        float pullDistance = MathHelper.func_219799_g((float)distanceFactor, (float)3.0f, (float)((Integer)config.fanPullDistance.get()).intValue());
        return this.getSpeed() > 0.0f ? pushDistance : pullDistance;
    }

    public Direction getAirFlowDirection() {
        if (this.getSpeed() == 0.0f) {
            return null;
        }
        Direction facing = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        return this.getSpeed() > 0.0f ? facing : facing.func_176734_d();
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateAirFlow = true;
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)AllConfigs.SERVER.kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            this.sendData();
        }
        if (this.getSpeed() == 0.0f || this.isGenerator) {
            return;
        }
        if (this.entitySearchCooldown-- <= 0) {
            this.entitySearchCooldown = 5;
            this.airCurrent.findEntities();
        }
        this.airCurrent.tick();
    }
}

