/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.flywheel;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.modules.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.modules.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.modules.contraptions.components.flywheel.FlywheelTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IEnviromentBlockReader;

public class FlywheelRenderer
extends KineticTileEntityRenderer {
    @Override
    public void renderFast(KineticTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder buffer) {
        super.renderFast(te, x, y, z, partialTicks, destroyStage, buffer);
        BlockState blockState = te.func_195044_w();
        FlywheelTileEntity wte = (FlywheelTileEntity)te;
        SuperByteBuffer wheel = AllBlockPartials.FLYWHEEL.renderOnHorizontal(blockState.func_185907_a(Rotation.CLOCKWISE_90));
        float speed = wte.visualSpeed.get(partialTicks) * 3.0f / 10.0f;
        float angle = wte.angle + speed * partialTicks;
        if (FlywheelBlock.isConnected(blockState)) {
            Direction connection = FlywheelBlock.getConnection(blockState);
            int light = blockState.func_215684_a((IEnviromentBlockReader)this.func_178459_a(), te.func_174877_v().func_177972_a(connection));
            float rotation = connection.func_176740_k() == Direction.Axis.X ^ connection.func_176743_c() == Direction.AxisDirection.NEGATIVE ? -angle : angle;
            boolean flip = blockState.func_177229_b(FlywheelBlock.CONNECTION) == FlywheelBlock.ConnectionState.LEFT;
            this.rotateToFacing(this.transformConnector(AllBlockPartials.FLYWHEEL_UPPER_ROTATING.renderOn(blockState), true, true, rotation, flip), connection).translate(x, y, z).light(light).renderInto(buffer);
            this.rotateToFacing(this.transformConnector(AllBlockPartials.FLYWHEEL_LOWER_ROTATING.renderOn(blockState), false, true, rotation, flip), connection).translate(x, y, z).light(light).renderInto(buffer);
            this.rotateToFacing(this.transformConnector(AllBlockPartials.FLYWHEEL_UPPER_SLIDING.renderOn(blockState), true, false, rotation, flip), connection).translate(x, y, z).light(light).renderInto(buffer);
            this.rotateToFacing(this.transformConnector(AllBlockPartials.FLYWHEEL_LOWER_SLIDING.renderOn(blockState), false, false, rotation, flip), connection).translate(x, y, z).light(light).renderInto(buffer);
        }
        FlywheelRenderer.kineticRotationTransform(wheel, te, ((Direction)blockState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176740_k(), AngleHelper.rad(angle), this.func_178459_a());
        wheel.translate(x, y, z).renderInto(buffer);
    }

    @Override
    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        return AllBlockPartials.SHAFT_HALF.renderOnDirectional(te.func_195044_w(), ((Direction)te.func_195044_w().func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING)).func_176734_d());
    }

    protected SuperByteBuffer transformConnector(SuperByteBuffer buffer, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = upper ? 0.25f : 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = MathHelper.func_76126_a((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = MathHelper.func_219799_g((float)((MathHelper.func_76126_a((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        if (flip && !upper) {
            buffer.translate(0.5625f, 0.0f, 0.0f);
        }
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        if (rotating) {
            buffer.rotate(Direction.Axis.X, AngleHelper.rad(barAngle));
        }
        buffer.translate(pivotX, pivotY, pivotZ + shifting);
        return buffer;
    }

    protected SuperByteBuffer rotateToFacing(SuperByteBuffer buffer, Direction facing) {
        buffer.rotateCentered(Direction.Axis.Y, AngleHelper.rad(AngleHelper.horizontalAngle(facing)));
        return buffer;
    }
}

