/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.flywheel;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.modules.contraptions.base.GeneratingKineticTileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;

public class FlywheelTileEntity
extends GeneratingKineticTileEntity {
    private float generatedCapacity;
    private float generatedSpeed;
    private int stoppingCooldown;
    InterpolatedChasingValue visualSpeed = new InterpolatedChasingValue();
    float angle;

    public FlywheelTileEntity() {
        super(AllTileEntities.FLYWHEEL.type);
    }

    public void setRotation(float speed, float capacity) {
        if (this.generatedSpeed != speed || this.generatedCapacity != capacity) {
            if (speed == 0.0f) {
                if (this.stoppingCooldown == 0) {
                    this.stoppingCooldown = 40;
                }
                return;
            }
            this.stoppingCooldown = 0;
            this.generatedSpeed = speed;
            this.generatedCapacity = capacity;
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        return this.generatedSpeed;
    }

    @Override
    public float calculateAddedStressCapacity() {
        return this.generatedCapacity;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(2.0);
    }

    @Override
    public CompoundNBT writeToClient(CompoundNBT compound) {
        return super.writeToClient(compound);
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        super.readClientUpdate(tag);
        this.visualSpeed.withSpeed(0.03125f).target(this.generatedSpeed);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74776_a("GeneratedSpeed", this.generatedSpeed);
        compound.func_74776_a("GeneratedCapacity", this.generatedCapacity);
        compound.func_74768_a("Cooldown", this.stoppingCooldown);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.generatedSpeed = compound.func_74760_g("GeneratedSpeed");
        this.generatedCapacity = compound.func_74760_g("GeneratedCapacity");
        this.stoppingCooldown = compound.func_74762_e("Cooldown");
        super.func_145839_a(compound);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.visualSpeed.target(this.generatedSpeed);
            this.visualSpeed.tick();
            this.angle += this.visualSpeed.value * 3.0f / 10.0f;
            this.angle %= 360.0f;
            return;
        }
        if (this.stoppingCooldown == 0) {
            return;
        }
        --this.stoppingCooldown;
        if (this.stoppingCooldown == 0) {
            this.generatedCapacity = 0.0f;
            this.generatedSpeed = 0.0f;
            this.updateGeneratedRotation();
        }
    }
}

