/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.mixer;

import com.simibubi.create.AllRecipes;
import com.simibubi.create.modules.contraptions.processing.BasinTileEntity;
import com.simibubi.create.modules.contraptions.processing.ProcessingIngredient;
import com.simibubi.create.modules.contraptions.processing.ProcessingOutput;
import com.simibubi.create.modules.contraptions.processing.ProcessingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MixingRecipe
extends ProcessingRecipe<BasinTileEntity.BasinInputInventory> {
    public MixingRecipe(ResourceLocation id, String group, List<ProcessingIngredient> ingredients, List<ProcessingOutput> results, int processingDuration) {
        super(AllRecipes.MIXING, id, group, ingredients, results, processingDuration);
    }

    @Override
    protected int getMaxInputCount() {
        return 9;
    }

    @Override
    protected int getMaxOutputCount() {
        return 1;
    }

    @Override
    protected boolean canHaveCatalysts() {
        return true;
    }

    public boolean matches(BasinTileEntity.BasinInputInventory inv, World worldIn) {
        if (inv.func_191420_l()) {
            return false;
        }
        NonNullList<Ingredient> ingredients = this.func_192400_c();
        if (!ingredients.stream().allMatch(Ingredient::isSimple)) {
            return false;
        }
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack itemstack = inv.func_70301_a(slot);
            if (itemstack.func_190926_b()) continue;
            remaining.add(itemstack.func_77946_l());
        }
        LinkedList<Ingredient> sortedIngredients = new LinkedList<Ingredient>((Collection<Ingredient>)ingredients);
        sortedIngredients.sort((i1, i2) -> i1.func_193365_a().length - i2.func_193365_a().length);
        block1: for (Ingredient ingredient : sortedIngredients) {
            for (ItemStack stack : remaining) {
                if (stack.func_190926_b() || !ingredient.test(stack)) continue;
                stack.func_190918_g(1);
                continue block1;
            }
            return false;
        }
        return true;
    }

    public static MixingRecipe of(IRecipe<?> recipe) {
        return new MixingRecipe(recipe.func_199560_c(), recipe.func_193358_e(), ProcessingIngredient.list((List<Ingredient>)recipe.func_192400_c()), Arrays.asList(new ProcessingOutput(recipe.func_77571_b(), 1.0f)), -1);
    }
}

