/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.motor;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.modules.contraptions.components.motor.MotorBlock;
import java.util.List;

public class MotorTileEntity
extends GeneratingKineticTileEntity {
    public static final int DEFAULT_SPEED = 16;
    protected ScrollValueBehaviour generatedSpeed;

    public MotorTileEntity() {
        super(AllTileEntities.MOTOR.type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        Integer max = (Integer)AllConfigs.SERVER.kinetics.maxMotorSpeed.get();
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> motor.func_177229_b(MotorBlock.HORIZONTAL_FACING) == side.func_176734_d());
        this.generatedSpeed = new ScrollValueBehaviour(Lang.translate("generic.speed", new Object[0]), this, slot);
        this.generatedSpeed.between(-max.intValue(), max);
        this.generatedSpeed.value = 16;
        this.generatedSpeed.scrollableValue = 16;
        this.generatedSpeed.withUnit(i -> Lang.translate("generic.unit.rpm", new Object[0]));
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        this.generatedSpeed.withStepFunction(MotorTileEntity::step);
        behaviours.add(this.generatedSpeed);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        return this.generatedSpeed.getValue();
    }

    public static int step(ScrollValueBehaviour.StepContext context) {
        if (context.shift) {
            return 1;
        }
        int current = context.currentValue;
        int magnitude = Math.abs(current) - (context.forward == current > 0 ? 0 : 1);
        int step = 1;
        if (magnitude >= 4) {
            step *= 4;
        }
        if (magnitude >= 32) {
            step *= 4;
        }
        if (magnitude >= 128) {
            step *= 4;
        }
        return step;
    }
}

